/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.itertools.CombinationsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PAbstractCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinationsWithReplacement;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCombinations, PythonBuiltinClassType.PCombinationsWithReplacement})
public final class CombinationsBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CombinationsBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object setState(VirtualFrame frame, PAbstractCombinations self, Object state, @Bind(value="this") Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached CastToJavaIntLossyNode catsToIntNode, @Cached InlinedConditionProfile noResultProfile, @Cached InlinedLoopConditionProfile indicesProfile) {
            if (!(state instanceof PTuple)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "a length 1 or 2 tuple");
            }
            int len = (Integer)lenNode.execute(frame, state);
            if (len != 3) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "a length 1 or 2 tuple");
            }
            PList indices = (PList)getItemNode.execute(frame, state, (Object)0);
            Object[] obj = toArrayNode.execute(inliningTarget, indices.getSequenceStorage());
            int[] intIndices = new int[obj.length];
            indicesProfile.profileCounted(inliningTarget, (long)obj.length);
            int i = 0;
            while (indicesProfile.inject(inliningTarget, i < obj.length)) {
                intIndices[i] = catsToIntNode.execute(inliningTarget, obj[i]);
                ++i;
            }
            self.setIndices(intIndices);
            Object lastResult = getItemNode.execute(frame, state, (Object)1);
            if (noResultProfile.profile(inliningTarget, lastResult instanceof PNone)) {
                self.setLastResult(null);
            } else {
                obj = toArrayNode.execute(inliningTarget, ((PList)lastResult).getSequenceStorage());
                self.setLastResult(obj);
            }
            Object stopped = getItemNode.execute(frame, state, (Object)2);
            self.setStopped((Boolean)stopped);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isNull(self)"})
        Object reduceNoResult(PAbstractCombinations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClassNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            Object[] obj = new Object[self.getIndices().length];
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = self.getIndices()[i];
            }
            PTuple tuple = this.factory().createTuple(new Object[]{this.factory().createList(self.getPool()), self.getR()});
            return this.factory().createTuple(new Object[]{type, tuple});
        }

        @Specialization(guards={"!isNull(self)"})
        Object reduce(PAbstractCombinations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClassNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            Object[] obj = new Object[self.getIndices().length];
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = self.getIndices()[i];
            }
            PList indices = this.factory().createList(obj);
            PNone lastResult = self.getLastResult() == null ? PNone.NONE : this.factory().createList(self.getLastResult());
            PTuple tuple1 = this.factory().createTuple(new Object[]{this.factory().createList(self.getPool()), self.getR()});
            PTuple tuple2 = this.factory().createTuple(new Object[]{indices, lastResult, self.isStopped()});
            return this.factory().createTuple(new Object[]{type, tuple1, tuple2});
        }

        protected boolean isNull(PAbstractCombinations self) {
            return self.getLastResult() == null;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isStopped()"})
        Object nextStopped(PAbstractCombinations self) {
            throw this.raiseStopIteration();
        }

        @Specialization(guards={"!self.isStopped()", "isLastResultNull(self)"})
        Object nextNoResult(PAbstractCombinations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared PythonObjectFactory factory, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopConditionProfile) {
            Object[] result = new Object[self.getR()];
            loopConditionProfile.profileCounted(inliningTarget, (long)self.getR());
            int i = 0;
            while (loopConditionProfile.inject(inliningTarget, i < self.getR())) {
                int idx = self.getIndices()[i];
                result[i] = self.getPool()[idx];
                ++i;
            }
            self.setLastResult(result);
            return factory.createTuple(result);
        }

        @Specialization(guards={"!self.isStopped()", "!isLastResultNull(self)"})
        Object next(PCombinations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared PythonObjectFactory factory, @Cached @Cached.Shared InlinedLoopConditionProfile indexLoopProfile, @Cached @Cached.Shared InlinedLoopConditionProfile resultLoopProfile) {
            return this.nextInternal(inliningTarget, self, factory, indexLoopProfile, resultLoopProfile);
        }

        @Specialization(guards={"!self.isStopped()", "!isLastResultNull(self)"})
        Object next(PCombinationsWithReplacement self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared PythonObjectFactory factory, @Cached @Cached.Shared InlinedLoopConditionProfile indexLoopProfile, @Cached @Cached.Shared InlinedLoopConditionProfile resultLoopProfile) {
            return this.nextInternal(inliningTarget, self, factory, indexLoopProfile, resultLoopProfile);
        }

        private Object nextInternal(Node inliningTarget, PAbstractCombinations self, PythonObjectFactory factory, InlinedLoopConditionProfile indexLoopProfile, InlinedLoopConditionProfile resultLoopProfile) throws PException {
            int i;
            CompilerAsserts.partialEvaluationConstant(self.getClass());
            Object[] result = PythonUtils.arrayCopyOf(self.getLastResult(), self.getLastResult().length);
            int poolLen = self.getPool().length;
            for (i = self.getR() - 1; i >= 0 && self.getIndices()[i] == self.getMaximum(poolLen, i); --i) {
            }
            if (i < 0) {
                self.setStopped(true);
                throw this.raiseStopIteration();
            }
            int[] nArray = self.getIndices();
            int n = i;
            nArray[n] = nArray[n] + 1;
            indexLoopProfile.profileCounted(inliningTarget, (long)(self.getR() - i + 1));
            int j = i + 1;
            while (indexLoopProfile.inject(inliningTarget, j < self.getR())) {
                self.getIndices()[j] = self.maxIndex(j);
                ++j;
            }
            resultLoopProfile.profileCounted(inliningTarget, (long)(self.getR() - i));
            j = i;
            while (resultLoopProfile.inject(inliningTarget, j < self.getR())) {
                Object elem;
                int index = self.getIndices()[j];
                result[j] = elem = self.getPool()[index];
                ++j;
            }
            self.setLastResult(result);
            return factory.createTuple(result);
        }

        protected boolean isLastResultNull(PAbstractCombinations self) {
            return self.getLastResult() == null;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PAbstractCombinations self) {
            return self;
        }
    }
}

