/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.AbstractFunctionBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallDispatchNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFunction, PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.WrapperDescriptor})
public final class AbstractFunctionBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AbstractFunctionBuiltinsFactory.getFactories();
    }

    @Builtin(name="__text_signature__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class TextSignatureNode
    extends PythonBinaryBuiltinNode {
        private static final TruffleString ARGS = PythonUtils.tsLiteral("*args");
        private static final TruffleString KWARGS = PythonUtils.tsLiteral("**kwargs");

        @Specialization(guards={"!isBuiltinFunction(self)", "isNoValue(none)"})
        Object getFunction(PFunction self, PNone none, @Cached ReadAttributeFromObjectNode readNode) {
            Object signature = readNode.execute(self, SpecialAttributeNames.T___TEXT_SIGNATURE__);
            if (signature == PNone.NO_VALUE) {
                throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "function", "__text_signature__");
            }
            return signature;
        }

        @Specialization(guards={"!isBuiltinFunction(self)", "!isNoValue(value)"})
        static Object setFunction(PFunction self, Object value, @Cached WriteAttributeToObjectNode writeNode) {
            writeNode.execute((Object)self, SpecialAttributeNames.T___TEXT_SIGNATURE__, value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(none)"})
        protected static TruffleString getBuiltin(PBuiltinFunction self, PNone none) {
            Signature signature = self.getSignature();
            return TextSignatureNode.signatureToText(signature, false);
        }

        @CompilerDirectives.TruffleBoundary
        public static TruffleString signatureToText(Signature signature, boolean skipSelf) {
            TruffleString[] keywordNames = signature.getKeywordNames();
            boolean takesVarArgs = signature.takesVarArgs();
            boolean takesVarKeywordArgs = signature.takesVarKeywordArgs();
            TruffleString[] parameterNames = signature.getParameterIds();
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            sb.appendStringUncached(StringLiterals.T_LPAREN);
            boolean first = true;
            for (int i = 0; i < parameterNames.length; ++i) {
                if (i == 0 && BuiltinFunctionRootNode.T_DOLLAR_DECL_TYPE.equalsUncached((AbstractTruffleString)parameterNames[i], PythonUtils.TS_ENCODING)) continue;
                if (skipSelf) {
                    skipSelf = false;
                    continue;
                }
                if (!first && signature.getPositionalOnlyArgIndex() == i) {
                    first = TextSignatureNode.appendCommaIfNeeded(sb, first);
                    sb.appendCodePointUncached(47, 1, true);
                }
                first = TextSignatureNode.appendCommaIfNeeded(sb, first);
                sb.appendStringUncached(parameterNames[i]);
            }
            if (signature.getPositionalOnlyArgIndex() == parameterNames.length) {
                first = TextSignatureNode.appendCommaIfNeeded(sb, first);
                sb.appendCodePointUncached(47, 1, true);
            }
            if (takesVarArgs) {
                first = TextSignatureNode.appendCommaIfNeeded(sb, first);
                sb.appendStringUncached(ARGS);
            }
            if (keywordNames.length > 0) {
                if (!takesVarArgs) {
                    first = TextSignatureNode.appendCommaIfNeeded(sb, first);
                    sb.appendCodePointUncached(42, 1, true);
                }
                for (TruffleString keywordName : keywordNames) {
                    first = TextSignatureNode.appendCommaIfNeeded(sb, first);
                    sb.appendStringUncached(keywordName);
                    sb.appendStringUncached(StringLiterals.T_EQ);
                    sb.appendCodePointUncached(63, 1, true);
                }
            }
            if (takesVarKeywordArgs) {
                TextSignatureNode.appendCommaIfNeeded(sb, first);
                sb.appendStringUncached(KWARGS);
            }
            sb.appendStringUncached(StringLiterals.T_RPAREN);
            return sb.toStringUncached();
        }

        private static boolean appendCommaIfNeeded(TruffleStringBuilder sb, boolean first) {
            if (!first) {
                sb.appendStringUncached(StringLiterals.T_COMMA_SPACE);
            }
            return false;
        }

        @Specialization(guards={"!isNoValue(value)"})
        protected Object setBuiltin(PBuiltinFunction self, Object value) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_IS_NOT_WRITABLE, "__text_signature__", "builtin_function_or_method");
        }

        public static TextSignatureNode create() {
            return AbstractFunctionBuiltinsFactory.TextSignatureNodeFactory.create();
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        static PNone dict(PFunction self, PDict mapping, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, mapping);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(mapping)"})
        static Object dict(PFunction self, PNone mapping, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)"})
        PNone dict(PFunction self, Object mapping) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }

        @Specialization
        Object builtinCode(PBuiltinFunction self, Object mapping) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "builtin_function_or_method", "__dict__");
        }
    }

    @Builtin(name="__annotations__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class GetAnnotationsNode
    extends PythonBuiltinNode {
        GetAnnotationsNode() {
        }

        @Specialization(guards={"!isBuiltinFunction(self)", "isNoValue(none)"})
        Object getModule(PFunction self, PNone none, @Cached ReadAttributeFromObjectNode readObject, @Cached.Shared @Cached WriteAttributeToObjectNode writeObject) {
            Object annotations = readObject.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == PNone.NO_VALUE) {
                annotations = this.factory().createDict();
                writeObject.execute((Object)self, SpecialAttributeNames.T___ANNOTATIONS__, annotations);
            }
            return annotations;
        }

        @Specialization(guards={"!isBuiltinFunction(self)", "!isNoValue(value)"})
        static Object getModule(PFunction self, Object value, @Cached.Shared @Cached WriteAttributeToObjectNode writeObject) {
            writeObject.execute((Object)self, SpecialAttributeNames.T___ANNOTATIONS__, value);
            return PNone.NONE;
        }

        @Specialization
        Object getModule(PBuiltinFunction self, Object value) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "builtin_function_or_method", "__annotations__");
        }
    }

    @Builtin(name="__module__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class GetModuleNode
    extends PythonBuiltinNode {
        GetModuleNode() {
        }

        @Specialization(guards={"!isBuiltinFunction(self)", "isNoValue(none)"})
        static Object getModule(VirtualFrame frame, PFunction self, PNone none, @Bind(value="this") Node inliningTarget, @Cached ReadAttributeFromObjectNode readObject, @Cached ReadAttributeFromObjectNode readGlobals, @Cached PyObjectGetItem getItem, @Cached.Shared(value="writeObject") @Cached WriteAttributeToObjectNode writeObject) {
            Object module = readObject.execute(self, SpecialAttributeNames.T___MODULE__);
            if (module == PNone.NO_VALUE) {
                PythonObject globals = self.getGlobals();
                if (globals instanceof PythonModule) {
                    module = readGlobals.execute(globals, SpecialAttributeNames.T___NAME__);
                    if (module == PNone.NO_VALUE) {
                        module = PNone.NONE;
                    }
                } else {
                    try {
                        module = getItem.execute((Frame)frame, inliningTarget, globals, SpecialAttributeNames.T___NAME__);
                    }
                    catch (PException pe) {
                        module = PNone.NONE;
                    }
                }
                writeObject.execute((Object)self, SpecialAttributeNames.T___MODULE__, module);
            }
            return module;
        }

        @Specialization(guards={"!isBuiltinFunction(self)", "isDeleteMarker(value)"})
        static Object delModule(PFunction self, Object value, @Cached.Shared(value="writeObject") @Cached WriteAttributeToObjectNode writeObject) {
            writeObject.execute((Object)self, SpecialAttributeNames.T___MODULE__, (Object)PNone.NONE);
            return PNone.NONE;
        }

        @Specialization(guards={"!isBuiltinFunction(self)", "!isNoValue(value)", "!isDeleteMarker(value)"})
        static Object setModule(PFunction self, Object value, @Cached.Shared(value="writeObject") @Cached WriteAttributeToObjectNode writeObject) {
            writeObject.execute((Object)self, SpecialAttributeNames.T___MODULE__, value);
            return PNone.NONE;
        }

        @Specialization
        Object getModule(PBuiltinFunction self, Object value) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "builtin_function_or_method", "__module__");
        }
    }

    @Builtin(name="__globals__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetGlobalsNode
    extends PythonBuiltinNode {
        @Specialization(guards={"!isBuiltinFunction(self)"})
        Object getGlobals(PFunction self, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict, @Cached InlinedConditionProfile moduleGlobals) {
            PythonObject globals = self.getGlobals();
            if (moduleGlobals.profile(inliningTarget, globals instanceof PythonModule)) {
                return getDict.execute(inliningTarget, globals);
            }
            return globals;
        }

        @Fallback
        Object getGlobals(Object self) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "builtin_function_or_method", "__globals__");
        }
    }

    @Builtin(name="__closure__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetClosureNode
    extends PythonBuiltinNode {
        @Specialization(guards={"!isBuiltinFunction(self)"})
        Object getClosure(PFunction self) {
            Object[] closure = self.getClosure();
            if (closure == null) {
                return PNone.NONE;
            }
            return this.factory().createTuple(closure);
        }

        @Fallback
        Object getClosure(Object self) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "builtin_function_or_method", "__closure__");
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object doIt(VirtualFrame frame, PFunction self, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached.Shared @Cached CallDispatchNode dispatch) {
            return dispatch.executeCall(frame, self, createArgs.execute(self, arguments, keywords));
        }

        @Specialization
        protected Object doIt(VirtualFrame frame, PBuiltinFunction self, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached.Shared @Cached CallDispatchNode dispatch) {
            return dispatch.executeCall(frame, self, createArgs.execute(self, arguments, keywords));
        }
    }
}

