/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.contextvars.ContextVarBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsToken;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ContextVar})
public final class ContextVarBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextVarBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object classGetItem(Object cls, Object key) {
            return this.factory().createGenericAlias(cls, key);
        }
    }

    @Builtin(name="reset", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ResetNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object reset(PContextVar self, PContextVarsToken token, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raise) {
            if (self == token.getVar()) {
                token.use(inliningTarget, raise);
                PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
                if (token.getOldValue() == null) {
                    PContextVarsContext context = threadState.getContextVarsContext();
                    context.contextVarValues = context.contextVarValues.without(self, self.getHash());
                } else {
                    self.setValue(threadState, token.getOldValue());
                }
            } else {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.TOKEN_FOR_DIFFERENT_CONTEXTVAR, token);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isToken(token)"})
        Object doError(PContextVar self, Object token, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raise) {
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_TOKEN_EXPECTED, token);
        }

        static boolean isToken(Object obj) {
            return obj instanceof PContextVarsToken;
        }
    }

    @Builtin(name="set", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object set(PContextVar self, Object value) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            Object oldValue = self.getValue(threadState);
            self.setValue(threadState, value);
            return this.factory().createContextVarsToken(self, oldValue);
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(def)"})
        Object get(PContextVar self, PNone def) {
            return this.get(self, PContextVar.NO_DEFAULT);
        }

        @Specialization(guards={"!isNoValue(def)"})
        Object get(PContextVar self, Object def) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            Object value = self.get(threadState, def);
            if (value != null) {
                return value;
            }
            throw this.raise(PythonBuiltinClassType.LookupError);
        }
    }
}

