/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.contextvars.ContextBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.PContextIterator;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ContextVarsContext})
public final class ContextBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextBuiltinsFactory.getFactories();
    }

    private static Object getContextVar(Node inliningTarget, PContextVarsContext self, Object key, Object def, PRaiseNode.Lazy raise) {
        if (key instanceof PContextVar) {
            PContextVar ctxVar = (PContextVar)key;
            Object value = self.contextVarValues.lookup(key, ctxVar.getHash());
            if (value == null) {
                if (def == null) {
                    throw raise.get(inliningTarget).raise(PythonBuiltinClassType.KeyError, new Object[]{key});
                }
                return def;
            }
            return value;
        }
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CONTEXTVAR_KEY_EXPECTED, key);
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class Contains
    extends PythonBuiltinNode {
        @Specialization
        boolean doIn(PContextVarsContext self, Object key, @Cached PRaiseNode raise) {
            if (key instanceof PContextVar) {
                PContextVar var = (PContextVar)key;
                return self.contextVarValues.lookup(var, var.getHash()) != null;
            }
            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CONTEXTVAR_KEY_EXPECTED, key);
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetMethod
    extends PythonBuiltinNode {
        @Specialization
        Object doGetDefault(PContextVarsContext self, Object key, Object def, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile noValueProfile, @Cached PRaiseNode.Lazy raise) {
            Object defVal = noValueProfile.profile(inliningTarget, PGuards.isNoValue(def)) ? PNone.NONE : def;
            return ContextBuiltins.getContextVar(inliningTarget, self, key, defVal, raise);
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Copy
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doCopy(PContextVarsContext self) {
            PContextVarsContext ret = this.factory().createContextVarsContext();
            ret.contextVarValues = self.contextVarValues;
            return ret;
        }
    }

    @Builtin(name="run", takesVarArgs=true, takesVarKeywordArgs=true, minNumOfPositionalArgs=2, parameterNames={"$self", "$callable"})
    @GenerateNodeFactory
    public static abstract class Run
    extends PythonBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object get(VirtualFrame frame, PContextVarsContext self, Object fun, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached CallNode call, @Cached PRaiseNode.Lazy raise) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            self.enter(inliningTarget, threadState, raise);
            try {
                Object object = call.execute((Frame)frame, fun, args, keywords);
                return object;
            }
            finally {
                self.leave(threadState);
            }
        }
    }

    @Builtin(name="items", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Items
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object items(PContextVarsContext self) {
            return this.factory().createContextIterator(self, PContextIterator.ItemKind.ITEMS);
        }
    }

    @Builtin(name="values", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Values
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object values(PContextVarsContext self) {
            return this.factory().createContextIterator(self, PContextIterator.ItemKind.VALUES);
        }
    }

    @Builtin(name="keys", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Keys
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object keys(PContextVarsContext self) {
            return this.factory().createContextIterator(self, PContextIterator.ItemKind.KEYS);
        }
    }

    @Builtin(name="__iter__", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Iter
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object iter(PContextVarsContext self) {
            return this.factory().createContextIterator(self, PContextIterator.ItemKind.KEYS);
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetContextVar
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object get(PContextVarsContext self, Object key, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raise) {
            return ContextBuiltins.getContextVar(inliningTarget, self, key, null, raise);
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int len(PContextVarsContext self) {
            return self.contextVarValues.size();
        }
    }
}

