/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.Comparator;

public abstract class SortNodes {

    public static abstract class SortSequenceStorageNode
    extends PNodeWithContext {
        @CompilerDirectives.CompilationFinal
        private RootCallTarget comparatorCallTarget;
        private final ValueProfile keyClassProfile = ValueProfile.createIdentityProfile();

        public abstract void execute(VirtualFrame var1, SequenceStorage var2, Object var3, boolean var4);

        @Specialization
        void doEmpty(EmptySequenceStorage storage, Object keyfunc, boolean reverse) {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void sort(BoolSequenceStorage storage, PNone keyfunc, boolean reverse) {
            int length = storage.length();
            int trueValues = 0;
            boolean[] array = storage.getInternalBoolArray();
            for (int i = 0; i < length; ++i) {
                if (!array[i]) continue;
                ++trueValues;
            }
            if (!reverse) {
                Arrays.fill(array, 0, length - trueValues, false);
                Arrays.fill(array, length - trueValues, length, true);
            } else {
                Arrays.fill(array, 0, trueValues, true);
                Arrays.fill(array, trueValues, length, false);
            }
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void sort(IntSequenceStorage storage, PNone keyfunc, boolean reverse) {
            int[] array = storage.getInternalIntArray();
            int len = storage.length();
            Arrays.sort(array, 0, len);
            if (reverse) {
                SortSequenceStorageNode.reverseArray(array, len);
            }
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void sort(LongSequenceStorage storage, PNone keyfunc, boolean reverse) {
            long[] array = storage.getInternalLongArray();
            int len = storage.length();
            Arrays.sort(array, 0, len);
            if (reverse) {
                SortSequenceStorageNode.reverseArray(array, len);
            }
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void sort(DoubleSequenceStorage storage, PNone keyfunc, boolean reverse) {
            int len = storage.length();
            double[] array = storage.getInternalDoubleArray();
            Arrays.sort(array, 0, len);
            if (reverse) {
                SortSequenceStorageNode.reverseArray(array, len);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void sortStrings(ObjectSequenceStorage storage, boolean reverse) {
            Object[] array = storage.getInternalArray();
            int len = storage.length();
            Comparator comparator = reverse ? (a, b) -> StringUtils.compareStringsUncached((TruffleString)b, (TruffleString)a) : (a, b) -> StringUtils.compareStringsUncached((TruffleString)a, (TruffleString)b);
            Arrays.sort(array, 0, len, comparator);
        }

        protected boolean isStringOnly(Node inliningTarget, ObjectSequenceStorage storage, InlinedLoopConditionProfile isStringOnlyLoopProfile, InlinedCountingConditionProfile isStringOnlyBreakProfile) {
            int length = storage.length();
            Object[] array = storage.getInternalArray();
            int i = 0;
            while (isStringOnlyLoopProfile.profile(inliningTarget, i < length)) {
                Object value = array[i];
                if (isStringOnlyBreakProfile.profile(inliningTarget, !(value instanceof TruffleString))) {
                    LoopNode.reportLoopCount((Node)this, (int)i);
                    return false;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)this, (int)length);
            return true;
        }

        @Specialization
        void sortObjSeqStorage(VirtualFrame frame, ObjectSequenceStorage storage, PNone keyfunc, boolean reverse, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isStringOnlyProfile, @Cached InlinedLoopConditionProfile isStringOnlyLoopProfile, @Cached InlinedCountingConditionProfile isStringOnlyBreakProfile, @Cached.Shared @Cached ExecutionContext.CallContext callContext) {
            if (isStringOnlyProfile.profile(inliningTarget, this.isStringOnly(inliningTarget, storage, isStringOnlyLoopProfile, isStringOnlyBreakProfile))) {
                SortSequenceStorageNode.sortStrings(storage, reverse);
            } else {
                this.sortWithoutKey(frame, storage.getInternalArray(), storage.length(), reverse, callContext);
            }
        }

        @Specialization(guards={"!isPNone(keyfunc)"})
        void sort(VirtualFrame frame, ObjectSequenceStorage storage, Object keyfunc, boolean reverse, @Cached.Shared @Cached CallNode callNode, @Cached.Shared @Cached ExecutionContext.CallContext callContext) {
            this.sortWithKey(frame, storage.getInternalArray(), storage.length(), keyfunc, reverse, callNode, callContext);
        }

        @Fallback
        void sort(VirtualFrame frame, SequenceStorage storage, Object keyfunc, boolean reverse, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExecutionContext.CallContext callContext, @Cached.Shared @Cached CallNode callNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached SequenceStorageNodes.SetItemScalarNode setItemScalarNode) {
            int i;
            int len = storage.length();
            Object[] array = new Object[len];
            for (i = 0; i < len; ++i) {
                array[i] = getItemScalarNode.execute(inliningTarget, storage, i);
            }
            if (keyfunc instanceof PNone) {
                this.sortWithoutKey(frame, array, len, reverse, callContext);
            } else {
                this.sortWithKey(frame, array, len, keyfunc, reverse, callNode, callContext);
            }
            for (i = 0; i < len; ++i) {
                setItemScalarNode.execute(inliningTarget, storage, i, array[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortWithoutKey(VirtualFrame frame, Object[] array, int len, boolean reverse, ExecutionContext.CallContext callContext) {
            if (len <= 1) {
                return;
            }
            if (reverse) {
                SortSequenceStorageNode.reverseArray(array, len);
            }
            PythonLanguage language = PythonLanguage.get(this);
            Object[] arguments = PArguments.create(2);
            RootCallTarget callTarget = this.getComparatorCallTarget(language);
            if (frame == null) {
                PythonContext.PythonThreadState threadState = PythonContext.get(this).getThreadState(language);
                Object state = ExecutionContext.IndirectCalleeContext.enter(threadState, arguments, callTarget);
                try {
                    SortSequenceStorageNode.callSortWithoutKey(array, len, callTarget, arguments);
                }
                finally {
                    ExecutionContext.IndirectCalleeContext.exit(threadState, state);
                }
            } else {
                callContext.prepareCall(frame, arguments, callTarget, this);
                SortSequenceStorageNode.callSortWithoutKey(array, len, callTarget, arguments);
            }
            if (reverse) {
                SortSequenceStorageNode.reverseArray(array, len);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void callSortWithoutKey(Object[] array, int len, RootCallTarget callTarget, Object[] arguments) {
            try {
                Arrays.sort(array, 0, len, (a, b) -> {
                    PArguments.setArgument(arguments, 0, a);
                    PArguments.setArgument(arguments, 1, b);
                    ObjectComparatorRootNode.Result result = (ObjectComparatorRootNode.Result)((Object)((Object)callTarget.call(arguments)));
                    return result.value;
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortWithKey(VirtualFrame frame, Object[] array, int len, Object keyfunc, boolean reverse, CallNode callNode, ExecutionContext.CallContext callContext) {
            int i;
            if (len == 0) {
                return;
            }
            Object key = callNode.execute((Frame)frame, keyfunc, array[0]);
            if (len <= 1) {
                return;
            }
            SortingPair[] pairArray = new SortingPair[len];
            pairArray[reverse ? len - 1 : 0] = new SortingPair(key, array[0]);
            Class keyClass = (Class)this.keyClassProfile.profile(key.getClass());
            KeySortComparator keySortComparator = KeySortComparator.forClass(keyClass);
            for (i = 1; i < len; ++i) {
                key = callNode.execute((Frame)frame, keyfunc, array[i]);
                if (keySortComparator != null && key.getClass() != keySortComparator.clazz) {
                    keySortComparator = null;
                }
                pairArray[reverse ? len - i - 1 : i] = new SortingPair(key, array[i]);
            }
            if (keySortComparator != null) {
                SortSequenceStorageNode.callSortWithKey(pairArray, len, keySortComparator);
            } else {
                PythonLanguage language = PythonLanguage.get(this);
                Object[] arguments = PArguments.create(2);
                RootCallTarget callTarget = this.getComparatorCallTarget(language);
                if (frame == null) {
                    PythonContext.PythonThreadState threadState = PythonContext.get(this).getThreadState(language);
                    Object state = ExecutionContext.IndirectCalleeContext.enter(threadState, arguments, callTarget);
                    try {
                        SortSequenceStorageNode.callSortWithKey(pairArray, len, callTarget, arguments);
                    }
                    finally {
                        ExecutionContext.IndirectCalleeContext.exit(threadState, state);
                    }
                } else {
                    callContext.prepareCall(frame, arguments, callTarget, this);
                    SortSequenceStorageNode.callSortWithKey(pairArray, len, callTarget, arguments);
                }
            }
            for (i = 0; i < len; ++i) {
                array[reverse ? len - i - 1 : i] = pairArray[i].value;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void callSortWithKey(SortingPair[] array, int len, KeySortComparator comparator) {
            Arrays.sort(array, 0, len, comparator.comparator);
        }

        @CompilerDirectives.TruffleBoundary
        private static void callSortWithKey(SortingPair[] array, int len, RootCallTarget callTarget, Object[] arguments) {
            try {
                Arrays.sort(array, 0, len, (a, b) -> {
                    PArguments.setArgument(arguments, 0, a.key);
                    PArguments.setArgument(arguments, 1, b.key);
                    ObjectComparatorRootNode.Result result = (ObjectComparatorRootNode.Result)((Object)((Object)callTarget.call(arguments)));
                    return result.value;
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void reverseArray(Object[] array, int len) {
            for (int i = 0; i < len / 2; ++i) {
                Object tmp = array[len - i - 1];
                array[len - i - 1] = array[i];
                array[i] = tmp;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void reverseArray(int[] array, int len) {
            for (int i = 0; i < len / 2; ++i) {
                int tmp = array[len - i - 1];
                array[len - i - 1] = array[i];
                array[i] = tmp;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void reverseArray(long[] array, int len) {
            for (int i = 0; i < len / 2; ++i) {
                long tmp = array[len - i - 1];
                array[len - i - 1] = array[i];
                array[i] = tmp;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void reverseArray(double[] array, int len) {
            for (int i = 0; i < len / 2; ++i) {
                double tmp = array[len - i - 1];
                array[len - i - 1] = array[i];
                array[i] = tmp;
            }
        }

        private RootCallTarget getComparatorCallTarget(PythonLanguage language) {
            if (this.comparatorCallTarget == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.comparatorCallTarget = new ObjectComparatorRootNode(language).getCallTarget();
            }
            return this.comparatorCallTarget;
        }

        private static enum KeySortComparator {
            INT(Integer.class, Comparator.comparing(a -> (Integer)a.key)),
            LONG(Long.class, Comparator.comparing(a -> (Long)a.key)),
            DOUBLE(Double.class, Comparator.comparing(a -> (Double)a.key)),
            BOOLEAN(Boolean.class, Comparator.comparing(a -> (Boolean)a.key)),
            STRING(TruffleString.class, (a, b) -> StringUtils.compareStringsUncached((TruffleString)a.key, (TruffleString)b.key));

            final Class<?> clazz;
            final Comparator<SortingPair> comparator;

            private KeySortComparator(Class<?> clazz, Comparator<SortingPair> comparator) {
                this.clazz = clazz;
                this.comparator = comparator;
            }

            @ExplodeLoop
            public static KeySortComparator forClass(Class<?> clazz) {
                for (KeySortComparator c : KeySortComparator.values()) {
                    if (clazz != c.clazz) continue;
                    return c;
                }
                return null;
            }
        }
    }

    private static class ObjectComparatorRootNode
    extends PRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("a", "b"), PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
        @Node.Child
        private PyObjectIsTrueNode isTrueNode = PyObjectIsTrueNode.create();
        @Node.Child
        private BinaryComparisonNode.LtNode ltNodeA = BinaryComparisonNode.LtNode.create();
        @Node.Child
        private BinaryComparisonNode.LtNode ltNodeB = BinaryComparisonNode.LtNode.create();

        ObjectComparatorRootNode(TruffleLanguage<?> language) {
            super(language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            this.calleeContext.enter(frame);
            try {
                Object[] arguments = frame.getArguments();
                Object a = arguments[9];
                Object b = arguments[10];
                if (this.isTrueNode.executeCached((Frame)frame, this.ltNodeA.executeObject(frame, a, b))) {
                    Result result = Result.LT;
                    return result;
                }
                if (this.isTrueNode.executeCached((Frame)frame, this.ltNodeB.executeObject(frame, b, a))) {
                    Result result = Result.GT;
                    return result;
                }
                Result result = Result.EQ;
                return result;
            }
            finally {
                this.calleeContext.exit(frame, this);
            }
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        public boolean isInternal() {
            return true;
        }

        public String getName() {
            return "sort_comparator";
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }

        static enum Result {
            LT(-1),
            EQ(0),
            GT(1);

            final int value;

            private Result(int i) {
                this.value = i;
            }
        }
    }

    private static class SortingPair {
        final Object key;
        final Object value;

        public SortingPair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

