/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.LinkedHashMap;
import java.util.Map;

public class EconomicMapStorage
extends HashingStorage {
    final ObjectHashMap map;

    public static EconomicMapStorage create() {
        return new EconomicMapStorage();
    }

    public static EconomicMapStorage createWithSideEffects() {
        return new EconomicMapStorage(4, true);
    }

    public static EconomicMapStorage create(int initialCapacity) {
        return new EconomicMapStorage(initialCapacity, false);
    }

    private EconomicMapStorage(int initialCapacity, boolean hasSideEffects) {
        this.map = new ObjectHashMap(initialCapacity, hasSideEffects);
    }

    private EconomicMapStorage() {
        this(4, false);
    }

    public EconomicMapStorage(ObjectHashMap original, boolean copy) {
        this.map = copy ? original.copy() : original;
    }

    @CompilerDirectives.TruffleBoundary
    public static EconomicMapStorage create(LinkedHashMap<String, Object> map) {
        EconomicMapStorage result = new EconomicMapStorage(map.size(), false);
        EconomicMapStorage.putAllUncached(map, result);
        return result;
    }

    public static EconomicMapStorage createGeneric(LinkedHashMap<Object, Object> map) {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMapStorage result = new EconomicMapStorage(map.size(), false);
        EconomicMapStorage.putAllUncachedGeneric(map, result);
        return result;
    }

    public int length() {
        return this.map.size();
    }

    static boolean advance(ObjectHashMap.MapCursor cursor) {
        return cursor.advance();
    }

    static ObjectHashMap.DictKey getDictKey(ObjectHashMap.MapCursor cursor) {
        return cursor.getKey();
    }

    static Object getKey(ObjectHashMap.MapCursor cursor) {
        return EconomicMapStorage.getDictKey(cursor).getValue();
    }

    static Object getValue(ObjectHashMap.MapCursor cursor) {
        return cursor.getValue();
    }

    void clear() {
        this.map.clear();
    }

    public HashingStorage copy() {
        return new EconomicMapStorage(this.map, true);
    }

    protected void setValueForAllKeys(VirtualFrame frame, Node inliningTarget, Object value, ObjectHashMap.PutNode putNode, InlinedLoopConditionProfile loopProfile) {
        ObjectHashMap.MapCursor cursor = this.map.getEntries();
        int size = this.map.size();
        loopProfile.profileCounted(inliningTarget, (long)size);
        LoopNode.reportLoopCount((Node)putNode, (int)size);
        while (loopProfile.inject(inliningTarget, EconomicMapStorage.advance(cursor))) {
            putNode.put((Frame)frame, inliningTarget, this.map, EconomicMapStorage.getDictKey(cursor), value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void putUncached(TruffleString key, Object value) {
        ObjectHashMap.PutNode.putUncached(this.map, key, PyObjectHashNode.hash(key, TruffleString.HashCodeNode.getUncached()), value);
    }

    private void putUncached(Object key, Object value) {
        ObjectHashMap.PutNode.putUncached(this.map, key, PyObjectHashNode.executeUncached(key), value);
    }

    private static void putAllUncached(LinkedHashMap<String, Object> map, EconomicMapStorage result) {
        CompilerAsserts.neverPartOfCompilation();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.putUncached(TruffleString.fromJavaStringUncached((String)entry.getKey(), (TruffleString.Encoding)PythonUtils.TS_ENCODING), entry.getValue());
        }
    }

    private static void putAllUncachedGeneric(LinkedHashMap<Object, Object> map, EconomicMapStorage result) {
        CompilerAsserts.neverPartOfCompilation();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            result.putUncached(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder builder = new StringBuilder();
        builder.append("map(size=").append(this.length()).append(", {");
        String sep = "";
        ObjectHashMap.MapCursor cursor = this.map.getEntries();
        int i = 0;
        while (EconomicMapStorage.advance(cursor)) {
            if (++i >= 100) {
                builder.append("...");
                break;
            }
            builder.append(sep);
            builder.append("(").append(EconomicMapStorage.getKey(cursor)).append(",").append(EconomicMapStorage.getValue(cursor)).append(")");
            sep = ",";
        }
        builder.append("})");
        return builder.toString();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class EconomicMapSetStringKey
    extends HashingStorageNodes.SpecializedSetStringKey {
        @Specialization
        static void doIt(Node inliningTarget, HashingStorage self, TruffleString key, Object value, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.PutNode putNode) {
            putNode.put(null, inliningTarget, ((EconomicMapStorage)self).map, key, hashNode.execute((Frame)null, inliningTarget, key), value);
        }
    }
}

