/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class GraalHPyInitObject
implements TruffleObject {
    private static final String J_SET_HPY_CONTEXT_NATIVE_TYPE = "setHPyContextNativeType";
    private static final String J_SET_HPY_NATIVE_TYPE = "setHPyNativeType";
    private static final String J_SET_HPYFIELD_NATIVE_TYPE = "setHPyFieldNativeType";
    private static final String J_SET_HPY_ARRAY_NATIVE_TYPE = "setHPyArrayNativeType";
    private static final String J_SET_WCHAR_SIZE = "setWcharSize";
    private static final String J_SET_NATIVE_CACHE_FUNCTION_PTR = "setNativeCacheFunctionPtr";
    private final GraalHPyLLVMContext backend;

    public GraalHPyInitObject(GraalHPyLLVMContext backend) {
        this.backend = backend;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new PythonAbstractObject.Keys(new String[]{J_SET_HPY_CONTEXT_NATIVE_TYPE, J_SET_HPY_NATIVE_TYPE, J_SET_HPYFIELD_NATIVE_TYPE, J_SET_HPY_ARRAY_NATIVE_TYPE, J_SET_WCHAR_SIZE, J_SET_NATIVE_CACHE_FUNCTION_PTR});
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String key) {
        return switch (key) {
            case J_SET_HPY_CONTEXT_NATIVE_TYPE, J_SET_HPY_NATIVE_TYPE, J_SET_HPYFIELD_NATIVE_TYPE, J_SET_HPY_ARRAY_NATIVE_TYPE, J_SET_WCHAR_SIZE, J_SET_NATIVE_CACHE_FUNCTION_PTR -> true;
            default -> false;
        };
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String key, Object[] arguments) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
        if (arguments.length != 1) {
            throw ArityException.create((int)1, (int)1, (int)arguments.length);
        }
        switch (key) {
            case "setHPyContextNativeType": {
                this.backend.hpyContextNativeTypeID = arguments[0];
                break;
            }
            case "setHPyNativeType": {
                this.backend.hpyNativeTypeID = arguments[0];
                break;
            }
            case "setHPyFieldNativeType": {
                this.backend.hpyFieldNativeTypeID = arguments[0];
                break;
            }
            case "setHPyArrayNativeType": {
                this.backend.hpyArrayNativeTypeID = arguments[0];
                break;
            }
            case "setWcharSize": {
                this.backend.wcharSize = GraalHPyInitObject.ensureLong(arguments[0]);
                break;
            }
            case "setNativeCacheFunctionPtr": {
                this.backend.setNativeSpaceFunction = arguments[0];
                break;
            }
            default: {
                throw UnsupportedMessageException.create();
            }
        }
        return 0;
    }

    private static long ensureLong(Object object) throws UnsupportedTypeException {
        if (object instanceof Long) {
            return (Long)object;
        }
        InteropLibrary lib = InteropLibrary.getUncached((Object)object);
        if (lib.fitsInLong(object)) {
            try {
                return lib.asLong(object);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnsupportedTypeException.create((Object[])new Object[]{object}, (String)("expected long but got " + object));
    }
}

