/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.jni;

import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;

abstract class GraalHPyJNINodes {
    private GraalHPyJNINodes() {
    }

    static final class HPyJNIFromCharPointerNode
    extends GraalHPyNodes.HPyFromCharPointerNode {
        static final HPyJNIFromCharPointerNode UNCACHED = new HPyJNIFromCharPointerNode();

        private HPyJNIFromCharPointerNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString execute(GraalHPyContext hpyContext, Object charPtr, int n, TruffleString.Encoding encoding, boolean copy) {
            int length;
            if (n < 0) {
                long lcharPtr;
                if (charPtr instanceof NativePointer) {
                    NativePointer nativeCharPtr = (NativePointer)charPtr;
                    lcharPtr = nativeCharPtr.asPointer();
                } else {
                    try {
                        lcharPtr = InteropLibrary.getUncached((Object)charPtr).asPointer(charPtr);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }
                length = HPyJNIFromCharPointerNode.strlen(lcharPtr);
            } else {
                length = n;
            }
            return TruffleString.FromNativePointerNode.getUncached().execute(charPtr, 0, length, encoding, copy);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString execute(GraalHPyContext hpyContext, long charPtr, int n, TruffleString.Encoding encoding, boolean copy) {
            int length = n < 0 ? HPyJNIFromCharPointerNode.strlen(charPtr) : n;
            return TruffleString.FromNativePointerNode.getUncached().execute((Object)charPtr, 0, length, encoding, copy);
        }

        private static int strlen(long charPtr) {
            int length = 0;
            while (CArrayWrappers.UNSAFE.getByte(charPtr + (long)length) != 0) {
                ++length;
            }
            return length;
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

