/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.ReadIndexedArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarArgsNode;
import com.oracle.graal.python.nodes.argument.ReadVarKeywordsNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.logging.Level;

public abstract class GraalHPyObjectBuiltins {

    public static final class HPyObjectNewNode
    extends PRootNode {
        private static final TruffleString KW_SUPERCONS = PythonUtils.tsLiteral("$supercons");
        private static final TruffleString[] KEYWORDS_HIDDEN_SUPERCONS = new TruffleString[]{KW_SUPERCONS};
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_SUPERCONS, false);
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(HPyObjectNewNode.class);
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext;
        @Node.Child
        private ReadIndexedArgumentNode readSelfNode;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;
        @Node.Child
        private ReadIndexedArgumentNode readCallableNode;
        @Node.Child
        private GraalHPyNodes.PCallHPyFunction callHPyFunctionNode;
        @Node.Child
        private CallVarargsMethodNode callNewNode;
        private final int builtinShape;

        private static PKeyword[] createKwDefaults(Object superConstructor) {
            if (superConstructor != null) {
                return new PKeyword[]{new PKeyword(KW_SUPERCONS, superConstructor)};
            }
            return PKeyword.EMPTY_KEYWORDS;
        }

        private HPyObjectNewNode(PythonLanguage language, int builtinShape) {
            super(language);
            this.builtinShape = builtinShape;
        }

        public Object execute(VirtualFrame frame) {
            this.getCalleeContext().enter(frame);
            try {
                Object object = this.doCall(frame, this.getSuperConstructor(frame), this.getSelf(frame), this.getVarargs(frame), this.getKwargs(frame));
                return object;
            }
            finally {
                this.getCalleeContext().exit(frame, this);
            }
        }

        private Object doCall(VirtualFrame frame, Object superConstructor, Object explicitSelf, Object[] arguments, PKeyword[] keywords) {
            Object self;
            Object[] argsWithSelf;
            assert (explicitSelf != null);
            if (explicitSelf == PNone.NO_VALUE) {
                argsWithSelf = arguments;
                self = argsWithSelf[0];
            } else {
                argsWithSelf = new Object[arguments.length + 1];
                argsWithSelf[0] = explicitSelf;
                PythonUtils.arraycopy(arguments, 0, argsWithSelf, 1, arguments.length);
                self = explicitSelf;
            }
            PythonContext context = PythonContext.get((Node)this);
            Object dataPtr = null;
            Object defaultCallFunction = null;
            if (self instanceof PythonClass) {
                PythonClass pythonClass = (PythonClass)self;
                long basicSize = pythonClass.getBasicSize();
                if (basicSize > 0L) {
                    dataPtr = this.ensureCallHPyFunctionNode().call(context.getHPyContext(), GraalHPyNativeSymbol.GRAAL_HPY_CALLOC, basicSize, 1L);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(PythonUtils.formatJString("Allocated HPy object with native space of size %d at %s", basicSize, dataPtr));
                    }
                }
                defaultCallFunction = pythonClass.getHPyDefaultCallFunc();
            }
            Object result = this.ensureCallNewNode().execute((Frame)frame, superConstructor, argsWithSelf, keywords);
            assert (HPyObjectNewNode.validateSuperConstructorResult(result, this.builtinShape));
            if (result instanceof PythonObject) {
                PythonObject pythonObject = (PythonObject)result;
                if (dataPtr != null) {
                    GraalHPyData.setHPyNativeSpace(pythonObject, dataPtr);
                }
                if (defaultCallFunction != null) {
                    GraalHPyData.setHPyCallFunction(pythonObject, defaultCallFunction);
                }
            } else assert (false) : "inherited constructor of HPy type did not create a managed Python object";
            return result;
        }

        private static boolean validateSuperConstructorResult(Object result, int builtinShape) {
            return switch (builtinShape) {
                case -1, 0 -> result instanceof PythonObject;
                case 1 -> result instanceof PythonClass;
                case 2 -> result instanceof PInt;
                case 3 -> result instanceof PFloat;
                case 4 -> result instanceof PString;
                case 5 -> result instanceof PTuple;
                case 6 -> result instanceof PList;
                default -> false;
            };
        }

        private Object getSelf(VirtualFrame frame) {
            if (this.readSelfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readSelfNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(0));
            }
            return this.readSelfNode.execute(frame);
        }

        private Object[] getVarargs(VirtualFrame frame) {
            if (this.readVarargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readVarargsNode = (ReadVarArgsNode)this.insert(ReadVarArgsNode.create(true));
            }
            return this.readVarargsNode.executeObjectArray(frame);
        }

        private PKeyword[] getKwargs(VirtualFrame frame) {
            if (PArguments.getKeywordArguments((Frame)frame).length == 0) {
                return PKeyword.EMPTY_KEYWORDS;
            }
            if (this.readKwargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readKwargsNode = (ReadVarKeywordsNode)this.insert(ReadVarKeywordsNode.create());
            }
            return (PKeyword[])this.readKwargsNode.execute(frame);
        }

        private Object getSuperConstructor(VirtualFrame frame) {
            if (this.readCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length;
                this.readCallableNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readCallableNode.execute(frame);
        }

        private ExecutionContext.CalleeContext getCalleeContext() {
            if (this.calleeContext == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.calleeContext = (ExecutionContext.CalleeContext)this.insert(ExecutionContext.CalleeContext.create());
            }
            return this.calleeContext;
        }

        private static Object extractInheritedConstructor(PythonContext context, PKeyword[] keywords) {
            for (int i = 0; i < keywords.length; ++i) {
                if (keywords[i].getName() != KW_SUPERCONS) continue;
                return keywords[i].getValue();
            }
            return context.lookupType(PythonBuiltinClassType.PythonObject).getAttribute(SpecialMethodNames.T___NEW__);
        }

        private GraalHPyNodes.PCallHPyFunction ensureCallHPyFunctionNode() {
            if (this.callHPyFunctionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callHPyFunctionNode = (GraalHPyNodes.PCallHPyFunction)this.insert(GraalHPyNodesFactory.PCallHPyFunctionNodeGen.create());
            }
            return this.callHPyFunctionNode;
        }

        private CallVarargsMethodNode ensureCallNewNode() {
            if (this.callNewNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNewNode = (CallVarargsMethodNode)this.insert(CallVarargsMethodNode.create());
            }
            return this.callNewNode;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, Object superConstructor, int builtinShape) {
            PBuiltinFunction builtinFunction;
            if (superConstructor instanceof PBuiltinFunction && HPyObjectNewNode.isHPyObjectNewDecorator(builtinFunction = (PBuiltinFunction)superConstructor)) {
                return builtinFunction;
            }
            RootCallTarget callTarget = language.createCachedCallTarget(l -> new HPyObjectNewNode(language, builtinShape), HPyObjectNewNode.class, builtinShape);
            int flags = 3;
            return PythonObjectFactory.getUncached().createBuiltinFunction(SpecialMethodNames.T___NEW__, null, PythonUtils.EMPTY_OBJECT_ARRAY, HPyObjectNewNode.createKwDefaults(superConstructor), flags, callTarget);
        }

        public static Object getDecoratedSuperConstructor(PBuiltinFunction builtinFunction) {
            if (HPyObjectNewNode.isHPyObjectNewDecorator(builtinFunction)) {
                return HPyObjectNewNode.extractInheritedConstructor(PythonContext.get(null), builtinFunction.getKwDefaults());
            }
            return null;
        }

        private static boolean isHPyObjectNewDecorator(PBuiltinFunction builtinFunction) {
            return builtinFunction.getFunctionRootNode() instanceof HPyObjectNewNode;
        }
    }
}

