/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyBytesCheckExactNode;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.IndexConversionNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.BytesFormatProcessor;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PByteArray, PythonBuiltinClassType.PBytes})
public final class BytesBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BytesBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"bytes(iterable_of_ints) -> bytes\nbytes(string, encoding[, errors]) -> bytes\nbytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer\nbytes(int) -> bytes object of size given by the parameter initialized with null bytes\nbytes() -> empty bytes object\n\nConstruct an immutable array of bytes from:\n  - an iterable yielding integers in range(256)\n  - a text string encoded using the specified encoding\n  - any object implementing the buffer API.\n  - an integer");
    }

    public static CodingErrorAction toCodingErrorAction(TruffleString errors, TruffleString.EqualNode eqNode) {
        if (eqNode.execute((AbstractTruffleString)StringLiterals.T_STRICT, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
            return CodingErrorAction.REPORT;
        }
        if (eqNode.execute((AbstractTruffleString)StringLiterals.T_IGNORE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
            return CodingErrorAction.IGNORE;
        }
        if (eqNode.execute((AbstractTruffleString)StringLiterals.T_REPLACE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
            return CodingErrorAction.REPLACE;
        }
        return null;
    }

    public static CodingErrorAction toCodingErrorAction(TruffleString errors, PRaiseNode n, TruffleString.EqualNode eqNode) {
        CodingErrorAction action = BytesBuiltins.toCodingErrorAction(errors, eqNode);
        if (action != null) {
            return action;
        }
        throw n.raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ERROR_HANDLER, errors);
    }

    public static CodingErrorAction toCodingErrorAction(TruffleString errors, PythonCextBuiltins.CApiBuiltinNode n, TruffleString.EqualNode eqNode) {
        CodingErrorAction action = BytesBuiltins.toCodingErrorAction(errors, eqNode);
        if (action != null) {
            return action;
        }
        throw n.raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ERROR_HANDLER, errors);
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] doEncode(Charset charset, TruffleString s, CodingErrorAction action) throws CharacterCodingException {
        String string = s.toJavaStringUncached();
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(action).onUnmappableCharacter(action);
        CharBuffer buf = CharBuffer.allocate(string.length());
        buf.put(string);
        buf.flip();
        ByteBuffer encoded = encoder.encode(buf);
        byte[] barr = new byte[encoded.remaining()];
        encoded.get(barr);
        return barr;
    }

    @CompilerDirectives.TruffleBoundary
    protected static byte[] copyOfRange(byte[] bytes, int from, int to) {
        return Arrays.copyOfRange(bytes, from, to);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    protected static Iterator<byte[]> iterator(List<byte[]> bytes) {
        return bytes.iterator();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    protected static byte[] next(Iterator<byte[]> it) {
        return it.next();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    protected static boolean hasNext(Iterator<byte[]> it) {
        return it.hasNext();
    }

    @Builtin(name="removesuffix", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RemoveSuffixNode
    extends PythonBinaryBuiltinNode {
        RemoveSuffixNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PBytesLike remove(VirtualFrame frame, Object self, Object suffix, @Bind(value="this") Node node, @CachedLibrary(limit="1") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.CreateBytesNode create, @Cached InlinedConditionProfile profile) {
            Object selfBuffer = bufferAcquireLib.acquireReadonly(self, frame, this);
            Object suffixBuffer = bufferAcquireLib.acquireReadonly(suffix, frame, this);
            try {
                int selfBsLen = bufferLib.getBufferLength(selfBuffer);
                int suffixBsLen = bufferLib.getBufferLength(suffixBuffer);
                byte[] selfBs = bufferLib.getInternalOrCopiedByteArray(selfBuffer);
                if (profile.profile(node, selfBsLen >= suffixBsLen && suffixBsLen > 0)) {
                    byte[] suffixBs = bufferLib.getInternalOrCopiedByteArray(suffixBuffer);
                    byte[] result = new byte[selfBsLen - suffixBsLen];
                    int k = 1;
                    int i = selfBsLen - 1;
                    int j = 1;
                    while (i >= 0) {
                        if (i >= selfBsLen - suffixBsLen) {
                            if (selfBs[i] != suffixBs[suffixBsLen - j]) {
                                PBytesLike pBytesLike = create.execute(node, this.factory(), self, selfBs);
                                return pBytesLike;
                            }
                        } else {
                            result[result.length - k++] = selfBs[i];
                        }
                        --i;
                        ++j;
                    }
                    PBytesLike pBytesLike = create.execute(node, this.factory(), self, result);
                    return pBytesLike;
                }
                PBytesLike pBytesLike = create.execute(node, this.factory(), self, selfBs);
                return pBytesLike;
            }
            finally {
                bufferLib.release(selfBuffer, frame, this);
                bufferLib.release(suffixBuffer, frame, this);
            }
        }
    }

    @Builtin(name="removeprefix", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RemovePrefixNode
    extends PythonBinaryBuiltinNode {
        RemovePrefixNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PBytesLike remove(VirtualFrame frame, Object self, Object prefix, @Bind(value="this") Node node, @CachedLibrary(limit="1") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.CreateBytesNode create, @Cached InlinedConditionProfile profile) {
            Object selfBuffer = bufferAcquireLib.acquireReadonly(self, frame, this);
            Object prefixBuffer = bufferAcquireLib.acquireReadonly(prefix, frame, this);
            try {
                int selfBsLen = bufferLib.getBufferLength(selfBuffer);
                int prefixBsLen = bufferLib.getBufferLength(prefixBuffer);
                byte[] selfBs = bufferLib.getInternalOrCopiedByteArray(selfBuffer);
                if (profile.profile(node, selfBsLen >= prefixBsLen && prefixBsLen > 0)) {
                    byte[] prefixBs = bufferLib.getInternalOrCopiedByteArray(prefixBuffer);
                    byte[] result = new byte[selfBsLen - prefixBsLen];
                    int j = 0;
                    for (int i = 0; i < selfBsLen; ++i) {
                        if (i < prefixBsLen) {
                            if (selfBs[i] == prefixBs[i]) continue;
                            PBytesLike pBytesLike = create.execute(node, this.factory(), self, selfBs);
                            return pBytesLike;
                        }
                        result[j++] = selfBs[i];
                    }
                    PBytesLike pBytesLike = create.execute(node, this.factory(), self, result);
                    return pBytesLike;
                }
                PBytesLike pBytesLike = create.execute(node, this.factory(), self, selfBs);
                return pBytesLike;
            }
            finally {
                bufferLib.release(selfBuffer, frame, this);
                bufferLib.release(prefixBuffer, frame, this);
            }
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetNewargsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PTuple doBytes(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage) {
            return this.factory().createTuple(new Object[]{this.factory().createBytes(getBytesStorage.execute(inliningTarget, self))});
        }
    }

    @GenerateUncached
    public static abstract class BytesLikeNoGeneralizationNode
    extends SequenceStorageNodes.NoGeneralizationNode {
        public static final SequenceStorageNodes.GenNodeSupplier SUPPLIER = new SequenceStorageNodes.GenNodeSupplier(){

            @Override
            public SequenceStorageNodes.GeneralizationNode create() {
                return BytesBuiltinsFactory.BytesLikeNoGeneralizationNodeGen.create();
            }

            @Override
            public SequenceStorageNodes.GeneralizationNode getUncached() {
                return BytesBuiltinsFactory.BytesLikeNoGeneralizationNodeGen.getUncached();
            }
        };

        @Override
        protected final TruffleString getErrorMessage() {
            return ErrorMessages.BYTE_MUST_BE_IN_RANGE;
        }
    }

    @Builtin(name="zfill", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "width"})
    @ArgumentClinic(name="width", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class ZFillNode
    extends PythonBinaryClinicBuiltinNode {
        ZFillNode() {
        }

        @Specialization
        PBytesLike zfill(Object self, int width, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getInternalByteArrayNode, @Cached BytesNodes.CreateBytesNode create) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            return create.execute(inliningTarget, this.factory(), self, this.zfill(getInternalByteArrayNode.execute(inliningTarget, storage), storage.length(), width));
        }

        private byte[] zfill(byte[] self, int len, int width) {
            if (len >= width) {
                return self;
            }
            int fill = width - len;
            byte[] p = this.pad(self, len, fill, 0, (byte)48);
            if (len == 0) {
                return p;
            }
            if (p[fill] == 43 || p[fill] == 45) {
                p[0] = p[fill];
                p[fill] = 48;
            }
            return p;
        }

        protected byte[] pad(byte[] self, int len, int l, int r, byte fillChar) {
            int right;
            int left = l < 0 ? 0 : l;
            int n = right = r < 0 ? 0 : r;
            if (left == 0 && right == 0) {
                return self;
            }
            byte[] u = new byte[left + len + right];
            if (left > 0) {
                Arrays.fill(u, 0, left, fillChar);
            }
            int j = 0;
            for (int i = left; i < left + len; ++i) {
                u[i] = self[j];
                ++j;
            }
            if (right > 0) {
                Arrays.fill(u, left + len, u.length, fillChar);
            }
            return u;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.ZFillNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="expandtabs", minNumOfPositionalArgs=1, parameterNames={"self", "tabsize"})
    @ArgumentClinic(name="tabsize", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="8")
    @GenerateNodeFactory
    static abstract class ExpandTabsNode
    extends PythonBinaryClinicBuiltinNode {
        private static final byte T = 9;
        private static final byte N = 10;
        private static final byte R = 13;
        private static final byte S = 32;

        ExpandTabsNode() {
        }

        @Specialization
        PBytesLike expandtabs(Object self, int tabsize, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getInternalByteArrayNode, @Cached BytesNodes.CreateBytesNode create) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            if (len == 0) {
                return create.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
            }
            int max = Integer.MAX_VALUE;
            byte[] b = getInternalByteArrayNode.execute(inliningTarget, storage);
            int i = 0;
            int j = 0;
            for (byte p : b) {
                if (p == 9) {
                    if (tabsize <= 0) continue;
                    int incr = tabsize - j % tabsize;
                    if (j > max - incr) {
                        throw this.raise(PythonErrorType.OverflowError, ErrorMessages.RESULT_TOO_LONG);
                    }
                    j += incr;
                    continue;
                }
                if (j > max - 1) {
                    throw this.raise(PythonErrorType.OverflowError, ErrorMessages.RESULT_TOO_LONG);
                }
                ++j;
                if (p != 10 && p != 13) continue;
                if (i > max - j) {
                    throw this.raise(PythonErrorType.OverflowError, ErrorMessages.RESULT_TOO_LONG);
                }
                i += j;
                j = 0;
            }
            if (i > max - j) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.RESULT_TOO_LONG);
            }
            byte[] q = new byte[i + j];
            j = 0;
            int idx = 0;
            for (byte p : b) {
                if (p == 9) {
                    if (tabsize <= 0) continue;
                    i = tabsize - j % tabsize;
                    j += i;
                    while (i-- > 0) {
                        q[idx++] = 32;
                    }
                    continue;
                }
                ++j;
                q[idx++] = p;
                if (p != 10 && p != 13) continue;
                j = 0;
            }
            return create.execute(inliningTarget, this.factory(), self, q);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.ExpandTabsNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="swapcase", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SwapCaseNode
    extends PythonUnaryBuiltinNode {
        SwapCaseNode() {
        }

        @Specialization
        PBytesLike swapcase(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached BytesNodes.CreateBytesNode create) {
            byte[] b = toBytesNode.execute(null, self);
            if (b.length == 0) {
                return create.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
            }
            for (int i = 0; i < b.length; ++i) {
                b[i] = BytesUtils.isUpper(b[i]) ? BytesUtils.toLower(b[i]) : BytesUtils.toUpper(b[i]);
            }
            return create.execute(inliningTarget, this.factory(), self, b);
        }
    }

    @Builtin(name="title", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TitleNode
    extends PythonUnaryBuiltinNode {
        TitleNode() {
        }

        @Specialization
        PBytesLike title(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached BytesNodes.CreateBytesNode create) {
            byte[] b = toBytesNode.execute(null, self);
            if (b.length == 0) {
                return create.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
            }
            boolean previousIsCased = false;
            for (int i = 0; i < b.length; ++i) {
                byte c = b[i];
                if (BytesUtils.isLower(c)) {
                    if (!previousIsCased) {
                        c = BytesUtils.toUpper(c);
                    }
                    previousIsCased = true;
                } else if (BytesUtils.isUpper(c)) {
                    if (previousIsCased) {
                        c = BytesUtils.toLower(c);
                    }
                    previousIsCased = true;
                } else {
                    previousIsCased = false;
                }
                b[i] = c;
            }
            return create.execute(inliningTarget, this.factory(), self, b);
        }
    }

    @Builtin(name="capitalize", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CapitalizeNode
    extends PythonUnaryBuiltinNode {
        CapitalizeNode() {
        }

        @Specialization
        PBytesLike capitalize(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached BytesNodes.CreateBytesNode create) {
            byte[] b = toBytesNode.execute(null, self);
            if (b.length == 0) {
                return create.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
            }
            b[0] = BytesUtils.toUpper(b[0]);
            for (int i = 1; i < b.length; ++i) {
                b[i] = BytesUtils.toLower(b[i]);
            }
            return create.execute(inliningTarget, this.factory(), self, b);
        }
    }

    public static abstract class BaseTranslateNode
    extends PythonBuiltinNode {
        protected final void checkLengthOfTable(byte[] table, InlinedConditionProfile isLenTable256Profile) {
            if (isLenTable256Profile.profile((Node)this, table.length != 256)) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.TRANS_TABLE_MUST_BE_256);
            }
        }

        protected static boolean[] createDeleteTable(byte[] delete) {
            boolean[] result = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                result[i] = false;
            }
            for (byte b : delete) {
                result[b & 0xFF] = true;
            }
            return result;
        }

        protected static Result delete(byte[] self, byte[] table) {
            int length = self.length;
            byte[] result = new byte[length];
            int resultLen = 0;
            boolean[] toDelete = BaseTranslateNode.createDeleteTable(table);
            for (byte b : self) {
                if (toDelete[b & 0xFF]) continue;
                result[resultLen] = b;
                ++resultLen;
            }
            if (resultLen == length) {
                return new Result(result, false);
            }
            return new Result(Arrays.copyOf(result, resultLen), true);
        }

        protected static Result translate(byte[] self, byte[] table) {
            int length = self.length;
            byte[] result = new byte[length];
            boolean changed = false;
            for (int i = 0; i < length; ++i) {
                int idx = self[i] & 0xFF;
                byte b = table[idx];
                if (!changed && b != self[i]) {
                    changed = true;
                }
                result[i] = b;
            }
            return new Result(result, changed);
        }

        protected static Result translateAndDelete(byte[] self, byte[] table, byte[] delete) {
            int length = self.length;
            byte[] result = new byte[length];
            int resultLen = 0;
            boolean changed = false;
            boolean[] toDelete = BaseTranslateNode.createDeleteTable(delete);
            for (byte value : self) {
                int idx = value & 0xFF;
                if (toDelete[idx]) continue;
                byte b = table[idx];
                if (!changed && b != value) {
                    changed = true;
                }
                result[resultLen] = b;
                ++resultLen;
            }
            if (resultLen == length) {
                return new Result(result, changed);
            }
            return new Result(Arrays.copyOf(result, resultLen), true);
        }

        protected static class Result {
            byte[] array;
            boolean changed;

            public Result(byte[] array, boolean changed) {
                this.array = array;
                this.changed = changed;
            }
        }
    }

    @Builtin(name="maketrans", minNumOfPositionalArgs=3, isStaticmethod=true)
    @GenerateNodeFactory
    public static abstract class MakeTransNode
    extends PythonBuiltinNode {
        @Specialization
        PBytes maketrans(VirtualFrame frame, Object cls, Object from, Object to, @Cached BytesNodes.ToBytesNode toByteNode) {
            int i;
            byte[] toB;
            byte[] fromB = toByteNode.execute(frame, from);
            if (fromB.length != (toB = toByteNode.execute(frame, to)).length) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.ARGS_MUST_HAVE_SAME_LENGTH, "maketrans");
            }
            byte[] table = new byte[256];
            for (i = 0; i < 256; ++i) {
                table[i] = (byte)i;
            }
            for (i = 0; i < fromB.length; ++i) {
                table[(value = fromB[i]) < 0 ? value + 256 : value] = toB[i];
            }
            return this.factory().createBytes(table);
        }
    }

    @Builtin(name="rstrip", minNumOfPositionalArgs=1, parameterNames={"self", "bytes"})
    @GenerateNodeFactory
    static abstract class RStripNode
    extends AStripNode {
        RStripNode() {
        }

        @NeverDefault
        static RStripNode create() {
            return BytesBuiltinsFactory.RStripNodeFactory.create();
        }

        @Override
        protected byte[] getResultBytes(byte[] bs, int i) {
            byte[] out;
            int len = i + 1;
            if (len != bs.length) {
                out = new byte[len];
                PythonUtils.arraycopy(bs, 0, out, 0, len);
            } else {
                out = bs;
            }
            return out;
        }

        @Override
        protected int mod() {
            return -1;
        }

        @Override
        protected int stop(byte[] bs) {
            return -1;
        }

        @Override
        protected int start(byte[] bs) {
            return bs.length - 1;
        }
    }

    @Builtin(name="lstrip", minNumOfPositionalArgs=1, parameterNames={"self", "bytes"})
    @GenerateNodeFactory
    static abstract class LStripNode
    extends AStripNode {
        LStripNode() {
        }

        @NeverDefault
        static LStripNode create() {
            return BytesBuiltinsFactory.LStripNodeFactory.create();
        }

        @Override
        protected byte[] getResultBytes(byte[] bs, int i) {
            byte[] out;
            if (i != 0) {
                int len = bs.length - i;
                out = new byte[len];
                PythonUtils.arraycopy(bs, i, out, 0, len);
            } else {
                out = bs;
            }
            return out;
        }

        @Override
        protected int mod() {
            return 1;
        }

        @Override
        protected int stop(byte[] bs) {
            return bs.length;
        }

        @Override
        protected int start(byte[] bs) {
            return 0;
        }
    }

    @GenerateCached(value=false)
    static abstract class AStripNode
    extends PythonBinaryBuiltinNode {
        AStripNode() {
        }

        @Specialization
        PBytesLike strip(Object self, PNone bytes, @Bind(value="this") Node node, @Cached.Shared(value="createByte") @Cached BytesNodes.CreateBytesNode create, @Cached.Shared(value="toByteSelf") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bs = toBytesNode.execute(null, self);
            return create.execute(node, this.factory(), self, this.getResultBytes(bs, this.findIndex(bs)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isPNone(object)"})
        PBytesLike strip(VirtualFrame frame, Object self, Object object, @Bind(value="this") Node node, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared(value="createByte") @Cached BytesNodes.CreateBytesNode create, @Cached.Shared(value="toByteSelf") @Cached BytesNodes.ToBytesNode selfToBytesNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(object, frame, this);
            try {
                byte[] stripBs = bufferLib.getInternalOrCopiedByteArray(buffer);
                int stripBsLen = bufferLib.getBufferLength(buffer);
                byte[] bs = selfToBytesNode.execute(null, self);
                PBytesLike pBytesLike = create.execute(node, this.factory(), self, this.getResultBytes(bs, this.findIndex(bs, stripBs, stripBsLen)));
                return pBytesLike;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        @Fallback
        Object strip(Object self, Object object) {
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_ARGS, "lstrip/rstrip");
        }

        protected abstract int mod();

        protected abstract int stop(byte[] var1);

        protected abstract int start(byte[] var1);

        protected abstract byte[] getResultBytes(byte[] var1, int var2);

        protected int findIndex(byte[] bs) {
            int i;
            int stop = this.stop(bs);
            for (i = this.start(bs); i != stop && AStripNode.isWhitespace(bs[i]); i += this.mod()) {
            }
            return i;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isWhitespace(byte b) {
            return Character.isWhitespace(b);
        }

        protected int findIndex(byte[] bs, byte[] stripBs, int stripBsLen) {
            int i;
            int stop = this.stop(bs);
            block0: for (i = this.start(bs); i != stop; i += this.mod()) {
                for (int j = 0; j < stripBsLen; ++j) {
                    if (stripBs[j] == bs[i]) continue block0;
                }
            }
            return i;
        }
    }

    @Builtin(name="splitlines", minNumOfPositionalArgs=1, parameterNames={"self", "keepends"})
    @GenerateNodeFactory
    public static abstract class SplitLinesNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PList doSplitlines(Object self, Object keependsObj, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile isPNoneProfile, @Cached InlinedBranchProfile isBooleanProfile, @Cached InlinedConditionProfile keependsProfile, @Cached CastToJavaIntExactNode cast, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached ListNodes.AppendNode appendNode, @Cached BytesNodes.CreateBytesNode create) {
            boolean keepends;
            if (keependsObj instanceof Boolean) {
                Boolean b = (Boolean)keependsObj;
                isBooleanProfile.enter(inliningTarget);
                keepends = b;
            } else if (PGuards.isPNone(keependsObj)) {
                isPNoneProfile.enter(inliningTarget);
                keepends = false;
            } else {
                keepends = cast.execute(inliningTarget, keependsObj) != 0;
            }
            keepends = keependsProfile.profile(inliningTarget, keepends);
            byte[] bytes = toBytesNode.execute(null, self);
            PList list = this.factory().createList();
            int sliceStart = 0;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 10 && bytes[i] != 13) continue;
                int sliceEnd = i;
                if (bytes[i] == 13 && i + 1 != bytes.length && bytes[i + 1] == 10) {
                    ++i;
                }
                if (keepends) {
                    sliceEnd = i + 1;
                }
                byte[] slice = SplitLinesNode.copySlice(bytes, sliceStart, sliceEnd);
                appendNode.execute(list, create.execute(inliningTarget, this.factory(), self, slice));
                sliceStart = i + 1;
            }
            if (sliceStart != bytes.length) {
                byte[] slice = SplitLinesNode.copySlice(bytes, sliceStart, bytes.length);
                appendNode.execute(list, create.execute((Node)this, this.factory(), self, slice));
            }
            return list;
        }

        private static byte[] copySlice(byte[] bytes, int sliceStart, int sliceEnd) {
            byte[] slice = new byte[sliceEnd - sliceStart];
            PythonUtils.arraycopy(bytes, sliceStart, slice, 0, slice.length);
            return slice;
        }
    }

    @Builtin(name="rsplit", minNumOfPositionalArgs=1, parameterNames={"self", "sep", "maxsplit"})
    @ArgumentsClinic(value={@ArgumentClinic(name="sep", conversionClass=ExpectByteLikeNode.class, defaultValue="BytesBuiltins.AbstractSplitNode.WHITESPACE"), @ArgumentClinic(name="maxsplit", conversionClass=ExpectIntNode.class, defaultValue="Integer.MAX_VALUE")})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class RSplitNode
    extends AbstractSplitNode {
        RSplitNode() {
        }

        protected int find(byte[] bytes, int len, byte[] sep, int start, int end) {
            return BytesNodes.FindNode.find(bytes, len, sep, start, end, true);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.RSplitNodeClinicProviderGen.INSTANCE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void reverseList(ArrayList<byte[]> list) {
            Collections.reverse(list);
        }

        @Override
        protected List<byte[]> splitWhitespace(byte[] bytes, int len, int maxsplit) {
            int maxcount = maxsplit;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            int i = len - 1;
            while (maxcount-- > 0) {
                while (i >= 0 && BytesUtils.isSpace(bytes[i])) {
                    --i;
                }
                if (i < 0) break;
                int j = i--;
                while (i >= 0 && !BytesUtils.isSpace(bytes[i])) {
                    --i;
                }
                list.add(BytesBuiltins.copyOfRange(bytes, i + 1, j + 1));
            }
            if (i >= 0) {
                while (i >= 0 && BytesUtils.isSpace(bytes[i])) {
                    --i;
                }
                if (i >= 0) {
                    list.add(BytesBuiltins.copyOfRange(bytes, 0, i + 1));
                }
            }
            RSplitNode.reverseList(list);
            return list;
        }

        @Override
        protected List<byte[]> splitSingle(byte[] bytes, int len, byte sep, int maxsplit) {
            int j;
            int maxcount = maxsplit;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            int i = j = len - 1;
            block0: while (i >= 0 && maxcount-- > 0) {
                while (i >= 0) {
                    if (bytes[i] == sep) {
                        list.add(BytesBuiltins.copyOfRange(bytes, i + 1, j + 1));
                        j = --i;
                        continue block0;
                    }
                    --i;
                }
            }
            if (j >= -1) {
                list.add(BytesBuiltins.copyOfRange(bytes, 0, j + 1));
            }
            RSplitNode.reverseList(list);
            return list;
        }

        @Override
        protected List<byte[]> splitDelimiter(byte[] bytes, int len, byte[] sep, int maxsplit) {
            int pos;
            int maxcount = maxsplit;
            int sepLen = sep.length;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            if (sepLen == 1) {
                return this.splitSingle(bytes, len, sep[0], maxcount);
            }
            int j = len;
            while (maxcount-- > 0 && (pos = this.find(bytes, len, sep, 0, j)) >= 0) {
                list.add(BytesBuiltins.copyOfRange(bytes, pos + sepLen, j));
                j = pos;
            }
            list.add(BytesBuiltins.copyOfRange(bytes, 0, j));
            RSplitNode.reverseList(list);
            return list;
        }
    }

    @Builtin(name="split", minNumOfPositionalArgs=1, parameterNames={"$self", "sep", "maxsplit"})
    @ArgumentsClinic(value={@ArgumentClinic(name="sep", conversionClass=ExpectByteLikeNode.class, defaultValue="BytesBuiltins.AbstractSplitNode.WHITESPACE"), @ArgumentClinic(name="maxsplit", conversionClass=ExpectIntNode.class, defaultValue="Integer.MAX_VALUE")})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class SplitNode
    extends AbstractSplitNode {
        SplitNode() {
        }

        protected int find(byte[] bytes, int len, byte[] sep, int start, int end) {
            return BytesNodes.FindNode.find(bytes, len, sep, start, end, false);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.SplitNodeClinicProviderGen.INSTANCE;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected List<byte[]> splitWhitespace(byte[] bytes, int len, int maxsplit) {
            int maxcount = maxsplit;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            int i = 0;
            while (maxcount-- > 0) {
                while (i < len && BytesUtils.isSpace(bytes[i])) {
                    ++i;
                }
                if (i == len) break;
                int j = i++;
                while (i < len && !BytesUtils.isSpace(bytes[i])) {
                    ++i;
                }
                list.add(BytesBuiltins.copyOfRange(bytes, j, i));
            }
            if (i < len) {
                while (i < len && BytesUtils.isSpace(bytes[i])) {
                    ++i;
                }
                if (i != len) {
                    list.add(BytesBuiltins.copyOfRange(bytes, i, len));
                }
            }
            return list;
        }

        @Override
        protected List<byte[]> splitSingle(byte[] bytes, int len, byte sep, int maxsplit) {
            int maxcount = maxsplit;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            int j = 0;
            int i = 0;
            block0: while (j < len && maxcount-- > 0) {
                while (j < len) {
                    if (bytes[j] == sep) {
                        list.add(BytesBuiltins.copyOfRange(bytes, i, j));
                        i = ++j;
                        continue block0;
                    }
                    ++j;
                }
            }
            if (i <= len) {
                list.add(BytesBuiltins.copyOfRange(bytes, i, len));
            }
            return list;
        }

        @Override
        protected List<byte[]> splitDelimiter(byte[] bytes, int len, byte[] sep, int maxsplit) {
            int pos;
            int maxcount = maxsplit;
            int sepLen = sep.length;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            int i = 0;
            while (maxcount-- > 0 && (pos = this.find(bytes, len, sep, i, len)) >= 0) {
                int j = pos;
                list.add(BytesBuiltins.copyOfRange(bytes, i, j));
                i = j + sepLen;
            }
            list.add(BytesBuiltins.copyOfRange(bytes, i, len));
            return list;
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractSplitNode
    extends PythonTernaryClinicBuiltinNode {
        protected static final byte[] WHITESPACE = new byte[]{32};

        AbstractSplitNode() {
        }

        protected abstract List<byte[]> splitWhitespace(byte[] var1, int var2, int var3);

        protected abstract List<byte[]> splitSingle(byte[] var1, int var2, byte var3, int var4);

        protected abstract List<byte[]> splitDelimiter(byte[] var1, int var2, byte[] var3, int var4);

        protected static boolean isEmptySep(byte[] sep) {
            return sep.length == 0;
        }

        protected static boolean isSingleSep(byte[] sep) {
            return sep.length == 1;
        }

        protected static boolean isWhitespace(byte[] sep) {
            return sep == WHITESPACE;
        }

        private static int adjustMaxSplit(int maxsplit) {
            return maxsplit < 0 ? Integer.MAX_VALUE : maxsplit;
        }

        @Specialization(guards={"isWhitespace(sep)"})
        PList whitespace(Object self, byte[] sep, int maxsplit, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Shared(value="toBytes") @Cached SequenceStorageNodes.GetInternalByteArrayNode selfToBytesNode, @Cached.Shared(value="append") @Cached ListNodes.AppendNode appendNode, @Cached.Shared(value="create") @Cached BytesNodes.CreateBytesNode createBytesNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            byte[] splitBs = selfToBytesNode.execute(inliningTarget, storage);
            return this.getBytesResult(this.splitWhitespace(splitBs, storage.length(), AbstractSplitNode.adjustMaxSplit(maxsplit)), appendNode, self, inliningTarget, createBytesNode);
        }

        @Specialization(guards={"!isWhitespace(sep)", "isSingleSep(sep)"})
        PList single(Object self, byte[] sep, int maxsplit, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Shared(value="toBytes") @Cached SequenceStorageNodes.GetInternalByteArrayNode selfToBytesNode, @Cached.Shared(value="append") @Cached ListNodes.AppendNode appendNode, @Cached.Shared(value="create") @Cached BytesNodes.CreateBytesNode createBytesNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            byte[] splitBs = selfToBytesNode.execute(inliningTarget, storage);
            return this.getBytesResult(this.splitSingle(splitBs, storage.length(), sep[0], AbstractSplitNode.adjustMaxSplit(maxsplit)), appendNode, self, inliningTarget, createBytesNode);
        }

        @Specialization(guards={"!isWhitespace(sep)", "!isEmptySep(sep)", "!isSingleSep(sep)"})
        PList split(Object self, byte[] sep, int maxsplit, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Shared(value="toBytes") @Cached SequenceStorageNodes.GetInternalByteArrayNode selfToBytesNode, @Cached.Shared(value="append") @Cached ListNodes.AppendNode appendNode, @Cached.Shared(value="create") @Cached BytesNodes.CreateBytesNode createBytesNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            byte[] splitBs = selfToBytesNode.execute(inliningTarget, storage);
            return this.getBytesResult(this.splitDelimiter(splitBs, storage.length(), sep, AbstractSplitNode.adjustMaxSplit(maxsplit)), appendNode, self, inliningTarget, createBytesNode);
        }

        @Specialization(guards={"isEmptySep(sep)"})
        PList error(Object bytes, byte[] sep, int maxsplit) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.EMPTY_SEPARATOR);
        }

        protected final PList getBytesResult(List<byte[]> bytes, ListNodes.AppendNode appendNode, Object self, Node inliningTarget, BytesNodes.CreateBytesNode createBytesNode) {
            PList result = this.factory().createList();
            Iterator<byte[]> it = BytesBuiltins.iterator(bytes);
            while (BytesBuiltins.hasNext(it)) {
                appendNode.execute(result, createBytesNode.execute(inliningTarget, this.factory(), self, BytesBuiltins.next(it)));
            }
            return result;
        }
    }

    public static abstract class ExpectByteLikeNode
    extends ArgumentCastNode.ArgumentCastNodeWithRaiseAndIndirectCall {
        private final byte[] defaultValue;

        protected ExpectByteLikeNode(byte[] defaultValue) {
            this.defaultValue = defaultValue;
        }

        public abstract byte[] execute(VirtualFrame var1, Object var2);

        @Specialization
        byte[] handleNone(PNone none) {
            return this.defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isPNone(object)"}, limit="3")
        byte[] doBuffer(VirtualFrame frame, Object object, @CachedLibrary(value="object") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            Object buffer = bufferAcquireLib.acquireReadonly(object, frame, context, language, this);
            try {
                byte[] byArray = bufferLib.getCopiedByteArray(buffer);
                return byArray;
            }
            finally {
                bufferLib.release(buffer, frame, context, language, this);
            }
        }

        @ClinicConverterFactory
        @NeverDefault
        public static ExpectByteLikeNode create(@ClinicConverterFactory.DefaultValue byte[] defaultValue) {
            return BytesBuiltinsFactory.ExpectByteLikeNodeGen.create(defaultValue);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static ExpectByteLikeNode create() {
            return null;
        }
    }

    public static abstract class ExpectIntNode
    extends ArgumentCastNode.ArgumentCastNodeWithRaise {
        private final int defaultValue;

        protected ExpectIntNode(int defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        public abstract int executeInt(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNoValue(none)"})
        int handleNone(PNone none) {
            return this.defaultValue;
        }

        @Specialization
        static int doInt(int i) {
            return i;
        }

        @Specialization
        public int toInt(long x) {
            try {
                return PInt.intValueExact(x);
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "C long");
            }
        }

        @Specialization
        public int toInt(PInt x) {
            try {
                return x.intValueExact();
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "C long");
            }
        }

        @Specialization(guards={"!isNoValue(value)"})
        static int doOthers(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createRec()") ExpectIntNode rec, @Cached PyNumberIndexNode indexNode) {
            return rec.executeInt(frame, indexNode.execute((Frame)frame, inliningTarget, value));
        }

        protected ExpectIntNode createRec() {
            return BytesBuiltinsFactory.ExpectIntNodeGen.create(this.defaultValue);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
        @NeverDefault
        public static ExpectIntNode create(@ClinicConverterFactory.DefaultValue int defaultValue) {
            return BytesBuiltinsFactory.ExpectIntNodeGen.create(defaultValue);
        }
    }

    @Builtin(name="upper", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class UpperNode
    extends PythonUnaryBuiltinNode {
        UpperNode() {
        }

        @Specialization
        PBytesLike replace(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytes, @Cached BytesNodes.CreateBytesNode create) {
            byte[] bytes = toBytes.execute(null, self);
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = BytesUtils.toUpper(bytes[i]);
            }
            return create.execute(inliningTarget, this.factory(), self, bytes);
        }
    }

    @Builtin(name="lower", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class LowerNode
    extends PythonUnaryBuiltinNode {
        LowerNode() {
        }

        @Specialization
        PBytesLike replace(Object self, @Bind(value="this") Node node, @Cached BytesNodes.ToBytesNode toBytes, @Cached BytesNodes.CreateBytesNode create) {
            byte[] bytes = toBytes.execute(null, self);
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = BytesUtils.toLower(bytes[i]);
            }
            return create.execute(node, this.factory(), self, bytes);
        }
    }

    @Builtin(name="replace", minNumOfPositionalArgs=3, parameterNames={"$self", "old", "replacement", "count"})
    @ArgumentsClinic(value={@ArgumentClinic(name="old", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="replacement", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="count", conversionClass=ExpectIntNode.class, defaultValue="Integer.MAX_VALUE")})
    @GenerateNodeFactory
    static abstract class ReplaceNode
    extends PythonQuaternaryClinicBuiltinNode {
        ReplaceNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.ReplaceNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PBytesLike replace(Object self, Object substrBuffer, Object replacementBuffer, int count, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode toInternalBytes, @Cached InlinedConditionProfile selfSubAreEmpty, @Cached InlinedConditionProfile selfIsEmpty, @Cached InlinedConditionProfile subIsEmpty, @Cached BytesNodes.CreateBytesNode create) {
            try {
                SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
                int len = storage.length();
                byte[] bytes = toInternalBytes.execute(inliningTarget, storage);
                byte[] subBytes = bufferLib.getCopiedByteArray(substrBuffer);
                byte[] replacementBytes = bufferLib.getCopiedByteArray(replacementBuffer);
                int maxcount = count < 0 ? Integer.MAX_VALUE : count;
                if (selfSubAreEmpty.profile(inliningTarget, len == 0 && subBytes.length == 0)) {
                    PBytesLike pBytesLike = create.execute((Node)this, this.factory(), self, replacementBytes);
                    return pBytesLike;
                }
                if (selfIsEmpty.profile(inliningTarget, len == 0)) {
                    PBytesLike pBytesLike = create.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
                    return pBytesLike;
                }
                if (subIsEmpty.profile(inliningTarget, subBytes.length == 0)) {
                    PBytesLike pBytesLike = create.execute(inliningTarget, this.factory(), self, this.replaceWithEmptySub(bytes, len, replacementBytes, maxcount));
                    return pBytesLike;
                }
                byte[] newBytes = this.replace(bytes, len, subBytes, replacementBytes, maxcount);
                PBytesLike pBytesLike = create.execute(inliningTarget, this.factory(), self, newBytes);
                return pBytesLike;
            }
            finally {
                bufferLib.release(substrBuffer);
                bufferLib.release(replacementBuffer);
            }
        }

        @Fallback
        boolean error(Object self, Object substr, Object replacement, Object count) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, substr);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected byte[] replaceWithEmptySub(byte[] bytes, int len, byte[] replacementBytes, int count) {
            int replacements;
            int repLen = replacementBytes.length;
            byte[] result = new byte[len + repLen * Math.min(count, len + 1)];
            int j = 0;
            int i = 0;
            for (replacements = 0; replacements < count && i < len; ++replacements) {
                PythonUtils.arraycopy(replacementBytes, 0, result, j, repLen);
                j += repLen;
                result[j++] = bytes[i++];
            }
            if (replacements < count) {
                PythonUtils.arraycopy(replacementBytes, 0, result, j, repLen);
            }
            if (i < len) {
                PythonUtils.arraycopy(bytes, i, result, j, len - i);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected byte[] replace(byte[] bytes, int len, byte[] sub, byte[] replacementBytes, int count) {
            int pos;
            int maxcount = count;
            int subLen = sub.length;
            int repLen = replacementBytes.length;
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            int resultLen = 0;
            int i = 0;
            while (maxcount-- > 0 && (pos = BytesNodes.FindNode.find(bytes, len, sub, i, len, false)) >= 0) {
                int j = pos;
                list.add(BytesBuiltins.copyOfRange(bytes, i, j));
                list.add(replacementBytes);
                resultLen += j - i + repLen;
                i = j + subLen;
            }
            if (i == 0) {
                return BytesBuiltins.copyOfRange(bytes, 0, len);
            }
            list.add(BytesBuiltins.copyOfRange(bytes, i, len));
            resultLen += len - i;
            i = 0;
            byte[] result = new byte[resultLen];
            Iterator<byte[]> it = BytesBuiltins.iterator(list);
            while (BytesBuiltins.hasNext(it)) {
                byte[] b = BytesBuiltins.next(it);
                PythonUtils.arraycopy(b, 0, result, i, b.length);
                i += b.length;
            }
            return result;
        }
    }

    @Builtin(name="rjust", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class RJustNode
    extends CenterNode {
        RJustNode() {
        }

        @Override
        protected String methodName() {
            return "rjust()";
        }

        @Override
        protected boolean checkSkip(int len, int width) {
            return width - len <= 0;
        }

        @Override
        protected byte[] make(byte[] self, int len, int width, byte fill) {
            int l = width - len;
            int resLen = l + len;
            byte[] res = new byte[resLen];
            Arrays.fill(res, 0, l, fill);
            int j = 0;
            for (int i = l; i < len + l; ++i) {
                res[i] = self[j];
                ++j;
            }
            return res;
        }
    }

    @Builtin(name="ljust", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class LJustNode
    extends CenterNode {
        LJustNode() {
        }

        @Override
        protected String methodName() {
            return "ljust()";
        }

        @Override
        protected boolean checkSkip(int len, int width) {
            return width - len <= 0;
        }

        @Override
        protected byte[] make(byte[] self, int len, int width, byte fill) {
            int l = width - len;
            int resLen = l + len;
            byte[] res = new byte[resLen];
            PythonUtils.arraycopy(self, 0, res, 0, len);
            Arrays.fill(res, len, resLen, fill);
            return res;
        }
    }

    @Builtin(name="center", minNumOfPositionalArgs=2, parameterNames={"$self", "width", "fill"})
    @ArgumentClinic(name="width", conversionClass=IndexConversionNode.class)
    @GenerateNodeFactory
    static abstract class CenterNode
    extends PythonTernaryClinicBuiltinNode {
        CenterNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.CenterNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"isNoValue(fill)"})
        PBytesLike none(Object self, int width, PNone fill, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getInternalByteArrayNode, @Cached.Exclusive @Cached SequenceStorageNodes.CopyNode copyNode, @Cached.Exclusive @Cached BytesNodes.CreateBytesNode create) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            if (this.checkSkip(len, width)) {
                return create.execute(inliningTarget, this.factory(), self, copyNode.execute(inliningTarget, storage));
            }
            return create.execute(inliningTarget, this.factory(), self, this.make(getInternalByteArrayNode.execute(inliningTarget, storage), len, width, (byte)32));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isPNone(fill)"}, limit="3")
        PBytesLike bytes(VirtualFrame frame, Object self, Object w, Object fill, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Exclusive @Cached SequenceStorageNodes.CopyNode copyNode, @Cached.Exclusive @Cached BytesNodes.CreateBytesNode create, @CachedLibrary(value="fill") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile errorProfile) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            Object fillBuffer = acquireLib.acquireReadonly(fill, frame, this);
            try {
                if (errorProfile.profile(inliningTarget, bufferLib.getBufferLength(fillBuffer) != 1)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.FILL_CHAR_MUST_BE_LENGTH_1);
                }
                int width = asSizeNode.executeExact((Frame)frame, inliningTarget, w);
                if (this.checkSkip(len, width)) {
                    PBytesLike pBytesLike = create.execute(inliningTarget, this.factory(), self, copyNode.execute(inliningTarget, storage));
                    return pBytesLike;
                }
                PBytesLike pBytesLike = create.execute(inliningTarget, this.factory(), self, this.make(bufferLib.getCopiedByteArray(self), len, width, bufferLib.readByte(fillBuffer, 0)));
                return pBytesLike;
            }
            finally {
                bufferLib.release(fillBuffer);
            }
        }

        protected String methodName() {
            return "center()";
        }

        @Fallback
        boolean err(VirtualFrame frame, Object self, Object w, Object fill) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.BYTE_STRING_OF_LEN_ONE_ONLY, this.methodName(), fill);
        }

        protected byte[] pad(byte[] self, int l, int r, byte fill) {
            int right;
            int left = l < 0 ? 0 : l;
            int n = right = r < 0 ? 0 : r;
            if (left == 0 && right == 0) {
                return self;
            }
            byte[] u = new byte[left + self.length + right];
            if (left > 0) {
                Arrays.fill(u, 0, left, fill);
            }
            System.arraycopy(self, 0, u, left, self.length);
            if (right > 0) {
                Arrays.fill(u, left + self.length, u.length, fill);
            }
            return u;
        }

        protected byte[] make(byte[] self, int len, int width, byte fillchar) {
            int marg = width - len;
            int left = marg / 2 + (marg & width & 1);
            return this.pad(self, left, marg - left, fillchar);
        }

        protected boolean checkSkip(int len, int width) {
            return len >= width;
        }
    }

    @Builtin(name="istitle", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsTitleNode
    extends PythonUnaryClinicBuiltinNode {
        IsTitleNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                boolean cased = false;
                boolean previousIsCased = false;
                for (int i = 0; i < len; ++i) {
                    byte ch = b[i];
                    if (BytesUtils.isUpper(ch)) {
                        if (previousIsCased) {
                            boolean bl = false;
                            return bl;
                        }
                        previousIsCased = true;
                        cased = true;
                        continue;
                    }
                    if (BytesUtils.isLower(ch)) {
                        if (previousIsCased) continue;
                        boolean bl = false;
                        return bl;
                    }
                    previousIsCased = false;
                }
                boolean bl = cased;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsTitleNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isspace", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsSpaceNode
    extends PythonUnaryClinicBuiltinNode {
        IsSpaceNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                for (int i = 0; i < len; ++i) {
                    if (BytesUtils.isSpace(b[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsSpaceNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isupper", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsUpperNode
    extends PythonUnaryClinicBuiltinNode {
        IsUpperNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                int uncased = 0;
                for (int i = 0; i < len; ++i) {
                    byte ch = b[i];
                    if (BytesUtils.isUpper(ch)) continue;
                    if (BytesUtils.toLower(ch) == BytesUtils.toUpper(ch)) {
                        ++uncased;
                        continue;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = uncased == 0 || len > uncased;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsUpperNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="islower", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsLowerNode
    extends PythonUnaryClinicBuiltinNode {
        IsLowerNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                int uncased = 0;
                for (int i = 0; i < len; ++i) {
                    byte ch = b[i];
                    if (BytesUtils.isLower(ch)) continue;
                    if (BytesUtils.toLower(ch) == BytesUtils.toUpper(ch)) {
                        ++uncased;
                        continue;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = uncased == 0 || len > uncased;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsLowerNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isdigit", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsDigitNode
    extends PythonUnaryClinicBuiltinNode {
        IsDigitNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                for (int i = 0; i < len; ++i) {
                    if (BytesUtils.isDigit(b[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsDigitNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isalpha", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsAlphaNode
    extends PythonUnaryClinicBuiltinNode {
        IsAlphaNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                for (int i = 0; i < len; ++i) {
                    if (BytesUtils.isAlpha(b[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsAlphaNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isalnum", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsAlnumNode
    extends PythonUnaryClinicBuiltinNode {
        IsAlnumNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = false;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                for (int i = 0; i < len; ++i) {
                    if (BytesUtils.isAlnum(b[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsAlnumNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isascii", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IsASCIINode
    extends PythonUnaryClinicBuiltinNode {
        IsASCIINode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static boolean check(Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile earlyExit) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (earlyExit.profile(inliningTarget, len == 0)) {
                    boolean bl = true;
                    return bl;
                }
                byte[] b = bufferLib.getInternalOrCopiedByteArray(buffer);
                for (int i = 0; i < len; ++i) {
                    if (b[i] >= 0) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                bufferLib.release(buffer);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IsASCIINodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="hex", minNumOfPositionalArgs=1, parameterNames={"$self", "sep", "bytes_per_sep_group"})
    @ArgumentsClinic(value={@ArgumentClinic(name="sep", conversionClass=SepExpectByteNode.class, defaultValue="PNone.NO_VALUE"), @ArgumentClinic(name="bytes_per_sep_group", conversionClass=ExpectIntNode.class, defaultValue="1")})
    @GenerateNodeFactory
    static abstract class HexNode
    extends PythonTernaryClinicBuiltinNode {
        HexNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.HexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"check.execute(inliningTarget, self)"})
        TruffleString none(Object self, PNone sep, int bytesPerSepGroup, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BytesNodes.BytesLikeCheck check, @Cached.Shared @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Shared @Cached InlinedConditionProfile earlyExit, @Cached.Shared @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached.Shared @Cached BytesNodes.ByteToHexNode toHexNode) {
            return this.hex(self, (byte)0, 0, inliningTarget, check, getBytesStorage, earlyExit, getBytes, toHexNode);
        }

        @Specialization(guards={"check.execute(inliningTarget, self)"})
        TruffleString hex(Object self, byte sep, int bytesPerSepGroup, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BytesNodes.BytesLikeCheck check, @Cached.Shared @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Shared @Cached InlinedConditionProfile earlyExit, @Cached.Shared @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached.Shared @Cached BytesNodes.ByteToHexNode toHexNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            if (earlyExit.profile(inliningTarget, len == 0)) {
                return StringLiterals.T_EMPTY_STRING;
            }
            byte[] b = getBytes.execute(inliningTarget, storage);
            return toHexNode.execute(b, len, sep, bytesPerSepGroup);
        }

        @Fallback
        TruffleString err(Object self, Object sep, Object bytesPerSepGroup) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_NEED_OBJ, "hex", "bytes");
        }
    }

    public static abstract class SepExpectByteNode
    extends ArgumentCastNode.ArgumentCastNodeWithRaiseAndIndirectCall {
        private final Object defaultValue;

        protected SepExpectByteNode(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNoValue(none)"})
        Object none(PNone none) {
            return this.defaultValue;
        }

        @Specialization
        byte string(TruffleString str, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            if (codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING) != 1) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.SEP_MUST_BE_LENGTH_1);
            }
            int cp = codePointAtIndexNode.execute((AbstractTruffleString)str, 0, PythonUtils.TS_ENCODING);
            if (cp > 127) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.SEP_MUST_BE_ASCII);
            }
            return (byte)cp;
        }

        @Specialization
        byte pstring(PString str, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode toStr, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            return this.string(toStr.execute(inliningTarget, str), codePointLengthNode, codePointAtIndexNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"bufferAcquireLib.hasBuffer(object)"}, limit="3")
        byte doBuffer(VirtualFrame frame, Object object, @CachedLibrary(value="object") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            Object buffer = bufferAcquireLib.acquireReadonly(object, frame, this.getContext(), this.getLanguage(), this);
            try {
                if (bufferLib.getBufferLength(buffer) != 1) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.SEP_MUST_BE_LENGTH_1);
                }
                byte b = bufferLib.readByte(buffer, 0);
                if (b < 0) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.SEP_MUST_BE_ASCII);
                }
                byte by = b;
                return by;
            }
            finally {
                bufferLib.release(buffer, frame, this.getContext(), this.getLanguage(), this);
            }
        }

        @Fallback
        byte error(VirtualFrame frame, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.SEP_MUST_BE_STR_OR_BYTES);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static SepExpectByteNode create(@ClinicConverterFactory.DefaultValue Object defaultValue) {
            return BytesBuiltinsFactory.SepExpectByteNodeGen.create(defaultValue);
        }
    }

    @Builtin(name="rfind", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class RFindNode
    extends PythonQuaternaryClinicBuiltinNode {
        RFindNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.RFindNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int find(VirtualFrame frame, Object self, Object needle, int start, int end, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.FindNode findNode) {
            return findNode.executeReverse(frame, inliningTarget, self, needle, start, end);
        }
    }

    @Builtin(name="find", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class FindNode
    extends PythonQuaternaryClinicBuiltinNode {
        FindNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.FindNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int find(VirtualFrame frame, Object self, Object needle, int start, int end, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.FindNode findNode) {
            return findNode.execute(frame, inliningTarget, self, needle, start, end);
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class CountNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.CountNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int count(VirtualFrame frame, Object self, Object needle, int start, int end, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached BytesNodes.NeedleToBytesNode needleToBytesNode, @Cached SequenceStorageNodes.GetInternalByteArrayNode getInternalByteArrayNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            byte[] bytes = getInternalByteArrayNode.execute(inliningTarget, storage);
            byte[] needleBytes = needleToBytesNode.execute(frame, inliningTarget, needle);
            int begin = BytesNodes.adjustStartIndex(start, storage.length());
            int last = BytesNodes.adjustEndIndex(end, storage.length());
            return CountNode.count(bytes, len, begin, last, needleBytes);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static int count(byte[] bytes, int len, int start, int end, byte[] needleBytes) {
            int found;
            int idx = start;
            int count = 0;
            if (end - start < 0) {
                return 0;
            }
            if (needleBytes.length == 0) {
                return end - start + 1;
            }
            while (idx < end && (found = BytesNodes.FindNode.find(bytes, len, needleBytes, idx, end, false)) != -1) {
                ++count;
                idx = found + needleBytes.length;
            }
            return count;
        }
    }

    @Builtin(name="rpartition", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RPartitionNode
    extends PartitionAbstractNode {
        @Override
        protected boolean isRight() {
            return true;
        }
    }

    @Builtin(name="partition", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class PartitionNode
    extends PartitionAbstractNode {
    }

    @GenerateCached(value=false)
    public static abstract class PartitionAbstractNode
    extends PythonBinaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        PTuple partition(VirtualFrame frame, Object self, Object sep, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="sep") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached InlinedConditionProfile notFound, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached BytesNodes.CreateBytesNode createBytesNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            byte[] bytes = toBytesNode.execute(null, self);
            Object sepBuffer = acquireLib.acquireReadonly(sep, frame, this);
            try {
                PBytesLike first;
                PBytesLike third;
                PBytesLike second;
                int lenSep = bufferLib.getBufferLength(sepBuffer);
                if (lenSep == 0) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.EMPTY_SEPARATOR);
                }
                byte[] sepBytes = bufferLib.getCopiedByteArray(sepBuffer);
                int idx = BytesNodes.FindNode.find(bytes, len, sepBytes, 0, bytes.length, this.isRight());
                if (notFound.profile(inliningTarget, idx == -1)) {
                    second = createBytesNode.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
                    if (this.isRight()) {
                        third = createBytesNode.execute(inliningTarget, this.factory(), self, bytes);
                        first = createBytesNode.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
                    } else {
                        first = createBytesNode.execute(inliningTarget, this.factory(), self, bytes);
                        third = createBytesNode.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
                    }
                } else {
                    second = createBytesNode.execute(inliningTarget, this.factory(), self, sepBytes);
                    if (idx == 0) {
                        first = createBytesNode.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
                        third = createBytesNode.execute(inliningTarget, this.factory(), self, Arrays.copyOfRange(bytes, lenSep, len));
                    } else if (idx == len - 1) {
                        first = createBytesNode.execute(inliningTarget, this.factory(), self, Arrays.copyOfRange(bytes, 0, len - lenSep));
                        third = createBytesNode.execute(inliningTarget, this.factory(), self, PythonUtils.EMPTY_BYTE_ARRAY);
                    } else {
                        first = createBytesNode.execute(inliningTarget, this.factory(), self, Arrays.copyOfRange(bytes, 0, idx));
                        third = createBytesNode.execute(inliningTarget, this.factory(), self, Arrays.copyOfRange(bytes, idx + lenSep, len));
                    }
                }
                PTuple pTuple = this.factory().createTuple(new Object[]{first, second, third});
                return pTuple;
            }
            finally {
                bufferLib.release(sepBuffer);
            }
        }

        protected boolean isRight() {
            return false;
        }
    }

    @Builtin(name="rindex", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class RIndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.RIndexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int indexWithStartEnd(VirtualFrame frame, Object self, Object arg, int start, int end, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.FindNode findNode) {
            int result = findNode.executeReverse(frame, inliningTarget, self, arg, start, end);
            if (result == -1) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.SUBSECTION_NOT_FOUND);
            }
            return result;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class IndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.IndexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int index(VirtualFrame frame, Object self, Object arg, int start, int end, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.FindNode findNode) {
            int result = findNode.execute(frame, inliningTarget, self, arg, start, end);
            if (result == -1) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.SUBSECTION_NOT_FOUND);
            }
            return result;
        }
    }

    @Builtin(name="endswith", minNumOfPositionalArgs=2, parameterNames={"$self", "suffix", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class EndsWithNode
    extends PrefixSuffixBaseNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.EndsWithNodeClinicProviderGen.INSTANCE;
        }

        @Override
        protected boolean doIt(byte[] bytes, byte[] suffix, int start, int end) {
            assert (start >= 0);
            assert (end >= 0 && end <= bytes.length);
            int suffixLen = suffix.length;
            if (end - start < suffixLen) {
                return false;
            }
            for (int i = 0; i < suffix.length; ++i) {
                if (bytes[end - suffixLen + i] == suffix[i]) continue;
                return false;
            }
            return true;
        }
    }

    @Builtin(name="startswith", minNumOfPositionalArgs=2, parameterNames={"$self", "prefix", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class StartsWithNode
    extends PrefixSuffixBaseNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.StartsWithNodeClinicProviderGen.INSTANCE;
        }

        @Override
        protected boolean doIt(byte[] bytes, byte[] prefix, int start, int end) {
            assert (start >= 0);
            assert (end >= 0 && end <= bytes.length);
            if (end - start < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (bytes[start + i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PrefixSuffixDispatchNode
    extends Node {
        PrefixSuffixDispatchNode() {
        }

        abstract boolean execute(VirtualFrame var1, Node var2, PrefixSuffixBaseNode var3, byte[] var4, Object var5, int var6, int var7);

        @Specialization
        static boolean doTuple(VirtualFrame frame, Node inliningTarget, PrefixSuffixBaseNode parent, byte[] bytes, PTuple substrs, int begin, int last, @Cached(value="createToBytesFromTuple()", inline=false) BytesNodes.ToBytesNode tobytes, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            return parent.doIt(frame, bytes, substrs, begin, last, inliningTarget, tobytes, getObjectArrayNode);
        }

        @Fallback
        static boolean doOthers(VirtualFrame frame, PrefixSuffixBaseNode parent, byte[] bytes, Object substrs, int begin, int last, @Cached(value="createToBytes()", inline=false) BytesNodes.ToBytesNode tobytes) {
            byte[] substrBytes = tobytes.execute(frame, substrs);
            return parent.doIt(bytes, substrBytes, begin, last);
        }

        @NeverDefault
        static BytesNodes.ToBytesNode createToBytes() {
            return BytesNodes.ToBytesNode.create(PythonBuiltinClassType.TypeError, ErrorMessages.FIRST_ARG_MUST_BE_BYTES_OR_A_TUPLE_OF_BYTES_NOT_P);
        }

        @NeverDefault
        static BytesNodes.ToBytesNode createToBytesFromTuple() {
            return BytesNodes.ToBytesNode.create(PythonBuiltinClassType.TypeError, ErrorMessages.A_BYTES_LIKE_OBJECT_IS_REQUIRED_NOT_P);
        }
    }

    @GenerateCached(value=false)
    static abstract class PrefixSuffixBaseNode
    extends PythonQuaternaryClinicBuiltinNode {
        PrefixSuffixBaseNode() {
        }

        @Specialization
        boolean doIt(VirtualFrame frame, Object self, Object substrs, int start, int end, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached PrefixSuffixDispatchNode dispatchNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            byte[] bytes = getBytes.execute(inliningTarget, storage);
            int len = storage.length();
            int begin = BytesNodes.adjustStartIndex(start, len);
            int last = BytesNodes.adjustEndIndex(end, len);
            return dispatchNode.execute(frame, inliningTarget, this, bytes, substrs, begin, last);
        }

        @Fallback
        boolean doGeneric(Object self, Object substr, Object start, Object end) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.METHOD_REQUIRES_A_BYTES_OBJECT_GOT_P, substr);
        }

        protected abstract boolean doIt(byte[] var1, byte[] var2, int var3, int var4);

        private boolean doIt(VirtualFrame frame, byte[] self, PTuple substrs, int start, int stop, Node inliningTarget, BytesNodes.ToBytesNode tobytes, SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            for (Object element : getObjectArrayNode.execute(inliningTarget, substrs)) {
                byte[] bytes = tobytes.execute(frame, element);
                if (!this.doIt(self, bytes, start, stop)) continue;
                return true;
            }
            return false;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        PSequenceIterator contains(Object self) {
            return this.factory().createSequenceIterator(self);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        boolean contains(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.FindNode findNode) {
            return findNode.execute(frame, inliningTarget, self, other, 0, Integer.MAX_VALUE) != -1;
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static int len(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage) {
            return getBytesStorage.execute(inliningTarget, self).length();
        }
    }

    @Builtin(name="__rmod__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RModNode
    extends PythonBinaryBuiltinNode {
        RModNode() {
        }

        @Specialization
        Object mod(Object self, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__mod__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ModNode
    extends PythonBinaryBuiltinNode {
        ModNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object mod(VirtualFrame frame, Object self, Object right, @Bind(value="this") Node node, @CachedLibrary(value="self") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.CreateBytesNode create, @Cached TupleBuiltins.GetItemNode getTupleItemNode) {
            Object buffer = acquireLib.acquireReadonly(self, frame, this);
            try {
                PBytesLike pBytesLike;
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int bytesLen = bufferLib.getBufferLength(buffer);
                BytesFormatProcessor formatter = new BytesFormatProcessor(PythonContext.get(this), this.getRaiseNode(), getTupleItemNode, bytes, bytesLen);
                Object savedState = ExecutionContext.IndirectCallContext.enter(frame, this);
                try {
                    byte[] data = (byte[])formatter.format(right);
                    pBytesLike = create.execute(node, this.factory(), self, data);
                }
                catch (Throwable throwable) {
                    ExecutionContext.IndirectCallContext.exit(frame, this, savedState);
                    throw throwable;
                }
                ExecutionContext.IndirectCallContext.exit(frame, this, savedState);
                return pBytesLike;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends AbstractComparisonNode {
        GeNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult >= 0;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends AbstractComparisonNode {
        GtNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult > 0;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends AbstractComparisonNode {
        LeNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult <= 0;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends AbstractComparisonNode {
        LtNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult < 0;
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NeNode
    extends AbstractComparisonNode {
        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult != 0;
        }

        @Override
        protected boolean shortcutLength() {
            return true;
        }

        @Override
        protected boolean shortcutLengthResult() {
            return true;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends AbstractComparisonNode {
        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult == 0;
        }

        @Override
        protected boolean shortcutLength() {
            return true;
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractComparisonNode
    extends BytesNodes.AbstractComparisonBaseNode {
        AbstractComparisonNode() {
        }

        @Specialization
        boolean cmp(PBytes self, PBytes other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray) {
            SequenceStorage selfStorage = self.getSequenceStorage();
            SequenceStorage otherStorage = other.getSequenceStorage();
            return this.doCmp(getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
        }

        @Fallback
        Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyBytesCheckNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray) {
            if (check.execute(inliningTarget, self)) {
                if (check.execute(inliningTarget, other)) {
                    SequenceStorage selfStorage = getBytesStorage.execute(inliningTarget, self);
                    SequenceStorage otherStorage = getBytesStorage.execute(inliningTarget, other);
                    return this.doCmp(getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
                }
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__eq__", "bytes", self);
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        long hash(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="self") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.HashBufferNode hashBufferNode) {
            Object buffer = acquireLib.acquireReadonly(self, frame, this);
            try {
                long l = hashBufferNode.execute(inliningTarget, buffer);
                return l;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    public static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public PBytesLike mul(VirtualFrame frame, Object self, Object times, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached PyNumberAsSizeNode asSizeNode, @Cached(value="createWithOverflowError()") SequenceStorageNodes.RepeatNode repeatNode, @Cached BytesNodes.CreateBytesNode create) {
            SequenceStorage res = repeatNode.execute(frame, getBytesStorage.execute(inliningTarget, self), asSizeNode.executeExact((Frame)frame, inliningTarget, times));
            return create.execute(inliningTarget, this.factory(), self, res);
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PBytesLike add(PBytesLike self, PBytesLike other, @Bind(value="this") Node node, @Cached(value="createWithOverflowError()") @Cached.Shared SequenceStorageNodes.ConcatNode concatNode, @Cached @Cached.Exclusive BytesNodes.CreateBytesNode create) {
            SequenceStorage res = concatNode.execute(self.getSequenceStorage(), other.getSequenceStorage());
            return create.execute(node, this.factory(), (Object)self, res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        PBytesLike add(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @CachedLibrary(value="other") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached(value="createWithOverflowError()") @Cached.Shared SequenceStorageNodes.ConcatNode concatNode, @Cached @Cached.Exclusive BytesNodes.CreateBytesNode create) {
            Object buffer;
            try {
                buffer = bufferAcquireLib.acquireReadonly(other, frame, this);
            }
            catch (PException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_CONCAT_P_TO_S, other, "bytearray");
            }
            try {
                byte[] bytes = bufferLib.getCopiedByteArray(buffer);
                SequenceStorage res = concatNode.execute(getBytesStorage.execute(inliningTarget, self), new ByteSequenceStorage(bytes));
                PBytesLike pBytesLike = create.execute(inliningTarget, this.factory(), self, res);
                return pBytesLike;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }
    }

    @Builtin(name="join", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class JoinNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PBytesLike join(VirtualFrame frame, Object self, Object iterable, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.ToByteArrayNode toByteArrayNode, @Cached BytesNodes.BytesJoinNode bytesJoinNode, @Cached BytesNodes.CreateBytesNode create) {
            byte[] res = bytesJoinNode.execute(frame, inliningTarget, toByteArrayNode.execute(inliningTarget, getBytesStorage.execute(inliningTarget, self)), iterable);
            return create.execute(inliningTarget, this.factory(), self, res);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true, numOfPositionalOnlyArgs=2, parameterNames={"$cls", "string"})
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class FromHexNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization(guards={"isBuiltinBytesType(inliningTarget, cls, isSameType)"})
        PBytes doBytes(Object cls, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameType, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode) {
            return this.factory().createBytes(cls, hexStringToBytesNode.execute(str));
        }

        @Specialization(guards={"!isBuiltinBytesType(inliningTarget, cls, isSameType)"})
        Object doGeneric(VirtualFrame frame, Object cls, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameType, @Cached CallNode callNode, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode) {
            PBytes bytes = this.factory().createBytes(hexStringToBytesNode.execute(str));
            return callNode.execute((Frame)frame, cls, new Object[]{bytes});
        }

        protected static boolean isBuiltinBytesType(Node inliningTarget, Object cls, TypeNodes.IsSameTypeNode isSameTypeNode) {
            return isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PBytes, cls);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.FromHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="translate", minNumOfPositionalArgs=2, parameterNames={"self", "table", "delete"})
    @GenerateNodeFactory
    public static abstract class TranslateNode
    extends BaseTranslateNode {
        @Specialization(guards={"isNoValue(delete)", "checkExactNode.execute(this, self)"})
        public static PBytes translate(PBytes self, PNone table, PNone delete, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode) {
            return self;
        }

        @Specialization(guards={"isNoValue(delete)", "!checkExactNode.execute(this, self)"})
        public PBytes translate(Object self, PNone table, PNone delete, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            return this.factory().createBytes(toBytesNode.execute(null, self));
        }

        @Specialization(guards={"!isNone(table)"})
        Object translate(VirtualFrame frame, Object self, Object table, PNone delete, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="profile") @Cached InlinedConditionProfile isLenTable256Profile, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bTable = toBytesNode.execute(frame, table);
            this.checkLengthOfTable(bTable, isLenTable256Profile);
            byte[] bSelf = toBytesNode.execute(null, self);
            BaseTranslateNode.Result result = TranslateNode.translate(bSelf, bTable);
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return this.factory().createBytes(result.array);
            }
            return self;
        }

        @Specialization(guards={"isNone(table)"})
        Object delete(VirtualFrame frame, Object self, PNone table, Object delete, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bSelf = toBytesNode.execute(null, self);
            byte[] bDelete = toBytesNode.execute(frame, delete);
            BaseTranslateNode.Result result = TranslateNode.delete(bSelf, bDelete);
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return this.factory().createBytes(result.array);
            }
            return self;
        }

        @Specialization(guards={"!isPNone(table)", "!isPNone(delete)"})
        Object translateAndDelete(VirtualFrame frame, Object self, Object table, Object delete, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="profile") @Cached InlinedConditionProfile isLenTable256Profile, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bTable = toBytesNode.execute(frame, table);
            this.checkLengthOfTable(bTable, isLenTable256Profile);
            byte[] bDelete = toBytesNode.execute(frame, delete);
            byte[] bSelf = toBytesNode.execute(null, self);
            BaseTranslateNode.Result result = TranslateNode.translateAndDelete(bSelf, bTable, bDelete);
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return this.factory().createBytes(result.array);
            }
            return self;
        }
    }

    @Builtin(name="strip", minNumOfPositionalArgs=1, parameterNames={"$self", "what"})
    @GenerateNodeFactory
    static abstract class StripNode
    extends PythonBinaryBuiltinNode {
        StripNode() {
        }

        @Specialization
        public Object strip(VirtualFrame frame, Object self, Object what, @Cached LStripNode lstripNode, @Cached RStripNode rstripNode) {
            return rstripNode.execute(frame, lstripNode.execute(frame, self, what), what);
        }
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"$self", "encoding", "errors"}, doc="Decode the bytes using the codec registered for encoding.\n\nencoding\n  The encoding with which to decode the bytes.\nerrors\n  The error handling scheme to use for the handling of decoding errors.\n  The default is 'strict' meaning that decoding errors raise a\n  UnicodeDecodeError. Other possible values are 'ignore' and 'replace'\n  as well as any other name registered with codecs.register_error that\n  can handle UnicodeDecodeErrors.")
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_UTF8"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    public static abstract class DecodeNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.DecodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        public Object decode(VirtualFrame frame, Object self, TruffleString encoding, TruffleString errors, @Cached CodecsModuleBuiltins.DecodeNode decodeNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode) {
            Object result = decodeNode.executeWithStrings(frame, self, encoding, errors);
            if (!isInstanceNode.executeWith(frame, result, (Object)PythonBuiltinClassType.PString)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.DECODER_RETURNED_P_INSTEAD_OF_BYTES, encoding, result);
            }
            return result;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        public static TruffleString repr(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage store = getBytesStorage.execute(inliningTarget, self);
            byte[] bytes = getBytes.execute(inliningTarget, store);
            int len = store.length();
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            BytesUtils.reprLoop(sb, bytes, len, appendCodePointNode);
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetitemNode
    extends PythonBinaryBuiltinNode {
        GetitemNode() {
        }

        @Specialization(guards={"isPSlice(key) || indexCheckNode.execute(this, key)"}, limit="1")
        static Object doSlice(VirtualFrame frame, Object self, Object key, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached(value="createGetItem()") SequenceStorageNodes.GetItemNode getSequenceItemNode) {
            return getSequenceItemNode.execute(frame, getBytesStorage.execute(inliningTarget, self), key);
        }

        @Fallback
        Object doError(VirtualFrame frame, Object self, Object key) {
            return this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "byte", key);
        }

        @NeverDefault
        protected static SequenceStorageNodes.GetItemNode createGetItem() {
            return SequenceStorageNodes.GetItemNode.create(IndexNodes.NormalizeIndexNode.create(), (s, f) -> f.createBytes((SequenceStorage)s));
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            return PNone.NONE;
        }

        @Specialization
        static Object byteDone(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            return PNone.NONE;
        }
    }
}

