/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGenSendBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGen;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenASend;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenWrappedValue;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PAsyncGenASend})
public final class AsyncGenSendBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AsyncGenSendBuiltinsFactory.getFactories();
    }

    static PException handleAGError(PAsyncGen self, PException exception, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile isStopAsyncIteration, BuiltinClassProfiles.IsBuiltinObjectProfile isGeneratorExit) {
        if (isStopAsyncIteration.profileException(inliningTarget, exception, PythonBuiltinClassType.StopAsyncIteration) || isGeneratorExit.profileException(inliningTarget, exception, PythonBuiltinClassType.GeneratorExit)) {
            self.markClosed();
        }
        self.setRunningAsync(false);
        return exception;
    }

    static Object unwrapAGYield(PAsyncGen self, Object result, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile isAGWrappedValue, PRaiseNode raise) {
        if (isAGWrappedValue.profileObject(inliningTarget, result, PythonBuiltinClassType.PAsyncGenAWrappedValue)) {
            self.setRunningAsync(false);
            Object wrapped = ((PAsyncGenWrappedValue)result).getWrapped();
            throw raise.raise(PythonBuiltinClassType.StopIteration, new Object[]{wrapped});
        }
        return result;
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Close
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object close(PAsyncGenASend self) {
            self.setState(PAsyncGenASend.AwaitableState.CLOSED);
            return PNone.NONE;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Iter
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object iter(PAsyncGenASend self) {
            return self;
        }
    }

    @Builtin(name="throw", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Throw
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PAsyncGenASend var2, Object var3, Object var4, Object var5);

        @Specialization
        public Object doThrow(VirtualFrame frame, PAsyncGenASend self, Object arg1, Object arg2, Object arg3, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseReuse, @Cached CommonGeneratorBuiltins.ThrowNode throwNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIteration, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isGeneratorExit, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAGWrappedValue, @Cached PRaiseNode raiseStopIteration) {
            Object result;
            if (self.getState() == PAsyncGenASend.AwaitableState.CLOSED) {
                throw raiseReuse.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_ASEND);
            }
            try {
                result = throwNode.execute(frame, self.receiver, arg1, arg2, arg3);
            }
            catch (PException e) {
                self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                throw AsyncGenSendBuiltins.handleAGError(self.receiver, e, inliningTarget, isStopIteration, isGeneratorExit);
            }
            try {
                return AsyncGenSendBuiltins.unwrapAGYield(self.receiver, result, inliningTarget, isAGWrappedValue, raiseStopIteration);
            }
            catch (PException e) {
                self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                throw e;
            }
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Send
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object send(VirtualFrame frame, PAsyncGenASend self, Object sent, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseReuse, @Cached PRaiseNode raiseAlreadyRunning, @Cached CommonGeneratorBuiltins.SendNode send, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIteration, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isGenExit, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAsyncGenWrappedValue, @Cached PRaiseNode raiseStopIteration) {
            Object result;
            if (self.getState() == PAsyncGenASend.AwaitableState.CLOSED) {
                throw raiseReuse.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_ASEND);
            }
            if (self.getState() == PAsyncGenASend.AwaitableState.INIT) {
                if (self.receiver.isRunningAsync()) {
                    throw raiseAlreadyRunning.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.AGEN_ALREADY_RUNNING);
                }
                if (sent == null || sent == PNone.NONE) {
                    sent = self.message;
                }
                self.setState(PAsyncGenASend.AwaitableState.ITER);
            }
            self.receiver.setRunningAsync(true);
            try {
                result = send.execute(frame, self.receiver, sent);
            }
            catch (PException e) {
                self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                throw AsyncGenSendBuiltins.handleAGError(self.receiver, e, inliningTarget, isStopIteration, isGenExit);
            }
            try {
                return AsyncGenSendBuiltins.unwrapAGYield(self.receiver, result, inliningTarget, isAsyncGenWrappedValue, raiseStopIteration);
            }
            catch (PException e) {
                self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                throw e;
            }
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Next
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object next(VirtualFrame frame, PAsyncGenASend self, @Cached Send send) {
            return send.execute(frame, self, PNone.NONE);
        }
    }

    @Builtin(name="__await__", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Await
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doAwait(PAsyncGenASend self) {
            return self;
        }
    }
}

