/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedRWPairBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BufferedRWPairBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PRWPair;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyErrChainExceptions;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedRWPair})
public final class BufferedRWPairBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedRWPairBuiltinsFactory.getFactories();
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization(guards={"self.getWriter() != null"})
        static Object doit(VirtualFrame frame, PRWPair self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getWriter(), IONodes.T_CLOSED);
        }

        @Fallback
        Object error(VirtualFrame frame, Object self) {
            throw this.raise(PythonErrorType.RuntimeError, ErrorMessages.THE_S_OBJECT_IS_BEING_GARBAGE_COLLECTED, "BufferedRWPair");
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAttyNode
    extends PythonUnaryBuiltinNode {
        IsAttyNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, PRWPair self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodWriter, @Cached PyObjectCallMethodObjArgs callMethodReader, @Cached IsNode isNode, @Cached InlinedConditionProfile isSameProfile) {
            Object res = callMethodWriter.execute((Frame)frame, inliningTarget, self.getWriter(), IONodes.T_ISATTY, new Object[0]);
            if (isSameProfile.profile(inliningTarget, isNode.isTrue(res))) {
                return res;
            }
            return callMethodReader.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_ISATTY, new Object[0]);
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        Object close(VirtualFrame frame, PRWPair self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodReader, @Cached PyObjectCallMethodObjArgs callMethodWriter, @Cached InlinedConditionProfile gotException, @Cached InlinedBranchProfile hasException, @Cached PyErrChainExceptions chainExceptions) {
            PException readEx;
            PException writeEx = null;
            if (self.getWriter() != null) {
                try {
                    callMethodWriter.execute((Frame)frame, inliningTarget, self.getWriter(), IONodes.T_CLOSE, new Object[0]);
                }
                catch (PException e) {
                    hasException.enter(inliningTarget);
                    writeEx = e;
                }
            } else {
                writeEx = this.getRaiseNode().raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
            }
            if (self.getReader() != null) {
                try {
                    Object res = callMethodReader.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_CLOSE, new Object[0]);
                    if (gotException.profile(inliningTarget, writeEx != null)) {
                        throw writeEx;
                    }
                    return res;
                }
                catch (PException e) {
                    readEx = e;
                }
            } else {
                readEx = this.getRaiseNode().raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
            }
            hasException.enter(inliningTarget);
            return CloseNode.chainedError(writeEx, readEx, inliningTarget, gotException, chainExceptions);
        }

        static Object chainedError(PException first, PException second, Node inliningTarget, InlinedConditionProfile gotFirst, PyErrChainExceptions chainExceptions) {
            if (gotFirst.profile(inliningTarget, first != null)) {
                throw chainExceptions.execute(inliningTarget, second, first);
            }
            throw second;
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends WriterInitCheckPythonUnaryBuiltinNode {
        WritableNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object doit(VirtualFrame frame, PRWPair self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getWriter(), IONodes.T_WRITABLE, new Object[0]);
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends ReaderInitCheckPythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object doit(VirtualFrame frame, PRWPair self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_READABLE, new Object[0]);
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends WriterInitCheckPythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object doit(VirtualFrame frame, PRWPair self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getWriter(), IONodes.T_FLUSH, new Object[0]);
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends WriterInitCheckPythonBinaryBuiltinNode {
        WriteNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object write(VirtualFrame frame, PRWPair self, Object args, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getWriter(), IONodes.T_WRITE, args);
        }
    }

    @Builtin(name="readinto1", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ReadInto1Node
    extends ReaderInitCheckPythonBinaryBuiltinNode {
        ReadInto1Node() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object readInto1(VirtualFrame frame, PRWPair self, Object args, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_READINTO1, args);
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ReadIntoNode
    extends ReaderInitCheckPythonBinaryBuiltinNode {
        ReadIntoNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object readInto(VirtualFrame frame, PRWPair self, Object args, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_READINTO, args);
        }
    }

    @Builtin(name="read1", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class Read1Node
    extends ReaderInitCheckPythonBinaryBuiltinNode {
        Read1Node() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object read1(VirtualFrame frame, PRWPair self, Object args, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_READ1, args);
        }
    }

    @Builtin(name="peek", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class PeekNode
    extends ReaderInitCheckPythonBinaryBuiltinNode {
        PeekNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object peek(VirtualFrame frame, PRWPair self, Object args, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_PEEK, args);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends ReaderInitCheckPythonBinaryBuiltinNode {
        ReadNode() {
        }

        @Specialization(guards={"isInit(self)"})
        static Object read(VirtualFrame frame, PRWPair self, Object args, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getReader(), IONodes.T_READ, args);
        }
    }

    static abstract class WriterInitCheckPythonBinaryBuiltinNode
    extends PythonBinaryBuiltinNode {
        WriterInitCheckPythonBinaryBuiltinNode() {
        }

        protected static boolean isInit(PRWPair self) {
            return self.getWriter() != null;
        }

        @Specialization(guards={"!isInit(self)"})
        Object error(VirtualFrame frame, PRWPair self, Object arg) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    static abstract class ReaderInitCheckPythonBinaryBuiltinNode
    extends PythonBinaryBuiltinNode {
        ReaderInitCheckPythonBinaryBuiltinNode() {
        }

        protected static boolean isInit(PRWPair self) {
            return self.getReader() != null;
        }

        @Specialization(guards={"!isInit(self)"})
        Object error(VirtualFrame frame, PRWPair self, Object arg) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    static abstract class WriterInitCheckPythonUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        WriterInitCheckPythonUnaryBuiltinNode() {
        }

        protected static boolean isInit(PRWPair self) {
            return self.getWriter() != null;
        }

        @Specialization(guards={"!isInit(self)"})
        Object error(VirtualFrame frame, PRWPair self) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    static abstract class ReaderInitCheckPythonUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        ReaderInitCheckPythonUnaryBuiltinNode() {
        }

        protected static boolean isInit(PRWPair self) {
            return self.getReader() != null;
        }

        @Specialization(guards={"!isInit(self)"})
        Object error(VirtualFrame frame, PRWPair self) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=3, parameterNames={"$self", "reader", "writer", "buffer_size"})
    @ArgumentClinic(name="buffer_size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedReaderBuiltins.DEFAULT_BUFFER_SIZE", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedRWPairBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        public PNone doInit(VirtualFrame frame, PRWPair self, Object reader, Object writer, int bufferSize, @Bind(value="this") Node inliningTarget, @Cached IOBaseBuiltins.CheckBoolMethodHelperNode checkReadableNode, @Cached IOBaseBuiltins.CheckBoolMethodHelperNode checkWritableNode, @Cached BufferedReaderBuiltins.BufferedReaderInit initReaderNode, @Cached BufferedWriterBuiltins.BufferedWriterInit initWriterNode) {
            checkReadableNode.checkReadable(frame, inliningTarget, reader);
            checkWritableNode.checkWriteable(frame, inliningTarget, writer);
            self.setReader(this.factory().createBufferedReader((Object)PythonBuiltinClassType.PBufferedReader));
            initReaderNode.execute(frame, inliningTarget, self.getReader(), reader, bufferSize, this.factory());
            self.setWriter(this.factory().createBufferedWriter((Object)PythonBuiltinClassType.PBufferedWriter));
            initWriterNode.execute(frame, inliningTarget, self.getWriter(), writer, bufferSize, this.factory());
            return PNone.NONE;
        }
    }
}

