/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class MultibyteEncodeBuffer {
    protected final TruffleString inobj;
    protected PBytes outobj;
    CharBuffer inputBuffer;
    ByteBuffer outputBuffer;
    protected PBaseException excobj;

    @CompilerDirectives.TruffleBoundary
    public MultibyteEncodeBuffer(TruffleString inobj) {
        this.inobj = inobj;
        this.inputBuffer = CharBuffer.wrap(inobj.toJavaStringUncached());
        this.outputBuffer = ByteBuffer.allocate(this.inputBuffer.length() * 2 + 16);
        this.excobj = null;
    }

    public MultibyteEncodeBuffer(int outbufSize) {
        this.inobj = null;
        this.inputBuffer = null;
        this.outputBuffer = ByteBuffer.allocate(outbufSize);
        this.excobj = null;
    }

    protected int getInpos() {
        return this.inputBuffer.position();
    }

    protected int getInlen() {
        return this.inputBuffer.limit();
    }

    @CompilerDirectives.TruffleBoundary
    protected void setInpos(int pos) {
        this.inputBuffer.position(pos);
    }

    @CompilerDirectives.TruffleBoundary
    protected void incInpos(int len) {
        this.setInpos(this.getInpos() + len);
    }

    protected void rewindInbuf() {
        this.inputBuffer.rewind();
    }

    protected boolean isFull() {
        return !this.inputBuffer.hasRemaining();
    }

    @CompilerDirectives.TruffleBoundary
    protected void append(char c) {
        this.outputBuffer.putChar(c);
    }

    @CompilerDirectives.TruffleBoundary
    protected void append(byte[] bytes) {
        this.outputBuffer.put(bytes);
    }

    protected int remaining() {
        return this.outputBuffer.remaining();
    }

    protected void rewindOutbuf() {
        this.outputBuffer.rewind();
    }

    @CompilerDirectives.TruffleBoundary
    protected void expandOutputBuffer(int esize, PRaiseNode raiseNode) {
        if (esize < 0 || esize > this.remaining()) {
            int incsize;
            int orgsize = this.outputBuffer.capacity();
            int n = incsize = esize < orgsize >> 1 ? orgsize >> 1 | 1 : esize;
            if (orgsize > Integer.MAX_VALUE - incsize) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(incsize);
            this.outputBuffer.flip();
            newBuffer.put(this.outputBuffer);
            this.outputBuffer = newBuffer;
            this.outobj = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected PBytes createPBytes(PythonObjectFactory factory) {
        this.outobj = factory.createBytes(this.outputBuffer.array(), this.outputBuffer.position());
        return this.outobj;
    }

    protected TruffleString toTString() {
        return this.inobj;
    }
}

