/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cext.PythonCextMethodBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiMemberAccessNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyDictSetDefault;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;

public final class PythonCextTypeBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleType_AddGetSet
    extends PythonCextBuiltins.CApi7BuiltinNode {
        PyTruffleType_AddGetSet() {
        }

        @Specialization
        int doGeneric(Object cls, PDict dict, TruffleString name, Object getter, Object setter, Object doc, Object closure, @Bind(value="this") Node inliningTarget, @Cached CreateGetSetNode createGetSetNode, @Cached PyDictSetDefault setDefault) {
            GetSetDescriptor descr = createGetSetNode.execute(name, cls, getter, setter, doc, closure);
            setDefault.execute(null, inliningTarget, dict, name, descr);
            return 0;
        }
    }

    static abstract class CreateGetSetNode
    extends Node {
        CreateGetSetNode() {
        }

        abstract GetSetDescriptor execute(TruffleString var1, Object var2, Object var3, Object var4, Object var5, Object var6);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        GetSetDescriptor createGetSet(TruffleString name, Object cls, Object getter, Object setter, Object doc, Object closure, @Cached PythonObjectFactory factory, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @CachedLibrary(limit="2") InteropLibrary interopLibrary) {
            boolean hasSetter;
            assert (!(doc instanceof CArrayWrappers.CArrayWrapper));
            PBuiltinFunction get = null;
            if (!interopLibrary.isNull(getter)) {
                RootCallTarget getterCT = CreateGetSetNode.getterCallTarget(name, PythonLanguage.get(this));
                getter = NativeCExtSymbol.ensureExecutable(getter, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
                get = factory.createBuiltinFunction(name, cls, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(getter, closure), 0, getterCT);
            }
            PBuiltinFunction set = null;
            boolean bl = hasSetter = !interopLibrary.isNull(setter);
            if (hasSetter) {
                RootCallTarget setterCT = CreateGetSetNode.setterCallTarget(name, PythonLanguage.get(this));
                setter = NativeCExtSymbol.ensureExecutable(setter, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
                set = factory.createBuiltinFunction(name, cls, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(setter, closure), 0, setterCT);
            }
            GetSetDescriptor descriptor = factory.createGetSetDescriptor(get, set, name, cls, hasSetter);
            dylib.put(descriptor.getStorage(), (Object)SpecialAttributeNames.T___DOC__, doc);
            return descriptor;
        }

        @CompilerDirectives.TruffleBoundary
        private static RootCallTarget getterCallTarget(TruffleString name, PythonLanguage lang) {
            Function rootNodeFunction = l -> new ExternalFunctionNodes.GetterRoot((PythonLanguage)((Object)l), name, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
            return lang.createCachedCallTarget((Function<PythonLanguage, RootNode>)rootNodeFunction, ExternalFunctionNodes.GetterRoot.class, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER, name, true);
        }

        @CompilerDirectives.TruffleBoundary
        private static RootCallTarget setterCallTarget(TruffleString name, PythonLanguage lang) {
            Function rootNodeFunction = l -> new ExternalFunctionNodes.SetterRoot((PythonLanguage)((Object)l), name, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
            return lang.createCachedCallTarget((Function<PythonLanguage, RootNode>)rootNodeFunction, ExternalFunctionNodes.SetterRoot.class, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER, name, true);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    public static abstract class PyTruffleType_AddMember
    extends PythonCextBuiltins.CApi7BuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static int addMember(Object clazz, PDict tpDict, TruffleString memberName, int memberType, long offset, int canSet, Object memberDoc) {
            PythonLanguage language = PythonLanguage.get(null);
            PBuiltinFunction getterObject = CApiMemberAccessNodes.ReadMemberNode.createBuiltinFunction(language, clazz, memberName, memberType, (int)offset);
            PBuiltinFunction setterObject = null;
            if (canSet != 0) {
                setterObject = CApiMemberAccessNodes.WriteMemberNode.createBuiltinFunction(language, clazz, memberName, memberType, (int)offset);
            }
            GetSetDescriptor memberDescriptor = PythonObjectFactory.getUncached().createMemberDescriptor(getterObject, setterObject, memberName, clazz);
            WriteAttributeToDynamicObjectNode.getUncached().execute((Object)memberDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            PyDictSetDefault.executeUncached(tpDict, memberName, memberDescriptor);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Int, ArgDescriptor.Int, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleType_AddSlot
    extends PythonCextBuiltins.CApi7BuiltinNode {
        PyTruffleType_AddSlot() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int addSlot(Object clazz, PDict tpDict, TruffleString memberName, Object cfunc, int flags, int wrapper, Object memberDoc) {
            Object wrapperDescriptor = PythonCextBuiltinsFactory.CreateFunctionNodeGen.getUncached().execute(memberName, cfunc, wrapper, clazz, flags, PythonObjectFactory.getUncached());
            WriteAttributeToDynamicObjectNode.getUncached().execute(wrapperDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            PyDictSetDefault.executeUncached(tpDict, memberName, wrapperDescriptor);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.Pointer, ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Int, ArgDescriptor.Int, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleType_AddFunctionToType
    extends PythonCextBuiltins.CApi8BuiltinNode {
        PyTruffleType_AddFunctionToType() {
        }

        @Specialization
        static int classMethod(Object methodDefPtr, Object type, Object dict, TruffleString name, Object cfunc, int flags, int wrapper, Object doc, @Bind(value="this") Node inliningTarget, @Cached NewClassMethodNode newClassMethodNode, @Cached PyDictSetDefault setDefault) {
            Object func = newClassMethodNode.execute(methodDefPtr, name, cfunc, flags, wrapper, type, doc);
            setDefault.execute(null, inliningTarget, dict, name, func);
            return 0;
        }
    }

    @ImportStatic(value={CExtContext.class})
    static abstract class NewClassMethodNode
    extends Node {
        NewClassMethodNode() {
        }

        abstract Object execute(Object var1, TruffleString var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Specialization(guards={"isClassOrStaticMethod(flags)"})
        static Object classOrStatic(Object methodDefPtr, TruffleString name, Object methObj, int flags, int wrapper, Object type, Object doc, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached.Shared(value="cf") @Cached PythonCextBuiltins.CreateFunctionNode createFunctionNode) {
            Object func = createFunctionNode.execute(name, methObj, wrapper, type, flags, factory);
            PDecoratedMethod function = (flags & 0x10) != 0 ? factory.createClassmethodFromCallableObj(func) : factory.createStaticmethodFromCallableObj(func);
            dylib.put((DynamicObject)function, (Object)SpecialAttributeNames.T___NAME__, (Object)name);
            dylib.put((DynamicObject)function, (Object)SpecialAttributeNames.T___DOC__, doc);
            dylib.put((DynamicObject)function, (Object)PythonCextMethodBuiltins.METHOD_DEF_PTR, methodDefPtr);
            return function;
        }

        @Specialization(guards={"!isClassOrStaticMethod(flags)"})
        static Object doNativeCallable(Object methodDefPtr, TruffleString name, Object methObj, int flags, int wrapper, Object type, Object doc, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached PythonCextBuiltins.PyObjectSetAttrNode setattr, @Cached WriteAttributeToObjectNode write, @Cached.Shared(value="cf") @Cached PythonCextBuiltins.CreateFunctionNode createFunctionNode) {
            Object func = createFunctionNode.execute(name, methObj, wrapper, type, flags, factory);
            setattr.execute(func, SpecialAttributeNames.T___NAME__, name);
            setattr.execute(func, SpecialAttributeNames.T___DOC__, doc);
            write.execute(func, PythonCextMethodBuiltins.METHOD_DEF_PTR, methodDefPtr);
            return func;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.Pointer, ArgDescriptor.Pointer}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Trace_Type
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTruffle_Trace_Type.class);

        PyTruffle_Trace_Type() {
        }

        @Specialization(limit="3")
        int trace(Object ptr, Object classNameObj, @CachedLibrary(value="ptr") InteropLibrary ptrLib, @CachedLibrary(value="classNameObj") InteropLibrary nameLib, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            TruffleString className;
            if (nameLib.isString(classNameObj)) {
                try {
                    className = switchEncodingNode.execute((AbstractTruffleString)nameLib.asTruffleString(classNameObj), PythonUtils.TS_ENCODING);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new IllegalStateException();
                }
            } else {
                className = null;
            }
            PythonContext context = this.getContext();
            Object primitivePtr = CApiContext.asPointer(ptr, ptrLib);
            context.getCApiContext().traceStaticMemory(primitivePtr, null, className);
            LOGGER.fine(() -> PythonUtils.formatJString("Initializing native type %s (ptr = %s)", className, CApiContext.asHex(primitivePtr)));
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyTypeObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Type_Modified
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffle_Type_Modified() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNoValue(mroTuple)"})
        int doIt(PythonNativeClass clazz, TruffleString name, PNone mroTuple) {
            CyclicAssumption nativeClassStableAssumption = this.getContext().getNativeClassStableAssumption(clazz, false);
            if (nativeClassStableAssumption != null) {
                nativeClassStableAssumption.invalidate("PyType_Modified(\"" + name.toJavaStringUncached() + "\") (without MRO) called");
            }
            SpecialMethodSlot.reinitializeSpecialMethodSlots(PythonNativeClass.cast(clazz), this.getLanguage());
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        int doIt(PythonNativeClass clazz, TruffleString name, PTuple mroTuple, @Cached(value="createClassProfile()") ValueProfile profile) {
            SequenceStorage sequenceStorage;
            CyclicAssumption nativeClassStableAssumption = this.getContext().getNativeClassStableAssumption(clazz, false);
            if (nativeClassStableAssumption != null) {
                nativeClassStableAssumption.invalidate("PyType_Modified(\"" + name.toJavaStringUncached() + "\") called");
            }
            if (!((sequenceStorage = (SequenceStorage)profile.profile((Object)mroTuple.getSequenceStorage())) instanceof MroSequenceStorage)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("invalid MRO object for native type \"" + name.toJavaStringUncached() + "\"");
            }
            ((MroSequenceStorage)sequenceStorage).lookupChanged();
            SpecialMethodSlot.reinitializeSpecialMethodSlots(PythonNativeClass.cast(clazz), this.getLanguage());
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyTypeObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_NewTypeDict
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_NewTypeDict() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDict doGeneric(PythonNativeClass nativeClass) {
            PythonLanguage language = PythonLanguage.get(null);
            CExtContext.Store nativeTypeStore = new CExtContext.Store(language.getEmptyShape());
            DynamicObjectLibrary.getUncached().put((DynamicObject)nativeTypeStore, (Object)PythonNativeClass.INSTANCESHAPE, (Object)language.getShapeForClass(nativeClass));
            return PythonObjectFactory.getUncached().createDict(new DynamicObjectStorage(nativeTypeStore));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyTypeObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Compute_Mro
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Compute_Mro() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doIt(PythonNativeClass self, TruffleString className) {
            PythonAbstractClass[] doSlowPath = TypeNodes.ComputeMroNode.doSlowPath(self);
            return this.factory().createTuple(new MroSequenceStorage(className, doSlowPath));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyTypeObject, ArgDescriptor.PyTypeObject}, call=PythonCextBuiltins.CApiCallPath.Direct, inlined=true)
    @ImportStatic(value={PythonOptions.class})
    static abstract class PyType_IsSubtype
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyType_IsSubtype() {
        }

        @Specialization
        static int doGeneric(Object a, Object b, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(a, b));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyType_Lookup
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyType_Lookup() {
        }

        @Specialization
        Object doGeneric(Object type, Object name, @Cached LookupAttributeInMRONode.Dynamic lookupAttributeInMRONode) {
            Object result = lookupAttributeInMRONode.execute(type, name);
            if (result == PNone.NO_VALUE) {
                return this.getNativeNull();
            }
            return result;
        }
    }
}

