/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextCodeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextTracebackBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyFrameObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTraceBack_Here
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTraceBack_Here() {
        }

        @Specialization
        int tbHere(PFrame frame, @Bind(value="this") Node inliningTarget, @Cached MaterializeLazyTracebackNode materializeLazyTracebackNode) {
            PythonLanguage language = this.getLanguage();
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(language);
            PException currentException = threadState.getCurrentException();
            if (currentException != null) {
                PTraceback traceback = null;
                if (currentException.getTraceback() != null) {
                    traceback = materializeLazyTracebackNode.execute(inliningTarget, currentException.getTraceback());
                }
                PTraceback newTraceback = this.factory().createTraceback(frame, frame.getLine(), traceback);
                boolean withJavaStacktrace = PythonOptions.isPExceptionWithJavaStacktrace(language);
                threadState.setCurrentException(PException.fromExceptionInfo(currentException.getUnreifiedException(), newTraceback, withJavaStacktrace));
            }
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyTraceback_Add
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyTraceback_Add() {
        }

        @Specialization
        Object tbHere(TruffleString funcname, TruffleString filename, int lineno, @Cached PythonCextCodeBuiltins.PyCode_NewEmpty newCode, @Cached PyTraceBack_Here pyTraceBackHereNode) {
            PFrame frame = this.factory().createPFrame(null, newCode.execute(filename, funcname, lineno), this.factory().createDict(), this.factory().createDict());
            pyTraceBackHereNode.execute(frame);
            return PNone.NONE;
        }
    }
}

