/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextPythonRunBuiltins {
    private static final int Py_single_input = 256;
    private static final int Py_file_input = 257;
    private static final int Py_eval_input = 258;

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObject, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject, ArgDescriptor.Int, ArgDescriptor.PY_COMPILER_FLAGS, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class Py_CompileStringObject
    extends PythonCextBuiltins.CApi5BuiltinNode {
        Py_CompileStringObject() {
        }

        @Specialization(guards={"isString(source)"})
        static Object compile(Object source, Object filename, int type, Object flags, int optimizationLevel, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached PyObjectLookupAttr lookupNode, @Cached CallNode callNode) {
            return Py_CompileStringExFlags.compile(source, filename, type, null, optimizationLevel, inliningTarget, raiseNode, lookupNode, callNode);
        }

        @Specialization(guards={"!isString(source)"})
        Object fail(Object source, Object filename, Object type, Object flags, Object optimizationLevel) {
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObject, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int, ArgDescriptor.PY_COMPILER_FLAGS, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class Py_CompileStringExFlags
    extends PythonCextBuiltins.CApi5BuiltinNode {
        Py_CompileStringExFlags() {
        }

        @Specialization(guards={"isString(source)", "isString(filename)"})
        static Object compile(Object source, Object filename, int type, Object flags, int optimizationLevel, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached PyObjectLookupAttr lookupNode, @Cached CallNode callNode) {
            TruffleString stype;
            PythonModule builtins = PythonContext.get(lookupNode).getCore().getBuiltins();
            Object compileCallable = lookupNode.execute(null, inliningTarget, builtins, BuiltinNames.T_COMPILE);
            if (type == 256) {
                stype = StringLiterals.T_SINGLE;
            } else if (type == 257) {
                stype = StringLiterals.T_EXEC;
            } else if (type == 258) {
                stype = StringLiterals.T_EVAL;
            } else {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            int defaultFlags = 0;
            boolean dontInherit = false;
            return callNode.execute(compileCallable, source, filename, stype, defaultFlags, dontInherit, optimizationLevel);
        }

        @Specialization(guards={"!isString(source) || !isString(filename)"})
        Object fail(Object source, Object filename, Object type, Object flags, Object optimizationLevel) {
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObject, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class Py_CompileString
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        Py_CompileString() {
        }

        @Specialization(guards={"isString(source)", "isString(filename)"})
        static Object compile(Object source, Object filename, int type, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached PyObjectLookupAttr lookupNode, @Cached CallNode callNode) {
            return Py_CompileStringExFlags.compile(source, filename, type, null, -1, inliningTarget, raiseNode, lookupNode, callNode);
        }

        @Specialization(guards={"!isString(source) || !isString(filename)"})
        Object fail(Object source, Object filename, Object type) {
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PY_COMPILER_FLAGS}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyRun_StringFlags
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyRun_StringFlags() {
        }

        @Specialization(guards={"checkArgs(source, globals, locals, inliningTarget, isMapping)"})
        Object run(Object source, int type, Object globals, Object locals, Object flags, @Bind(value="this") Node inliningTarget, @Cached PyMappingCheckNode isMapping, @Cached PyObjectLookupAttr lookupNode, @Cached CallNode callNode) {
            TruffleString stype;
            PythonModule builtins = this.getCore().getBuiltins();
            Object compileCallable = lookupNode.execute(null, inliningTarget, builtins, BuiltinNames.T_COMPILE);
            if (type == 256) {
                stype = StringLiterals.T_SINGLE;
            } else if (type == 257) {
                stype = StringLiterals.T_EXEC;
            } else if (type == 258) {
                stype = StringLiterals.T_EVAL;
            } else {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            Object code = callNode.execute(compileCallable, source, stype, stype);
            Object execCallable = lookupNode.execute(null, inliningTarget, builtins, BuiltinNames.T_EXEC);
            return callNode.execute(execCallable, code, globals, locals);
        }

        @Specialization(guards={"!isString(source) || !isDict(globals)"})
        Object run(Object source, int type, Object globals, Object locals, Object flags) {
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }

        @Specialization(guards={"isString(source)", "isDict(globals)", "!isMapping.execute(inliningTarget, locals)"})
        Object run(Object source, int type, Object globals, Object locals, Object flags, @Bind(value="this") Node inliningTarget, @Cached PyMappingCheckNode isMapping) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, locals);
        }

        protected boolean checkArgs(Object source, Object globals, Object locals, Node inliningTarget, PyMappingCheckNode isMapping) {
            return PGuards.isString(source) && PGuards.isDict(globals) && isMapping.execute(inliningTarget, locals);
        }
    }
}

