/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBytesBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.GetNextVaArgNode;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyObjectAsFileDescriptor;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.PrintWriter;

public class PythonCextObjectBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Dir
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Dir() {
        }

        @Specialization
        static Object dir(Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectDir dir) {
            return dir.execute(null, inliningTarget, object);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCallable_Check
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCallable_Check() {
        }

        @Specialization
        static int doGeneric(Object object, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
            return PInt.intValue(callableCheck.execute(inliningTarget, object));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_hash_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Hash
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Hash() {
        }

        @Specialization
        static long hash(Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode) {
            return hashNode.execute(null, inliningTarget, object);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_GetIter
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_GetIter() {
        }

        @Specialization
        static Object iter(Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter) {
            return getIter.execute(null, inliningTarget, object);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Format
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_Format() {
        }

        @Specialization
        static Object ascii(Object obj, Object spec, @Cached BuiltinFunctions.FormatNode format) {
            return format.execute(null, obj, spec);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Type
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Type() {
        }

        @Specialization
        static Object type(Object obj, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass) {
            return getClass.execute(inliningTarget, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_ASCII
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_ASCII() {
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static TruffleString ascii(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectAsciiNode asciiNode) {
            return asciiNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static TruffleString asciiNone(PNone obj) {
            return StringLiterals.T_NULL_RESULT;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObjectWrapper}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyObject_Dump
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyObject_Dump() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doGeneric(Object ptrObject, @Cached CStructAccess.ReadI64Node readI64) {
            long refCnt;
            Object resolved;
            boolean pointsToHandleSpace;
            PythonContext context = this.getContext();
            PrintWriter stderr = new PrintWriter(context.getStandardErr());
            CApiContext cApiContext = context.getCApiContext();
            InteropLibrary lib = InteropLibrary.getUncached((Object)ptrObject);
            boolean isWrapper = CApiGuards.isNativeWrapper(ptrObject);
            boolean isValidHandle = pointsToHandleSpace = !isWrapper;
            boolean traceNativeMemory = context.getOption(PythonOptions.TraceNativeMemory);
            if (pointsToHandleSpace && !isValidHandle || traceNativeMemory && !isWrapper && !cApiContext.isAllocated(ptrObject)) {
                stderr.println(PythonUtils.formatJString("<object at %s is freed>", CApiContext.asPointer(ptrObject, lib)));
                stderr.flush();
                return 0;
            }
            Object object = resolved = isWrapper ? ptrObject : CExtNodesFactory.ResolveHandleNodeGen.getUncached().execute(ptrObject);
            if (CApiGuards.isNativeWrapper(resolved)) {
                PythonNativeWrapper wrapper = (PythonNativeWrapper)resolved;
                refCnt = wrapper.getRefCount();
            } else {
                refCnt = readI64.read(CApiTransitions.PythonToNativeNode.executeUncached(resolved), CFields.PyObject__ob_refcnt);
            }
            Object pythonObject = CApiTransitions.NativeToPythonNode.executeUncached(ptrObject);
            stderr.println("ptrObject address  : " + ptrObject);
            stderr.println("ptrObject refcount : " + refCnt);
            stderr.flush();
            Object type = GetClassNode.executeUncached(pythonObject);
            stderr.println("object type     : " + type);
            stderr.println("object type name: " + TypeNodes.GetNameNode.executeUncached(type));
            stderr.println("object repr     : ");
            stderr.flush();
            try {
                Object reprObj = PyObjectCallMethodObjArgs.executeUncached(context.getBuiltins(), BuiltinNames.T_REPR, pythonObject);
                stderr.println(CastToJavaStringNode.getUncached().execute(reprObj));
            }
            catch (CannotCastException | PException object2) {
                // empty catch block
            }
            stderr.flush();
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_None
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_None() {
        }

        @Specialization
        static PNone doNativeNone() {
            return PNone.NONE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_NoValue
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_NoValue() {
        }

        @Specialization
        static PNone doNoValue() {
            return PNone.NO_VALUE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_NotImplemented
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_NotImplemented() {
        }

        @Specialization
        static Object run() {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Bytes
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Bytes() {
        }

        @Specialization
        static Object bytes(PBytesLike bytes) {
            return bytes;
        }

        @Specialization(guards={"!isBytes(bytes)", "isBytesSubtype(inliningTarget, bytes, getClassNode, isSubtypeNode)"})
        static Object bytes(Object bytes, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return bytes;
        }

        @Specialization(guards={"!isBytes(obj)", "!isBytesSubtype(this, obj, getClassNode, isSubtypeNode)", "!isNoValue(obj)", "hasBytes(inliningTarget, obj, lookupAttrNode)"}, limit="1")
        Object bytes(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached BuiltinConstructors.BytesNode bytesNode) {
            return bytesNode.execute(null, (Object)PythonBuiltinClassType.PBytes, obj, PNone.NO_VALUE, PNone.NO_VALUE);
        }

        @Specialization(guards={"!isBytes(obj)", "!isBytesSubtype(this, obj, getClassNode, isSubtypeNode)", "!isNoValue(obj)", "!hasBytes(inliningTarget, obj, lookupAttrNode)"}, limit="1")
        static Object bytes(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PythonCextBytesBuiltins.PyBytes_FromObject fromObjectNode) {
            return fromObjectNode.execute(obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        Object bytesNoValue(Object obj) {
            return this.factory().createBytes(BytesUtils.NULL_STRING);
        }

        protected static boolean hasBytes(Node inliningTarget, Object obj, PyObjectLookupAttr lookupAttrNode) {
            return lookupAttrNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___BYTES__) != PNone.NO_VALUE;
        }

        protected static boolean isBytesSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PBytes);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_IsTrue
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_IsTrue() {
        }

        @Specialization
        static int isTrue(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            return isTrueNode.execute(null, inliningTarget, obj) ? 1 : 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_hash_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_HashNotImplemented
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_HashNotImplemented() {
        }

        @Specialization
        Object unhashable(Object obj) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(name="PyObject_HasAttrString", ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)})
    static abstract class PyObject_HasAttr
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_HasAttr() {
        }

        @Specialization
        static int hasAttr(Object obj, Object attr, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrNode, @Cached BranchProfile exceptioBranchProfile) {
            try {
                return lookupAttrNode.execute(null, inliningTarget, obj, attr) != PNone.NO_VALUE ? 1 : 0;
            }
            catch (PException e) {
                exceptioBranchProfile.enter();
                return 0;
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleObject_GenericSetAttr
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleObject_GenericSetAttr() {
        }

        @Specialization
        static int setAttr(Object obj, Object attr, Object value, @Cached ObjectBuiltins.SetattrNode setAttrNode) {
            setAttrNode.execute(null, obj, attr, value);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleObject_GenericGetAttr
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleObject_GenericGetAttr() {
        }

        @Specialization
        static Object getAttr(Object obj, Object attr, @Cached ObjectBuiltins.GetAttributeNode getAttrNode) {
            return getAttrNode.execute(null, obj, attr);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_AsFileDescriptor
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_AsFileDescriptor() {
        }

        @Specialization
        static Object asFileDescriptor(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectAsFileDescriptor asFileDescriptorNode) {
            return asFileDescriptorNode.execute(null, inliningTarget, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_RichCompare
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyObject_RichCompare() {
        }

        @Specialization(guards={"op == 0"})
        Object op0(Object a, Object b, int op, @Cached BinaryComparisonNode.LtNode compNode) {
            return compNode.executeObject(null, a, b);
        }

        @Specialization(guards={"op == 1"})
        Object op1(Object a, Object b, int op, @Cached BinaryComparisonNode.LeNode compNode) {
            return compNode.executeObject(null, a, b);
        }

        @Specialization(guards={"op == 2"})
        Object op2(Object a, Object b, int op, @Cached BinaryComparisonNode.EqNode compNode) {
            return compNode.executeObject(null, a, b);
        }

        @Specialization(guards={"op == 3"})
        Object op3(Object a, Object b, int op, @Cached BinaryComparisonNode.NeNode compNode) {
            return compNode.executeObject(null, a, b);
        }

        @Specialization(guards={"op == 4"})
        Object op4(Object a, Object b, int op, @Cached BinaryComparisonNode.GtNode compNode) {
            return compNode.executeObject(null, a, b);
        }

        @Specialization(guards={"op == 5"})
        Object op5(Object a, Object b, int op, @Cached BinaryComparisonNode.GeNode compNode) {
            return compNode.executeObject(null, a, b);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_IsSubclass
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_IsSubclass() {
        }

        @Specialization
        static int doGeneric(Object obj, Object typ, @Cached BuiltinFunctions.IsSubClassNode isSubclassNode) {
            return PInt.intValue((Boolean)isSubclassNode.execute(null, obj, typ));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_IsInstance
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_IsInstance() {
        }

        @Specialization
        static int doGeneric(Object obj, Object typ, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode) {
            return PInt.intValue((Boolean)isInstanceNode.execute(null, obj, typ));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyObject_SetItem() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object k, Object v, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetItem setItemNode) {
            setItemNode.execute(null, inliningTarget, obj, k, v);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_DelItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_DelItem() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object k, @Bind(value="this") Node inliningTarget, @Cached PyObjectDelItem delNode) {
            delNode.execute(null, inliningTarget, obj, k);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Repr
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Repr() {
        }

        @Specialization(guards={"!isNoValue(obj)"})
        Object doGeneric(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsObjectNode reprNode) {
            return reprNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static TruffleString asciiNone(PNone obj) {
            return StringLiterals.T_NULL_RESULT;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Str
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Str() {
        }

        @Specialization(guards={"!isNoValue(obj)"})
        Object doGeneric(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectStrAsObjectNode strNode) {
            return strNode.execute(inliningTarget, obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static TruffleString asciiNone(PNone obj) {
            return StringLiterals.T_NULL_RESULT;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyThreadState, ArgDescriptor.PyObject, ArgDescriptor.PyObjectConstPtr, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyObject_MakeTpCall
    extends PythonCextBuiltins.CApi5BuiltinNode {
        _PyObject_MakeTpCall() {
        }

        @Specialization
        static Object doGeneric(Object threadState, Object callable, Object argsArray, long nargs, Object kwargs, @Cached CStructAccess.ReadObjectNode readNode, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadObjectNode readKwNode, @Cached ExpandKeywordStarargsNode castKwargsNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached CallNode callNode, @Cached CastToTruffleStringNode castToTruffleStringNode) {
            try {
                PKeyword[] keywords;
                Object[] args = readNode.readPyObjectArray(argsArray, (int)nargs);
                if (kwargs instanceof PNone) {
                    keywords = PKeyword.EMPTY_KEYWORDS;
                } else if (kwargs instanceof PDict) {
                    keywords = castKwargsNode.execute(inliningTarget, kwargs);
                } else if (kwargs instanceof PTuple) {
                    PTuple kwTuple = (PTuple)kwargs;
                    SequenceStorage storage = kwTuple.getSequenceStorage();
                    int kwcount = storage.length();
                    Object[] kwValues = readKwNode.readPyObjectArray(argsArray, kwcount, (int)nargs);
                    keywords = new PKeyword[kwcount];
                    for (int i = 0; i < kwcount; ++i) {
                        TruffleString name = castToTruffleStringNode.execute(inliningTarget, getItemScalarNode.execute(inliningTarget, storage, i));
                        keywords[i] = new PKeyword(name, kwValues[i]);
                    }
                } else {
                    throw CompilerDirectives.shouldNotReachHere((String)"_PyObject_MakeTpCall: keywords must be NULL, a tuple or a dict");
                }
                return callNode.execute((Frame)null, callable, args, keywords);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyTruffleObject_CallMethod1
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        _PyTruffleObject_CallMethod1() {
        }

        @Specialization
        static Object doGeneric(Object receiver, TruffleString methodName, Object argsObj, int singleArg, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PythonCextBuiltins.CastArgsNode castArgsNode) {
            Object[] args = singleArg != 0 ? new Object[]{argsObj} : castArgsNode.execute(null, argsObj);
            return callMethod.execute(null, inliningTarget, receiver, methodName, args);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.VA_LIST_PTR}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleObject_CallMethodObjArgs
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleObject_CallMethodObjArgs() {
        }

        @Specialization
        static Object doMethod(Object receiver, Object methodName, Object vaList, @Cached GetNextVaArgNode getVaArgs, @CachedLibrary(limit="2") InteropLibrary argLib, @Cached CallNode callNode, @Cached GetAttributeNode.GetAnyAttributeNode getAnyAttributeNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            Object method = getAnyAttributeNode.executeObject(null, receiver, methodName);
            return PyTruffleObject_CallFunctionObjArgs.callFunction(method, vaList, getVaArgs, argLib, callNode, toJavaNode);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.VA_LIST_PTR}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleObject_CallFunctionObjArgs
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleObject_CallFunctionObjArgs() {
        }

        @Specialization
        static Object doFunction(Object callable, Object vaList, @Cached GetNextVaArgNode getVaArgs, @CachedLibrary(limit="2") InteropLibrary argLib, @Cached CallNode callNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            return PyTruffleObject_CallFunctionObjArgs.callFunction(callable, vaList, getVaArgs, argLib, callNode, toJavaNode);
        }

        static Object callFunction(Object callable, Object vaList, GetNextVaArgNode getVaArgs, InteropLibrary argLib, CallNode callNode, CApiTransitions.NativeToPythonNode toJavaNode) {
            Object[] args = new Object[4];
            int filled = 0;
            while (true) {
                Object object;
                try {
                    object = getVaArgs.execute(vaList);
                }
                catch (InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                if (argLib.isNull(object)) break;
                if (filled >= args.length) {
                    args = PythonUtils.arrayCopyOf(args, args.length * 2);
                }
                args[filled++] = toJavaNode.execute(object);
            }
            if (filled < args.length) {
                args = PythonUtils.arrayCopyOf(args, filled);
            }
            return callNode.execute(callable, args);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyTruffleObject_Call1
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        _PyTruffleObject_Call1() {
        }

        @Specialization
        static Object doGeneric(Object callable, Object argsObj, Object kwargsObj, int singleArg, @Cached PythonCextBuiltins.CastArgsNode castArgsNode, @Cached PythonCextBuiltins.CastKwargsNode castKwargsNode, @Cached CallNode callNode) {
            Object[] args = singleArg != 0 ? new Object[]{argsObj} : castArgsNode.execute(null, argsObj);
            PKeyword[] keywords = castKwargsNode.execute(kwargsObj);
            return callNode.execute((Frame)null, callable, args, keywords);
        }
    }
}

