/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonThreadKillException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.WeakReference;
import java.util.List;

@CoreFunctions(defineModule="_thread")
public final class ThreadModuleBuiltins
extends PythonBuiltins {
    private static final HiddenKey THREAD_COUNT = new HiddenKey("thread_count");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ThreadModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("error", (Object)core.lookupType(PythonBuiltinClassType.RuntimeError));
        this.addBuiltinConstant("TIMEOUT_MAX", (Object)AbstractPythonLock.TIMEOUT_MAX);
        this.addBuiltinConstant(THREAD_COUNT, (Object)0);
        super.initialize(core);
    }

    @Builtin(name="interrupt_main", parameterNames={"signum"}, doc="interrupt_main()\n\nRaise a KeyboardInterrupt in the main thread.\nA subthread can use this function to interrupt the main thread.")
    @ArgumentClinic(name="signum", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="SIGINT")
    @GenerateNodeFactory
    static abstract class InterruptMainThreadNode
    extends PythonUnaryClinicBuiltinNode {
        static final int SIGINT = 2;

        InterruptMainThreadNode() {
        }

        @Specialization
        Object getCount(int signum) {
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ThreadModuleBuiltinsClinicProviders.InterruptMainThreadNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_set_sentinel", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class SetSentinelNode
    extends PythonBuiltinNode {
        SetSentinelNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object setSentinel() {
            PLock sentinelLock = this.factory().createLock();
            PythonContext.get(this).setSentinelLockWeakref(new WeakReference<PLock>(sentinelLock));
            return sentinelLock;
        }
    }

    @Builtins(value={@Builtin(name="start_new_thread", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=4, constructsClass=PythonBuiltinClassType.PThread), @Builtin(name="start_new", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=4)})
    @GenerateNodeFactory
    static abstract class StartNewThreadNode
    extends PythonBuiltinNode {
        private static final TruffleString IN_THREAD_STARTED_BY = PythonUtils.tsLiteral("in thread started by");

        StartNewThreadNode() {
        }

        @Specialization
        long start(VirtualFrame frame, Object cls, Object callable, Object args, Object kwargs, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached ExecutePositionalStarargsNode getArgsNode, @Cached ExpandKeywordStarargsNode getKwArgsNode) {
            PythonContext context = this.getContext();
            TruffleLanguage.Env env = context.getEnv();
            PythonModule threadModule = context.lookupBuiltinModule(BuiltinNames.T__THREAD);
            Object[] arguments = getArgsNode.executeWith((Frame)frame, args);
            PKeyword[] keywords = getKwArgsNode.execute(frame, inliningTarget, kwargs);
            Thread thread = env.createThread(() -> {
                try (GilNode.UncachedAcquire gil = GilNode.uncachedAcquire();){
                    DynamicObjectLibrary lib = DynamicObjectLibrary.getUncached();
                    int curCount = 0;
                    try {
                        curCount = lib.getIntOrDefault((DynamicObject)threadModule, (Object)THREAD_COUNT, (Object)0);
                    }
                    catch (UnexpectedResultException ure) {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                    lib.putInt((DynamicObject)threadModule, (Object)THREAD_COUNT, curCount + 1);
                    try {
                        callNode.execute((Frame)null, callable, arguments, keywords);
                    }
                    finally {
                        try {
                            curCount = lib.getIntOrDefault((DynamicObject)threadModule, (Object)THREAD_COUNT, (Object)1);
                        }
                        catch (UnexpectedResultException ure) {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                        lib.putInt((DynamicObject)threadModule, (Object)THREAD_COUNT, curCount - 1);
                    }
                }
                catch (PythonThreadKillException e) {
                    return;
                }
                catch (PException e) {
                    WriteUnraisableNode.getUncached().execute(e.getUnreifiedException(), IN_THREAD_STARTED_BY, callable);
                }
            }, env.getContext(), context.getThreadGroup());
            PThread pThread = this.factory().createPythonThread(cls, thread);
            pThread.start();
            return pThread.getId();
        }
    }

    @Builtin(name="stack_size", minNumOfPositionalArgs=0, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetThreadStackSizeNode
    extends PythonUnaryBuiltinNode {
        private final ConditionProfile invalidSizeProfile = ConditionProfile.create();

        GetThreadStackSizeNode() {
        }

        @Specialization
        long getStackSize(PNone stackSize) {
            return this.getContext().getPythonThreadStackSize();
        }

        private long setAndGetStackSizeInternal(long stackSize) {
            if (this.invalidSizeProfile.profile(stackSize < 0L)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.SIZE_MUST_BE_D_OR_S, 0, "a positive value");
            }
            return this.getContext().getAndSetPythonsThreadStackSize(stackSize);
        }

        @Specialization
        long getStackSize(int stackSize) {
            return this.setAndGetStackSizeInternal(stackSize);
        }

        @Specialization
        long getStackSize(long stackSize) {
            return this.setAndGetStackSizeInternal(stackSize);
        }
    }

    @Builtin(name="_count", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetThreadCountNode
    extends PythonUnaryBuiltinNode {
        GetThreadCountNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long getCount(PythonModule self) {
            try {
                return DynamicObjectLibrary.getUncached().getIntOrDefault((DynamicObject)self, (Object)THREAD_COUNT, (Object)0);
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @Builtin(name="get_native_id", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetNativeIdNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static long getId() {
            return PThread.getThreadId(Thread.currentThread());
        }
    }

    @Builtin(name="get_ident", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetCurrentThreadIdNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static long getId() {
            return PThread.getThreadId(Thread.currentThread());
        }
    }

    @Builtin(name="RLock", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PRLock)
    @GenerateNodeFactory
    static abstract class ConstructRLockNode
    extends PythonUnaryBuiltinNode {
        ConstructRLockNode() {
        }

        @Specialization
        PRLock construct(Object cls) {
            return this.factory().createRLock(cls);
        }
    }

    @Builtin(name="LockType", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PLock)
    @GenerateNodeFactory
    static abstract class ConstructLockNode
    extends PythonUnaryBuiltinNode {
        ConstructLockNode() {
        }

        @Specialization
        PLock construct(Object cls) {
            return this.factory().createLock(cls);
        }
    }

    @Builtin(name="allocate_lock", maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AllocateLockNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PLock construct(Object self, Object unused) {
            return this.factory().createLock((Object)PythonBuiltinClassType.PLock);
        }
    }

    @Builtin(name="_local", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PThreadLocal)
    @GenerateNodeFactory
    static abstract class ThreadLocalNode
    extends PythonBuiltinNode {
        ThreadLocalNode() {
        }

        @Specialization
        PThreadLocal construct(Object cls, Object[] args, PKeyword[] keywordArgs) {
            return this.factory().createThreadLocal(cls, args, keywordArgs);
        }
    }
}

