/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.LocaleModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="_locale")
public final class LocaleModuleBuiltins
extends PythonBuiltins {
    static final int LC_ALL = 6;
    static final int LC_COLLATE = 3;
    static final int LC_CTYPE = 0;
    static final int LC_MESSAGES = 5;
    static final int LC_MONETARY = 4;
    static final int LC_NUMERIC = 1;
    static final int LC_TIME = 2;
    static final int CHAR_MAX = 127;

    @CompilerDirectives.TruffleBoundary
    public static Locale fromPosix(TruffleString tposixLocaleId) {
        String language;
        if (tposixLocaleId == null) {
            return null;
        }
        if (tposixLocaleId.isEmpty()) {
            return Locale.getDefault();
        }
        String posixLocaleId = tposixLocaleId.toJavaStringUncached();
        String country = "";
        String variant = "";
        int len = posixLocaleId.length();
        int posCountrySep = posixLocaleId.indexOf(95);
        if (posCountrySep < 0) {
            language = posixLocaleId;
        } else {
            language = posixLocaleId.substring(0, posCountrySep);
            int posVariantSep = posixLocaleId.indexOf(46);
            if (posVariantSep < 0) {
                country = posixLocaleId.substring(posCountrySep + 1, len);
            } else {
                country = posixLocaleId.substring(posCountrySep + 1, posVariantSep);
                variant = posixLocaleId.substring(posVariantSep + 1, len);
            }
        }
        if (!language.isEmpty() && language.length() != 2) {
            return null;
        }
        if (!country.isEmpty() && country.length() != 2) {
            return null;
        }
        return new Locale(language, country, variant);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toPosix(Locale locale) {
        if (locale == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String language = locale.getLanguage();
        if (language.isEmpty()) {
            language = locale.getISO3Language();
        }
        if (!language.isEmpty()) {
            builder.append(language);
            String country = locale.getCountry();
            if (country.isEmpty()) {
                country = locale.getISO3Country();
            }
            if (!country.isEmpty()) {
                builder.append('_');
                builder.append(country.toUpperCase());
                Charset charset = Charset.defaultCharset();
                builder.append('.');
                builder.append(charset.name());
            }
        } else {
            return null;
        }
        return PythonUtils.toTruffleStringUncached(builder.toString());
    }

    protected List<? extends NodeFactory<? extends PythonBuiltinNode>> getNodeFactories() {
        return LocaleModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("LC_ALL", (Object)6);
        this.addBuiltinConstant("LC_COLLATE", (Object)3);
        this.addBuiltinConstant("LC_CTYPE", (Object)0);
        this.addBuiltinConstant("LC_MESSAGES", (Object)5);
        this.addBuiltinConstant("LC_MONETARY", (Object)4);
        this.addBuiltinConstant("LC_NUMERIC", (Object)1);
        this.addBuiltinConstant("LC_TIME", (Object)2);
        this.addBuiltinConstant("CHAR_MAX", (Object)127);
        this.addBuiltinConstant("Error", (Object)PythonBuiltinClassType.ValueError);
        super.initialize(core);
    }

    @Builtin(name="setlocale", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetLocaleNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isValidCategory(category)"})
        @CompilerDirectives.TruffleBoundary
        TruffleString doWithoutLocaleID(int category, PNone posixLocaleID) {
            Locale defaultLocale;
            Locale.Category displayCategory = null;
            Locale.Category formatCategory = null;
            if (!ImageInfo.inImageBuildtimeCode()) {
                displayCategory = Locale.Category.DISPLAY;
                formatCategory = Locale.Category.FORMAT;
                switch (category) {
                    case 0: 
                    case 3: 
                    case 5: {
                        formatCategory = null;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        displayCategory = null;
                        break;
                    }
                }
                defaultLocale = displayCategory != null ? Locale.getDefault(displayCategory) : Locale.getDefault(formatCategory);
            } else {
                defaultLocale = Locale.getDefault();
            }
            return LocaleModuleBuiltins.toPosix(defaultLocale);
        }

        @Specialization(guards={"isValidCategory(category)"})
        @CompilerDirectives.TruffleBoundary
        TruffleString doWithLocaleID(int category, TruffleString posixLocaleID) {
            Locale newLocale;
            Locale.Category displayCategory = null;
            Locale.Category formatCategory = null;
            if (!ImageInfo.inImageBuildtimeCode()) {
                displayCategory = Locale.Category.DISPLAY;
                formatCategory = Locale.Category.FORMAT;
                switch (category) {
                    case 0: 
                    case 3: 
                    case 5: {
                        formatCategory = null;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        displayCategory = null;
                        break;
                    }
                }
            }
            if ((newLocale = LocaleModuleBuiltins.fromPosix(posixLocaleID)) != null) {
                if (!ImageInfo.inImageBuildtimeCode()) {
                    if (displayCategory != null) {
                        Locale.setDefault(displayCategory, newLocale);
                    }
                    if (formatCategory != null) {
                        Locale.setDefault(formatCategory, newLocale);
                    }
                } else {
                    Locale.setDefault(newLocale);
                }
            } else {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_LOCALE_SETTING);
            }
            return LocaleModuleBuiltins.toPosix(newLocale);
        }

        @Specialization(replaces={"doWithoutLocaleID", "doWithLocaleID"})
        TruffleString doGeneric(VirtualFrame frame, Object category, Object posixLocaleID, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongNode asLongNode, @Cached CastToTruffleStringNode castToStringNode) {
            long l = asLongNode.execute((Frame)frame, inliningTarget, category);
            if (!SetLocaleNode.isValidCategory(l)) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_LOCALE_CATEGORY);
            }
            TruffleString posixLocaleIDStr = null;
            if (!PGuards.isPNone(posixLocaleID)) {
                try {
                    posixLocaleIDStr = castToStringNode.execute(inliningTarget, posixLocaleID);
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
            }
            if (posixLocaleIDStr != null) {
                return this.doWithLocaleID((int)l, posixLocaleIDStr);
            }
            return this.doWithoutLocaleID((int)l, PNone.NONE);
        }

        static boolean isValidCategory(long l) {
            return 0L <= l && l <= 6L;
        }
    }

    @Builtin(name="localeconv")
    @GenerateNodeFactory
    public static abstract class LocaleConvNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public PDict localeconv() {
            DecimalFormatSymbols decimalFormatSymbols;
            LinkedHashMap<String, Object> dict = new LinkedHashMap<String, Object>(20);
            Locale locale = Locale.getDefault(Locale.Category.FORMAT);
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            Currency currency = numberFormat.getCurrency();
            int groupSize = -1;
            if (numberFormat instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                groupSize = decimalFormat.getGroupingSize();
            } else {
                decimalFormatSymbols = new DecimalFormatSymbols(locale);
            }
            dict.put("decimal_point", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getDecimalSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("thousands_sep", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getGroupingSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            if (groupSize != -1) {
                dict.put("grouping", this.factory().createList(new Object[]{groupSize, 0}));
            } else {
                dict.put("grouping", this.factory().createList());
            }
            dict.put("int_curr_symbol", PythonUtils.toTruffleStringUncached(decimalFormatSymbols.getInternationalCurrencySymbol()));
            dict.put("currency_symbol", PythonUtils.toTruffleStringUncached(decimalFormatSymbols.getCurrencySymbol()));
            dict.put("mon_decimal_point", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getMonetaryDecimalSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("mon_thousands_sep", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getGroupingSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("mon_grouping", this.factory().createList());
            dict.put("positive_sign", "");
            dict.put("negative_sign", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getMinusSign(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("int_frac_digits", currency.getDefaultFractionDigits());
            dict.put("frac_digits", currency.getDefaultFractionDigits());
            dict.put("p_cs_precedes", PNone.NONE);
            dict.put("p_sep_by_space", PNone.NONE);
            dict.put("n_cs_precedes", PNone.NONE);
            dict.put("n_sep_by_space", PNone.NONE);
            dict.put("p_sign_posn", PNone.NONE);
            dict.put("n_sign_posn", PNone.NONE);
            return this.factory().createDictFromMap(dict);
        }
    }
}

