/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.JArrayModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.JArrayModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.util.List;

@CoreFunctions(defineModule="jarray")
public final class JArrayModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return JArrayModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="array", minNumOfPositionalArgs=2, parameterNames={"sequence", "type"})
    @GenerateNodeFactory
    static abstract class ArrayNode
    extends PythonBinaryBuiltinNode {
        ArrayNode() {
        }

        @Specialization
        Object fromSequence(PSequence sequence, Object type, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="5") InteropLibrary lib, @Cached.Shared @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached.Shared @Cached ZerosNode zerosNode) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
            int length = storage.length();
            Object array = zerosNode.execute(length, type);
            for (int i = 0; i < length; ++i) {
                Object value = getItemScalarNode.execute(inliningTarget, storage, i);
                try {
                    lib.writeArrayElement(array, (long)i, value);
                    continue;
                }
                catch (UnsupportedTypeException e) {
                    throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_P_NOT_SUPPORTED_BY_FOREIGN_OBJ, value);
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)"failed to set array item");
                }
            }
            return array;
        }

        @Specialization(guards={"!isPSequence(sequence)"})
        Object fromIterable(VirtualFrame frame, Object sequence, Object type, @Bind(value="this") Node inliningTarget, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Shared @CachedLibrary(limit="5") InteropLibrary lib, @Cached.Shared @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached.Shared @Cached ZerosNode zerosNode) {
            PList list = constructListNode.execute((Frame)frame, sequence);
            return this.fromSequence(list, type, inliningTarget, lib, getSequenceStorageNode, getItemScalarNode, zerosNode);
        }
    }

    @Builtin(name="zeros", minNumOfPositionalArgs=2, parameterNames={"length", "type"})
    @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class ZerosNode
    extends PythonBinaryClinicBuiltinNode {
        ZerosNode() {
        }

        public abstract Object execute(int var1, Object var2);

        @Specialization(guards={"isString(typeCodeObj)"})
        Object fromTypeCode(int length, Object typeCodeObj, @Cached CastToJavaStringNode cast, @Cached ArrayFromTypeCode fromTypeCodeNode) {
            String typeCode = cast.execute(typeCodeObj);
            Object array = fromTypeCodeNode.execute(length, typeCode);
            return this.getContext().getEnv().asGuestValue(array);
        }

        @Specialization(guards={"!isString(classObj)"})
        Object fromClass(int length, Object classObj) {
            Object clazz;
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (env.isHostObject(classObj) && (clazz = env.asHostObject(classObj)) instanceof Class) {
                Object array = Array.newInstance((Class)clazz, length);
                return env.asGuestValue(array);
            }
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.SECOND_ARG_MUST_BE_STR_OR_JAVA_CLS, classObj);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JArrayModuleBuiltinsClinicProviders.ZerosNodeClinicProviderGen.INSTANCE;
        }
    }

    static abstract class ArrayFromTypeCode
    extends PNodeWithRaise {
        protected static final String Z = "z";
        protected static final String C = "c";
        protected static final String B = "b";
        protected static final String H = "h";
        protected static final String I = "i";
        protected static final String L = "l";
        protected static final String F = "f";
        protected static final String D = "d";

        ArrayFromTypeCode() {
        }

        public abstract Object execute(int var1, String var2);

        @Specialization(guards={"eq(typeCode, Z)"})
        static Object z(int length, String typeCode) {
            return new boolean[length];
        }

        @Specialization(guards={"eq(typeCode, C)"})
        static Object c(int length, String typeCode) {
            return new char[length];
        }

        @Specialization(guards={"eq(typeCode, B)"})
        static Object b(int length, String typeCode) {
            return new byte[length];
        }

        @Specialization(guards={"eq(typeCode, H)"})
        static Object h(int length, String typeCode) {
            return new short[length];
        }

        @Specialization(guards={"eq(typeCode, I)"})
        static Object i(int length, String typeCode) {
            return new int[length];
        }

        @Specialization(guards={"eq(typeCode, L)"})
        static Object l(int length, String typeCode) {
            return new long[length];
        }

        @Specialization(guards={"eq(typeCode, F)"})
        static Object f(int length, String typeCode) {
            return new float[length];
        }

        @Specialization(guards={"eq(typeCode, D)"})
        static Object d(int length, String typeCode) {
            return new double[length];
        }

        @Fallback
        Object error(int length, String typeCode) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_TYPE_CODE, typeCode);
        }

        protected static boolean eq(String a, String b) {
            return b.equals(a);
        }
    }
}

