/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.word;

import jdk.vm.ci.meta.JavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.spi.WordVerification;
import org.graalvm.compiler.word.WordTypes;

public final class WordVerificationImpl
implements WordVerification {
    private final WordTypes wordTypes;

    public WordVerificationImpl(WordTypes wordTypes) {
        this.wordTypes = wordTypes;
    }

    @Override
    public boolean guaranteeWord(JavaType type) {
        GraalError.guarantee(this.wordTypes.isWord(type), "Expected a Word but got %s", (Object)type);
        return true;
    }

    @Override
    public boolean guaranteeNotWord(JavaType type) {
        GraalError.guarantee(!this.wordTypes.isWord(type), "Unexpected a Word type %s", (Object)type);
        return true;
    }
}

