/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.TruffleLogger;
import java.util.function.Function;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeServiceProvider;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

public interface EngineCacheSupport
extends GraalRuntimeServiceProvider {
    public void onEngineCreated(EngineData var1);

    public void onEnginePatch(EngineData var1);

    public boolean onEngineClosing(EngineData var1);

    public void onEngineClosed(EngineData var1);

    public boolean isStoreEnabled(OptionValues var1);

    public Object tryLoadingCachedEngine(OptionValues var1, Function<String, TruffleLogger> var2);

    public static EngineCacheSupport get() {
        return GraalTruffleRuntime.getRuntime().getEngineCacheSupport();
    }

    public static final class Disabled
    implements EngineCacheSupport {
        @Override
        public void onEngineCreated(EngineData e) {
        }

        @Override
        public void onEnginePatch(EngineData e) {
        }

        @Override
        public Object tryLoadingCachedEngine(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
            return null;
        }

        @Override
        public boolean onEngineClosing(EngineData e) {
            return false;
        }

        @Override
        public boolean isStoreEnabled(OptionValues options) {
            return false;
        }

        @Override
        public void onEngineClosed(EngineData e) {
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public OptionDescriptors getEngineOptions() {
            return OptionDescriptors.EMPTY;
        }
    }
}

