/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.util.GraphOrder;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PostPartialEvaluationSuite;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicyProvider;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;

public final class AgnosticInliningPhase
extends BasePhase<TruffleTierContext> {
    private static final ArrayList<InliningPolicyProvider> POLICY_PROVIDERS;
    private final PartialEvaluator partialEvaluator;
    private final PostPartialEvaluationSuite postPartialEvaluationSuite;

    public AgnosticInliningPhase(PartialEvaluator partialEvaluator, PostPartialEvaluationSuite postPartialEvaluationSuite) {
        this.partialEvaluator = partialEvaluator;
        this.postPartialEvaluationSuite = postPartialEvaluationSuite;
    }

    private static InliningPolicyProvider chosenProvider(String name) {
        for (InliningPolicyProvider provider : POLICY_PROVIDERS) {
            if (!provider.getName().equals(name)) continue;
            return provider;
        }
        throw new IllegalStateException("No inlining policy provider with provided name: " + name);
    }

    private static InliningPolicyProvider getInliningPolicyProvider(TruffleTierContext context) {
        boolean firstTier = context.isFirstTier();
        String policy = (String)context.options.get(firstTier ? PolyglotCompilerOptions.FirstTierInliningPolicy : PolyglotCompilerOptions.InliningPolicy);
        if (Objects.equals(policy, "")) {
            return POLICY_PROVIDERS.get(firstTier ? POLICY_PROVIDERS.size() - 1 : 0);
        }
        return AgnosticInliningPhase.chosenProvider(policy);
    }

    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        InliningPolicy policy = AgnosticInliningPhase.getInliningPolicyProvider(context).get(context.options, context);
        CallTree tree = new CallTree(this.partialEvaluator, this.postPartialEvaluationSuite, context, policy);
        tree.dumpBasic("Before Inline");
        if (AgnosticInliningPhase.optionsAllowInlining(context)) {
            policy.run(tree);
            tree.dumpBasic("After Inline");
            tree.collectTargetsToDequeue(context.task.inliningData());
            tree.updateTracingInfo(context.task.inliningData());
        }
        tree.finalizeGraph();
        tree.trace();
        if (!tree.getRoot().getChildren().isEmpty()) {
            this.postPartialEvaluationSuite.apply(graph, context);
        }
        graph.maybeCompress();
        assert (GraphOrder.assertSchedulableGraph(graph)) : "PE result must be schedulable in order to apply subsequent phases";
    }

    private static boolean optionsAllowInlining(TruffleTierContext context) {
        return (Boolean)context.options.get(PolyglotCompilerOptions.Inlining);
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    static {
        Iterable<InliningPolicyProvider> services = GraalServices.load(InliningPolicyProvider.class);
        ArrayList<InliningPolicyProvider> providers = new ArrayList<InliningPolicyProvider>();
        for (InliningPolicyProvider provider : services) {
            providers.add(provider);
        }
        Collections.sort(providers);
        POLICY_PROVIDERS = providers;
    }
}

