/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public final class ArrayCopyNode
extends BasicArrayCopyNode
implements Lowerable {
    public static final NodeClass<ArrayCopyNode> TYPE = NodeClass.create(ArrayCopyNode.class);
    protected final boolean forceAnyLocation;

    protected ArrayCopyNode(int bci, ValueNode src, ValueNode srcPos, ValueNode dst, ValueNode dstPos, ValueNode length, boolean forceAnyLocation) {
        super(TYPE, src, srcPos, dst, dstPos, length, null, bci);
        assert (StampTool.isPointerNonNull(src) && StampTool.isPointerNonNull(dst)) : "must have been null checked";
        this.forceAnyLocation = forceAnyLocation;
        if (!forceAnyLocation) {
            this.elementKind = ArrayCopyNode.selectComponentKind(this);
        } else assert (this.elementKind == null);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (!this.forceAnyLocation && this.elementKind == null) {
            this.elementKind = ArrayCopyNode.selectComponentKind(this);
        }
        if (this.elementKind != null) {
            return NamedLocationIdentity.getArrayLocation(this.elementKind);
        }
        return LocationIdentity.any();
    }

    public boolean killsAnyLocation() {
        return this.forceAnyLocation;
    }
}

