/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Optional;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.BasePhase;

public class NodeCounterPhase
extends BasePhase<CoreProviders> {
    private final Stage stage;

    public NodeCounterPhase(Stage stage) {
        this.stage = stage;
    }

    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (Node node : graph.getNodes()) {
            String nodeName = node.getNodeClass().getClazz().getSimpleName();
            DebugContext.counter("NodeCounter_%s_%s", (Object)this.stage, nodeName).increment(node.getDebug());
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> NodeCounters = new OptionKey<Boolean>(false);
    }

    public static enum Stage {
        INIT,
        EARLY,
        LATE;

    }
}

