/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ImplicitNullCheckNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class NullCheckNode
extends ImplicitNullCheckNode
implements LIRLowerable,
GuardingNode {
    public static final NodeClass<NullCheckNode> TYPE = NodeClass.create(NullCheckNode.class);
    @Node.Input
    ValueNode object;

    public NullCheckNode(ValueNode object) {
        this(object, null, null);
    }

    public NullCheckNode(ValueNode object, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        super((NodeClass<? extends ImplicitNullCheckNode>)TYPE, StampFactory.forVoid());
        this.object = object;
        assert (deoptReasonAndAction == null == (deoptSpeculation == null));
        this.deoptReasonAndAction = deoptReasonAndAction;
        this.deoptSpeculation = deoptSpeculation;
    }

    public static NullCheckNode create(ValueNode object, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        NullCheckNode nullCheck = NullCheckNode.tryUseUncompressedNullCheck(object);
        if (nullCheck != null) {
            return nullCheck;
        }
        return new NullCheckNode(object, deoptReasonAndAction, deoptSpeculation);
    }

    private static NullCheckNode tryUseUncompressedNullCheck(ValueNode value) {
        Stamp stamp = value.stamp(NodeView.DEFAULT);
        if (!(stamp instanceof AbstractPointerStamp) || !((AbstractPointerStamp)stamp).isCompressed()) {
            return null;
        }
        UnaryNode uncompressed = null;
        for (Node usage : value.usages()) {
            if (!(usage instanceof CompressionNode) || ((CompressionNode)usage).getOp() != CompressionNode.CompressionOp.Uncompress) continue;
            uncompressed = (CompressionNode)usage;
            break;
        }
        if (uncompressed == null) {
            return null;
        }
        assert (uncompressed.getValue().equals(value));
        StructuredGraph graph = value.graph();
        CompressionNode compression = (CompressionNode)uncompressed.copyWithInputs(false);
        compression = graph.addOrUniqueWithInputs(compression);
        OffsetAddressNode address = graph.addOrUniqueWithInputs(OffsetAddressNode.create(compression));
        return new NullCheckNode(address);
    }

    public ValueNode getObject() {
        return this.object;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().emitNullCheck(generator.operand(this.object), generator.state(this));
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Node.NodeIntrinsic
    public static native void nullCheck(Object var0);
}

