/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_4)
public final class ClassIsArrayNode
extends LogicNode
implements Canonicalizable.Unary<ValueNode>,
Lowerable {
    public static final NodeClass<ClassIsArrayNode> TYPE = NodeClass.create(ClassIsArrayNode.class);
    @Node.Input
    protected ValueNode value;

    protected ClassIsArrayNode(ValueNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, ValueNode forValue) {
        return ClassIsArrayNode.canonicalized(null, forValue, constantReflection);
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        return ClassIsArrayNode.canonicalized(this, forValue, tool.getConstantReflection());
    }

    private static LogicNode canonicalized(ClassIsArrayNode node, ValueNode forValue, ConstantReflectionProvider constantReflection) {
        if (forValue.isConstant()) {
            ResolvedJavaType type = constantReflection.asJavaType(forValue.asConstant());
            if (type != null) {
                return LogicConstantNode.forBoolean(type.isArray());
            }
        } else if (forValue instanceof GetClassNode) {
            return ObjectIsArrayNode.create(((GetClassNode)forValue).getObject());
        }
        return node != null ? node : new ClassIsArrayNode(forValue);
    }
}

