/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Value, InputType.Memory}, cycles=NodeCycles.CYCLES_8, cyclesRationale="Node will be lowered to a foreign call.", size=NodeSize.SIZE_8)
public final class BytecodeExceptionNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill,
Canonicalizable {
    public static final NodeClass<BytecodeExceptionNode> TYPE = NodeClass.create(BytecodeExceptionNode.class);
    protected final BytecodeExceptionKind exceptionKind;
    @Node.Input
    NodeInputList<ValueNode> arguments;

    public BytecodeExceptionNode(MetaAccessProvider metaAccess, BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(metaAccess.lookupJavaType(exceptionKind.exceptionClass))));
        this.exceptionKind = exceptionKind;
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        GraalError.guarantee(arguments.length == exceptionKind.numArguments, "Mismatch in argument count for BytecodeExceptionNode");
    }

    public BytecodeExceptionKind getExceptionKind() {
        return this.exceptionKind;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + this.exceptionKind;
        }
        return super.toString(verbosity);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && (this.hasNoUsages() || this.hasExactlyOneUsage() && this.usages().first() == this.stateAfter)) {
            return null;
        }
        return this;
    }

    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public FrameState createStateDuring() {
        boolean rethrowException = false;
        boolean duringCall = true;
        FrameState stateDuring = this.stateAfter.duplicateModified(this.graph(), this.stateAfter.bci, rethrowException, duringCall, JavaKind.Object, null, null, null);
        stateDuring.invalidateForDeoptimization();
        return stateDuring;
    }

    public static enum BytecodeExceptionKind {
        NULL_POINTER(0, NullPointerException.class),
        OUT_OF_BOUNDS(2, ArrayIndexOutOfBoundsException.class),
        INTRINSIC_OUT_OF_BOUNDS(0, ArrayIndexOutOfBoundsException.class),
        CLASS_CAST(2, ClassCastException.class),
        ARRAY_STORE(1, ArrayStoreException.class),
        ASSERTION_ERROR_NULLARY(0, AssertionError.class),
        ASSERTION_ERROR_OBJECT(1, AssertionError.class),
        ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH(0, IllegalArgumentException.class, "Negative length"),
        ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY(0, IllegalArgumentException.class, "Argument is not an array"),
        NEGATIVE_ARRAY_SIZE(1, NegativeArraySizeException.class),
        DIVISION_BY_ZERO(0, ArithmeticException.class),
        INTEGER_EXACT_OVERFLOW(0, ArithmeticException.class),
        LONG_EXACT_OVERFLOW(0, ArithmeticException.class);

        final int numArguments;
        final Class<? extends Throwable> exceptionClass;
        final String exceptionMessage;

        private BytecodeExceptionKind(int numArguments, Class<? extends Throwable> exceptionClass) {
            this(numArguments, exceptionClass, null);
        }

        private BytecodeExceptionKind(int numArguments, Class<? extends Throwable> exceptionClass, String exceptionMessage) {
            this.numArguments = numArguments;
            this.exceptionClass = exceptionClass;
            this.exceptionMessage = exceptionMessage;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public int getNumArguments() {
            return this.numArguments;
        }
    }
}

