/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class SignExtendNode
extends IntegerConvertNode<ArithmeticOpTable.IntegerConvertOp.SignExtend> {
    public static final NodeClass<SignExtendNode> TYPE = NodeClass.create(SignExtendNode.class);

    public SignExtendNode(ValueNode input, int resultBits) {
        this(input, PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)), resultBits);
        assert (0 < PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)) && PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)) <= resultBits);
    }

    public SignExtendNode(ValueNode input, int inputBits, int resultBits) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(input).getSignExtend(), inputBits, resultBits, input);
    }

    public static ValueNode create(ValueNode input, int resultBits, NodeView view) {
        return SignExtendNode.create(input, PrimitiveStamp.getBits(input.stamp(view)), resultBits, view);
    }

    public static ValueNode create(ValueNode input, int inputBits, int resultBits, NodeView view) {
        ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.SignExtend> signExtend = ArithmeticOpTable.forStamp(input.stamp(view)).getSignExtend();
        ValueNode synonym = SignExtendNode.findSynonym(signExtend, input, inputBits, resultBits, signExtend.foldStamp(inputBits, resultBits, input.stamp(view)));
        if (synonym != null) {
            return synonym;
        }
        return SignExtendNode.canonical(null, input, inputBits, resultBits, view);
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.SignExtend> getOp(ArithmeticOpTable table) {
        return table.getSignExtend();
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.Narrow> getReverseOp(ArithmeticOpTable table) {
        return table.getNarrow();
    }

    @Override
    public boolean isLossless() {
        return true;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        return SignExtendNode.canonical(this, forValue, this.getInputBits(), this.getResultBits(), view);
    }

    private static ValueNode canonical(SignExtendNode self, ValueNode forValue, int inputBits, int resultBits, NodeView view) {
        NarrowNode narrow;
        Stamp inputStamp;
        IntegerStamp inputStamp2;
        ZeroExtendNode other;
        if (forValue instanceof SignExtendNode) {
            SignExtendNode other2 = (SignExtendNode)forValue;
            return SignExtendNode.create(other2.getValue(), other2.getInputBits(), resultBits, view);
        }
        if (forValue instanceof ZeroExtendNode && (other = (ZeroExtendNode)forValue).getResultBits() > other.getInputBits()) {
            return ZeroExtendNode.create(other.getValue(), other.getInputBits(), resultBits, view, other.isInputAlwaysPositive());
        }
        if (forValue.stamp(view) instanceof IntegerStamp && ((inputStamp2 = (IntegerStamp)forValue.stamp(view)).upMask() & 1L << inputBits - 1) == 0L) {
            return ZeroExtendNode.create(forValue, inputBits, resultBits, view, true);
        }
        if (forValue instanceof NarrowNode && (inputStamp = (narrow = (NarrowNode)forValue).getValue().stamp(view)) instanceof IntegerStamp) {
            IntegerStamp istamp = (IntegerStamp)inputStamp;
            long mask = CodeUtil.mask((int)(PrimitiveStamp.getBits(narrow.stamp(view)) - 1));
            if ((mask ^ 0xFFFFFFFFFFFFFFFFL) <= istamp.lowerBound() && istamp.upperBound() <= mask) {
                if (istamp.getBits() < resultBits) {
                    return SignExtendNode.create(narrow.getValue(), resultBits, view);
                }
                if (istamp.getBits() > resultBits) {
                    return NarrowNode.create(narrow.getValue(), resultBits, view);
                }
                assert (istamp.getBits() == resultBits);
                return narrow.getValue();
            }
        }
        return self != null ? self : new SignExtendNode(forValue, inputBits, resultBits);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitSignExtend(nodeValueMap.operand(this.getValue()), this.getInputBits(), this.getResultBits()));
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return true;
    }
}

