/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
public final class HasNegativesNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<HasNegativesNode> TYPE = NodeClass.create(HasNegativesNode.class);
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode len;

    public HasNegativesNode(ValueNode array, ValueNode len) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.array = array;
        this.len = len;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitHasNegatives(gen.operand(this.array), gen.operand(this.len)));
    }
}

