/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="Deopt", nameTemplate="Deopt {p#reason/s}")
public final class DeoptimizeNode
extends AbstractDeoptimizeNode
implements Lowerable,
LIRLowerable,
StaticDeoptimizingNode {
    public static final int DEFAULT_DEBUG_ID = 0;
    public static final NodeClass<DeoptimizeNode> TYPE = NodeClass.create(DeoptimizeNode.class);
    protected DeoptimizationAction action;
    protected DeoptimizationReason reason;
    protected int debugId;
    protected final SpeculationLog.Speculation speculation;

    public DeoptimizeNode(DeoptimizationAction action, DeoptimizationReason reason) {
        this(action, reason, 0, SpeculationLog.NO_SPECULATION, null);
    }

    public DeoptimizeNode(DeoptimizationAction action, DeoptimizationReason reason, SpeculationLog.Speculation speculation) {
        this(action, reason, 0, speculation, null);
    }

    public DeoptimizeNode(DeoptimizationAction action, DeoptimizationReason reason, int debugId, SpeculationLog.Speculation speculation, FrameState stateBefore) {
        super(TYPE, stateBefore);
        assert (action != null);
        assert (reason != null);
        this.action = action;
        this.reason = reason;
        this.debugId = debugId;
        assert (speculation != null);
        this.speculation = speculation;
    }

    @Override
    public DeoptimizationAction getAction() {
        return this.action;
    }

    @Override
    public void setAction(DeoptimizationAction action) {
        this.action = action;
    }

    @Override
    public DeoptimizationReason getReason() {
        return this.reason;
    }

    @Override
    public void setReason(DeoptimizationReason reason) {
        this.reason = reason;
    }

    public int getDebugId() {
        DebugContext debug;
        int deoptDebugId = this.debugId;
        if (deoptDebugId == 0 && ((debug = this.getDebug()).isDumpEnabledForMethod() || debug.isLogEnabledForMethod())) {
            deoptDebugId = this.getId();
        }
        return deoptDebugId;
    }

    public void setDebugId(int debugId) {
        assert (debugId != 0);
        this.debugId = debugId;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        Value actionAndReason = tool.emitJavaConstant(tool.getMetaAccess().encodeDeoptActionAndReason(this.action, this.reason, this.getDebugId()));
        Value speculationValue = tool.emitJavaConstant(tool.getMetaAccess().encodeSpeculation(this.speculation));
        gen.getLIRGeneratorTool().emitDeoptimize(actionAndReason, speculationValue, gen.state(this));
    }

    @Override
    public ValueNode getActionAndReason(MetaAccessProvider metaAccess) {
        return ConstantNode.forConstant(metaAccess.encodeDeoptActionAndReason(this.action, this.reason, this.getDebugId()), metaAccess, this.graph());
    }

    @Override
    public ValueNode getSpeculation(MetaAccessProvider metaAccess) {
        return ConstantNode.forConstant(metaAccess.encodeSpeculation(this.speculation), metaAccess, this.graph());
    }

    @Override
    public SpeculationLog.Speculation getSpeculation() {
        return this.speculation;
    }

    @Node.NodeIntrinsic
    public static native void deopt(@Node.ConstantNodeParameter DeoptimizationAction var0, @Node.ConstantNodeParameter DeoptimizationReason var1);
}

