/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public abstract class BinaryOpLogicNode
extends LogicNode
implements LIRLowerable,
Canonicalizable.Binary<ValueNode> {
    public static final NodeClass<BinaryOpLogicNode> TYPE = NodeClass.create(BinaryOpLogicNode.class);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode y;

    @Override
    public ValueNode getX() {
        return this.x;
    }

    @Override
    public ValueNode getY() {
        return this.y;
    }

    public void setX(ValueNode newX) {
        assert (newX != null);
        this.updateUsages(this.x, newX);
        this.x = newX;
    }

    public void setY(ValueNode newY) {
        assert (newY != null);
        this.updateUsages(this.y, newY);
        this.y = newY;
    }

    public BinaryOpLogicNode(NodeClass<? extends BinaryOpLogicNode> c, ValueNode x, ValueNode y) {
        super((NodeClass<? extends LogicNode>)c);
        assert (x != null && y != null);
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean verify() {
        return super.verify();
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    public LogicNode maybeCommuteInputs() {
        assert (this instanceof Canonicalizable.BinaryCommutative);
        if (!this.y.isConstant() && (this.x.isConstant() || this.x.getId() > this.y.getId())) {
            LogicNode duplicate;
            ValueNode tmp = this.x;
            this.x = this.y;
            this.y = tmp;
            if (this.graph() != null && (duplicate = (LogicNode)this.graph().findDuplicate(this)) != null) {
                return duplicate;
            }
        }
        return this;
    }

    public abstract Stamp getSucceedingStampForX(boolean var1, Stamp var2, Stamp var3);

    public abstract Stamp getSucceedingStampForY(boolean var1, Stamp var2, Stamp var3);

    public abstract TriState tryFold(Stamp var1, Stamp var2);
}

