/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.dfa;

import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.InstructionStateProcedure;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.dfa.UniqueWorkList;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.util.ValueSet;

public abstract class LocationMarker<S extends ValueSet<S>> {
    private final LIR lir;
    private final BlockMap<S> liveInMap;
    private final BlockMap<S> liveOutMap;
    protected final FrameMap frameMap;
    private static final EnumSet<LIRInstruction.OperandFlag> REGISTER_FLAG_SET = EnumSet.of(LIRInstruction.OperandFlag.REG);
    private S currentSet;
    InstructionStateProcedure stateConsumer = new InstructionStateProcedure(){

        @Override
        public void doState(LIRInstruction inst, LIRFrameState info) {
            LocationMarker.this.processState(inst, info, LocationMarker.this.currentSet);
        }
    };
    ValueConsumer useConsumer = new ValueConsumer(){

        @Override
        public void visitValue(Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (LocationMarker.this.shouldProcessValue(operand)) {
                DebugContext debug = LocationMarker.this.lir.getDebug();
                if (debug.isLogEnabled()) {
                    debug.log("set operand: %s", operand);
                }
                ((ValueSet)LocationMarker.this.currentSet).put(operand);
            }
        }
    };
    ValueConsumer defConsumer = new ValueConsumer(){

        @Override
        public void visitValue(Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (LocationMarker.this.shouldProcessValue(operand)) {
                DebugContext debug = LocationMarker.this.lir.getDebug();
                if (debug.isLogEnabled()) {
                    debug.log("clear operand: %s", operand);
                }
                ((ValueSet)LocationMarker.this.currentSet).remove(operand);
            } else assert (ValueUtil.isIllegal((Value)operand) || !operand.getValueKind().equals((Object)LIRKind.Illegal) || mode == LIRInstruction.OperandMode.TEMP) : String.format("Illegal PlatformKind is only allowed for TEMP mode: %s, %s", new Object[]{operand, mode});
        }
    };

    protected LocationMarker(LIR lir, FrameMap frameMap) {
        this.lir = lir;
        this.frameMap = frameMap;
        this.liveInMap = new BlockMap(lir.getControlFlowGraph());
        this.liveOutMap = new BlockMap(lir.getControlFlowGraph());
    }

    protected abstract S newLiveValueSet();

    protected abstract boolean shouldProcessValue(Value var1);

    protected abstract void processState(LIRInstruction var1, LIRFrameState var2, S var3);

    void build() {
        AbstractBlockBase[] blocks = this.lir.getControlFlowGraph().getBlocks();
        UniqueWorkList worklist = new UniqueWorkList(blocks.length);
        for (int i = blocks.length - 1; i >= 0; --i) {
            worklist.add(blocks[i]);
        }
        for (AbstractBlockBase block : this.lir.getControlFlowGraph().getBlocks()) {
            this.liveInMap.put(block, this.newLiveValueSet());
        }
        while (!worklist.isEmpty()) {
            Object block = worklist.poll();
            this.processBlock((AbstractBlockBase<?>)block, worklist);
        }
    }

    private boolean updateOutBlock(AbstractBlockBase<?> block) {
        ValueSet union = this.newLiveValueSet();
        for (AbstractBlockBase succ : block.getSuccessors()) {
            union.putAll((ValueSet)((ValueSet)this.liveInMap.get(succ)));
        }
        ValueSet outSet = (ValueSet)this.liveOutMap.get(block);
        if (outSet == null || !union.equals(outSet)) {
            this.liveOutMap.put(block, union);
            return true;
        }
        return false;
    }

    private void processBlock(AbstractBlockBase<?> block, UniqueWorkList worklist) {
        if (this.updateOutBlock(block)) {
            DebugContext debug = this.lir.getDebug();
            try (Indent indent = debug.logAndIndent("handle block %s", block);){
                this.currentSet = ((ValueSet)this.liveOutMap.get(block)).copy();
                ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
                for (int i = instructions.size() - 1; i >= 0; --i) {
                    LIRInstruction inst = instructions.get(i);
                    this.processInstructionBottomUp(inst);
                }
                this.liveInMap.put(block, this.currentSet);
                this.currentSet = null;
                for (AbstractBlockBase b : block.getPredecessors()) {
                    worklist.add(b);
                }
            }
        }
    }

    private void processInstructionBottomUp(LIRInstruction op) {
        DebugContext debug = this.lir.getDebug();
        try (Indent indent = debug.logAndIndent("handle op %d, %s", op.id(), (Object)op);){
            op.visitEachTemp(this.defConsumer);
            op.visitEachOutput(this.defConsumer);
            if (this.frameMap != null && op.destroysCallerSavedRegisters()) {
                for (Register reg : this.frameMap.getRegisterConfig().getCallerSaveRegisters()) {
                    PlatformKind kind = this.frameMap.getTarget().arch.getLargestStorableKind(reg.getRegisterCategory());
                    this.defConsumer.visitValue((Value)reg.asValue((ValueKind)LIRKind.value(kind)), LIRInstruction.OperandMode.TEMP, REGISTER_FLAG_SET);
                }
            }
            op.visitEachAlive(this.useConsumer);
            op.visitEachState(this.useConsumer);
            op.forEachState(this.stateConsumer);
            op.visitEachInput(this.useConsumer);
        }
    }
}

