/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.asm;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.Constant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstructionVerifier;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public interface CompilationResultBuilderFactory {
    public static final CompilationResultBuilderFactory Default = new CompilationResultBuilderFactory(){
        private List<LIRInstructionVerifier> lirInstructionVerifiers = new ArrayList<LIRInstructionVerifier>();
        private volatile boolean isVerifierInitialized = false;

        private void initializeLIRVerifiers(String lirInstructionVerifierPath) {
            try {
                URL verifierURL = Paths.get(lirInstructionVerifierPath, new String[0]).toUri().toURL();
                URLClassLoader cl = new URLClassLoader(new URL[]{verifierURL}, ClassLoader.getPlatformClassLoader());
                for (LIRInstructionVerifier verifier : ServiceLoader.load(LIRInstructionVerifier.class, cl)) {
                    if (!verifier.isEnabled()) continue;
                    this.lirInstructionVerifiers.add(verifier);
                }
            }
            catch (MalformedURLException e) {
                throw GraalError.shouldNotReachHere(e, "Malformed URL encountered.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationResultBuilder createBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler<?> asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister) {
            if (!this.isVerifierInitialized) {
                List<LIRInstructionVerifier> list = this.lirInstructionVerifiers;
                synchronized (list) {
                    if (!this.isVerifierInitialized) {
                        String lirInstructionVerifierPath = Options.LIRInstructionVerifierPath.getValue(options);
                        if (lirInstructionVerifierPath != null && !lirInstructionVerifierPath.isEmpty()) {
                            this.initializeLIRVerifiers(lirInstructionVerifierPath);
                        }
                        this.isVerifierInitialized = true;
                    }
                }
            }
            return new CompilationResultBuilder(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, (EconomicMap<Constant, DataSection.Data>)EconomicMap.create((Equivalence)Equivalence.DEFAULT), this.lirInstructionVerifiers);
        }
    };

    public CompilationResultBuilder createBuilder(CodeGenProviders var1, FrameMap var2, Assembler<?> var3, DataBuilder var4, FrameContext var5, OptionValues var6, DebugContext var7, CompilationResult var8, Register var9);

    public static class Options {
        public static final OptionKey<String> LIRInstructionVerifierPath = new OptionKey<Object>(null);
    }
}

