/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="ARRAY_EQUALS")
public final class AArch64ArrayEqualsOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ArrayEqualsOp> TYPE = LIRInstructionClass.create(AArch64ArrayEqualsOp.class);
    private final Stride stride;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value offset1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array2Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value offset2Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value lengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp4;
    private static final int VECTOR_SIZE = 8;

    public AArch64ArrayEqualsOp(LIRGeneratorTool tool, Stride stride, Value result, Value array1, Value offset1, Value array2, Value offset2, Value length) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.stride = stride;
        assert (result.getPlatformKind() == AArch64Kind.DWORD);
        assert (array1.getPlatformKind() == AArch64Kind.QWORD && array1.getPlatformKind() == array2.getPlatformKind());
        assert (offset1 == null || offset1.getPlatformKind() == AArch64Kind.QWORD);
        assert (offset2 == null || offset2.getPlatformKind() == AArch64Kind.QWORD);
        assert (length.getPlatformKind() == AArch64Kind.DWORD);
        this.resultValue = result;
        this.array1Value = array1;
        this.offset1Value = offset1 == null ? Value.ILLEGAL : offset1;
        this.array2Value = array2;
        this.offset2Value = offset2 == null ? Value.ILLEGAL : offset2;
        this.lengthValue = length;
        LIRKind archWordKind = LIRKind.value(tool.target().arch.getWordKind());
        this.temp1 = tool.newVariable(archWordKind);
        this.temp2 = tool.newVariable(archWordKind);
        this.temp3 = tool.newVariable(archWordKind);
        this.temp4 = tool.newVariable(archWordKind);
        LIRKind vectorKind = LIRKind.value(tool.target().arch.getLargestStorableKind(AArch64.SIMD));
        this.vectorTemp1 = tool.newVariable(vectorKind);
        this.vectorTemp2 = tool.newVariable(vectorKind);
        this.vectorTemp3 = tool.newVariable(vectorKind);
        this.vectorTemp4 = tool.newVariable(vectorKind);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register byteArrayLength = ValueUtil.asRegister((Value)this.temp1);
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            Label breakLabel = new Label();
            Label scalarCompare = new Label();
            Register hasMismatch = sc1.getRegister();
            Register scratch = sc2.getRegister();
            masm.mov(32, byteArrayLength, ValueUtil.asRegister((Value)this.lengthValue));
            masm.lsl(64, byteArrayLength, byteArrayLength, this.stride.log2);
            masm.compare(32, ValueUtil.asRegister((Value)this.lengthValue), 32 / this.stride.value);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, scalarCompare);
            this.emitSIMDCompare(masm, byteArrayLength, hasMismatch, scratch, breakLabel);
            masm.bind(scalarCompare);
            this.emitScalarCompare(masm, byteArrayLength, hasMismatch, scratch, breakLabel);
            masm.bind(breakLabel);
            masm.cmp(64, hasMismatch, AArch64.zr);
            masm.cset(32, ValueUtil.asRegister((Value)this.resultValue), AArch64Assembler.ConditionFlag.EQ);
        }
    }

    private void loadArrayStart(AArch64MacroAssembler masm, Register array1, Register array2) {
        masm.add(64, array1, ValueUtil.asRegister((Value)this.array1Value), ValueUtil.asRegister((Value)this.offset1Value));
        masm.add(64, array2, ValueUtil.asRegister((Value)this.array2Value), ValueUtil.asRegister((Value)this.offset2Value));
    }

    private void emitScalarCompare(AArch64MacroAssembler masm, Register byteArrayLength, Register hasMismatch, Register scratch, Label breakLabel) {
        Register array1 = ValueUtil.asRegister((Value)this.temp2);
        Register array2 = ValueUtil.asRegister((Value)this.temp3);
        this.loadArrayStart(masm, array1, array2);
        masm.mov(64, scratch, byteArrayLength);
        this.emit8ByteCompare(masm, scratch, array1, array2, byteArrayLength, breakLabel, hasMismatch);
        this.emitTailCompares(masm, scratch, array1, array2, breakLabel, hasMismatch);
    }

    private void emit8ByteCompare(AArch64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label breakLabel, Register rscratch1) {
        Label loop = new Label();
        Label compareTail = new Label();
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        masm.and(64, result, result, 7L);
        masm.ands(64, length, length, -8L);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, compareTail);
        masm.add(64, array1, array1, length);
        masm.add(64, array2, array2, length);
        masm.sub(64, length, AArch64.zr, length);
        masm.align(16);
        masm.bind(loop);
        masm.ldr(64, temp, AArch64Address.createRegisterOffsetAddress(64, array1, length, false));
        masm.ldr(64, rscratch1, AArch64Address.createRegisterOffsetAddress(64, array2, length, false));
        masm.eor(64, rscratch1, temp, rscratch1);
        masm.cbnz(64, rscratch1, breakLabel);
        masm.add(64, length, length, 8);
        masm.cbnz(64, length, loop);
        masm.cbz(64, result, breakLabel);
        masm.add(64, array1, array1, -8);
        masm.add(64, array2, array2, -8);
        masm.ldr(64, temp, AArch64Address.createRegisterOffsetAddress(64, array1, result, false));
        masm.ldr(64, rscratch1, AArch64Address.createRegisterOffsetAddress(64, array2, result, false));
        masm.eor(64, rscratch1, temp, rscratch1);
        masm.jmp(breakLabel);
        masm.bind(compareTail);
    }

    private void emitTailCompares(AArch64MacroAssembler masm, Register result, Register array1, Register array2, Label breakLabel, Register rscratch1) {
        Label compare2Bytes = new Label();
        Label compare1Byte = new Label();
        Label end = new Label();
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        if (this.stride.value <= 4) {
            masm.ands(32, AArch64.zr, result, 4L);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, compare2Bytes);
            masm.ldr(32, temp, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, 4));
            masm.ldr(32, rscratch1, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array2, 4));
            masm.eor(32, rscratch1, temp, rscratch1);
            masm.cbnz(32, rscratch1, breakLabel);
            if (this.stride.value <= 2) {
                masm.bind(compare2Bytes);
                masm.ands(32, AArch64.zr, result, 2L);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, compare1Byte);
                masm.ldr(16, temp, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, 2));
                masm.ldr(16, rscratch1, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array2, 2));
                masm.eor(32, rscratch1, temp, rscratch1);
                masm.cbnz(32, rscratch1, breakLabel);
                if (this.stride.value <= 1) {
                    masm.bind(compare1Byte);
                    masm.ands(32, AArch64.zr, result, 1L);
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, end);
                    masm.ldr(8, temp, AArch64Address.createBaseRegisterOnlyAddress(8, array1));
                    masm.ldr(8, rscratch1, AArch64Address.createBaseRegisterOnlyAddress(8, array2));
                    masm.eor(32, rscratch1, temp, rscratch1);
                    masm.cbnz(32, rscratch1, breakLabel);
                } else {
                    masm.bind(compare1Byte);
                }
            } else {
                masm.bind(compare2Bytes);
            }
        }
        masm.bind(end);
        masm.mov(64, rscratch1, AArch64.zr);
    }

    private void emitSIMDCompare(AArch64MacroAssembler masm, Register byteArrayLength, Register hasMismatch, Register scratch, Label endLabel) {
        Register array1Address = ValueUtil.asRegister((Value)this.temp2);
        Register array2Address = ValueUtil.asRegister((Value)this.temp3);
        Register refAddress1 = ValueUtil.asRegister((Value)this.temp4);
        Register endOfArray1 = scratch;
        Register array1Part1RegV = ValueUtil.asRegister((Value)this.vectorTemp1);
        Register array1Part2RegV = ValueUtil.asRegister((Value)this.vectorTemp2);
        Register array2Part1RegV = ValueUtil.asRegister((Value)this.vectorTemp3);
        Register array2Part2RegV = ValueUtil.asRegister((Value)this.vectorTemp4);
        Label compareByChunkHead = new Label();
        Label compareByChunkTail = new Label();
        Label processTail = new Label();
        this.loadArrayStart(masm, array1Address, array2Address);
        masm.add(64, endOfArray1, array1Address, byteArrayLength);
        masm.sub(64, refAddress1, endOfArray1, 32);
        masm.fldp(128, array1Part1RegV, array1Part2RegV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array1Address, 32));
        masm.fldp(128, array2Part1RegV, array2Part2RegV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array2Address, 32));
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, array1Part1RegV, array1Part1RegV, array2Part1RegV);
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, array1Part2RegV, array1Part2RegV, array2Part2RegV);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, array1Part1RegV, array1Part1RegV, array1Part2RegV);
        masm.neon.uminvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, array1Part1RegV, array1Part1RegV);
        masm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.Word, hasMismatch, array1Part1RegV, 0);
        masm.add(64, hasMismatch, hasMismatch, 1);
        masm.cbnz(64, hasMismatch, endLabel);
        Register array1Alignment = ValueUtil.asRegister((Value)this.resultValue);
        masm.and(64, array1Alignment, array1Address, 31L);
        masm.sub(64, array2Address, array2Address, array1Alignment);
        masm.bic(64, array1Address, array1Address, 31L);
        masm.align(16);
        masm.bind(compareByChunkHead);
        masm.cmp(64, refAddress1, array1Address);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, processTail);
        masm.bind(compareByChunkTail);
        masm.fldp(128, array1Part1RegV, array1Part2RegV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array1Address, 32));
        masm.fldp(128, array2Part1RegV, array2Part2RegV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array2Address, 32));
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, array1Part1RegV, array1Part1RegV, array2Part1RegV);
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, array1Part2RegV, array1Part2RegV, array2Part2RegV);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, array1Part1RegV, array1Part1RegV, array1Part2RegV);
        masm.neon.uminvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, array1Part1RegV, array1Part1RegV);
        masm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.Word, hasMismatch, array1Part1RegV, 0);
        masm.add(64, hasMismatch, hasMismatch, 1);
        masm.cbz(64, hasMismatch, compareByChunkHead);
        masm.jmp(endLabel);
        masm.align(16);
        masm.bind(processTail);
        masm.cmp(64, array1Address, endOfArray1);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, endLabel);
        masm.mov(64, array1Address, refAddress1);
        if (!this.offset2Value.equals((Object)Value.ILLEGAL)) {
            masm.add(64, array2Address, ValueUtil.asRegister((Value)this.array2Value), ValueUtil.asRegister((Value)this.offset2Value));
            masm.sub(64, array2Address, array2Address, 32);
        } else {
            masm.sub(64, array2Address, ValueUtil.asRegister((Value)this.array2Value), 32);
        }
        masm.add(64, array2Address, array2Address, byteArrayLength);
        masm.jmp(compareByChunkTail);
    }
}

