/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.util.Arrays;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.TypeCheckHints;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;

public class TypeCheckSnippetUtils {
    static boolean checkSecondarySubType(KlassPointer t, KlassPointer sNonNull, Counters counters) {
        if (sNonNull.readKlassPointer(HotSpotReplacementsUtil.secondarySuperCacheOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION).equal(t)) {
            counters.cacheHit.inc();
            return true;
        }
        return TypeCheckSnippetUtils.checkSelfAndSupers(t, sNonNull, counters);
    }

    static boolean checkUnknownSubType(KlassPointer t, KlassPointer sNonNull, Counters counters) {
        boolean primary;
        int superCheckOffset = t.readInt(HotSpotReplacementsUtil.superCheckOffsetOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_SUPER_CHECK_OFFSET_LOCATION);
        boolean bl = primary = superCheckOffset != HotSpotReplacementsUtil.secondarySuperCacheOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        if (sNonNull.readKlassPointer(superCheckOffset, HotSpotReplacementsUtil.PRIMARY_SUPERS_LOCATION).equal(t)) {
            if (primary) {
                counters.cacheHit.inc();
            } else {
                counters.displayHit.inc();
            }
            return true;
        }
        if (primary) {
            counters.displayMiss.inc();
            return false;
        }
        return TypeCheckSnippetUtils.checkSelfAndSupers(t, sNonNull, counters);
    }

    private static boolean checkSelfAndSupers(KlassPointer t, KlassPointer s, Counters counters) {
        if (s.equal(t)) {
            counters.equalsSecondary.inc();
            return true;
        }
        Word secondarySupers = s.readWord(HotSpotReplacementsUtil.secondarySupersOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.SECONDARY_SUPERS_LOCATION);
        int length = secondarySupers.readInt(HotSpotReplacementsUtil.metaspaceArrayLengthOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.METASPACE_ARRAY_LENGTH_LOCATION);
        for (int i = 0; i < length; ++i) {
            if (!BranchProbabilityNode.probability(0.4, t.equal(TypeCheckSnippetUtils.loadSecondarySupersElement(secondarySupers, i)))) continue;
            s.writeKlassPointer(HotSpotReplacementsUtil.secondarySuperCacheOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), t, HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
            counters.secondariesHit.inc();
            return true;
        }
        counters.secondariesMiss.inc();
        return false;
    }

    static Hints createHints(TypeCheckHints hints, MetaAccessProvider metaAccess, boolean positiveOnly, StructuredGraph graph) {
        ConstantNode[] hubs = new ConstantNode[hints.hints.length];
        boolean[] isPositive = new boolean[hints.hints.length];
        int index = 0;
        for (int i = 0; i < hubs.length; ++i) {
            if (positiveOnly && !hints.hints[i].positive) continue;
            hubs[index] = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), ((HotSpotResolvedObjectType)hints.hints[i].type).klass(), metaAccess, graph);
            isPositive[index] = hints.hints[i].positive;
            ++index;
        }
        if (positiveOnly && index != hubs.length) {
            assert (index < hubs.length);
            hubs = Arrays.copyOf(hubs, index);
            isPositive = Arrays.copyOf(isPositive, index);
        }
        return new Hints(hubs, isPositive);
    }

    static KlassPointer loadSecondarySupersElement(Word metaspaceArray, int index) {
        return KlassPointer.fromWord((Pointer)metaspaceArray.readWord(HotSpotReplacementsUtil.metaspaceArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG) + index * HotSpotReplacementsUtil.wordSize(), HotSpotReplacementsUtil.SECONDARY_SUPERS_ELEMENT_LOCATION));
    }

    public static class Hints {
        public final ConstantNode[] hubs;
        public final boolean[] isPositive;

        Hints(ConstantNode[] hints, boolean[] hintIsPositive) {
            this.hubs = hints;
            this.isPositive = hintIsPositive;
        }
    }

    static class Counters {
        final SnippetCounter hintsHit;
        final SnippetCounter hintsMiss;
        final SnippetCounter exactHit;
        final SnippetCounter exactMiss;
        final SnippetCounter isNull;
        final SnippetCounter cacheHit;
        final SnippetCounter secondariesHit;
        final SnippetCounter secondariesMiss;
        final SnippetCounter displayHit;
        final SnippetCounter displayMiss;
        final SnippetCounter equalsSecondary;

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group group = factory.createSnippetCounterGroup("TypeCheck");
            this.hintsHit = new SnippetCounter(group, "hintsHit", "hit a hint type");
            this.hintsMiss = new SnippetCounter(group, "hintsMiss", "missed a hint type");
            this.exactHit = new SnippetCounter(group, "exactHit", "exact type test succeeded");
            this.exactMiss = new SnippetCounter(group, "exactMiss", "exact type test failed");
            this.isNull = new SnippetCounter(group, "isNull", "object tested was null");
            this.cacheHit = new SnippetCounter(group, "cacheHit", "secondary type cache hit");
            this.secondariesHit = new SnippetCounter(group, "secondariesHit", "secondaries scan succeeded");
            this.secondariesMiss = new SnippetCounter(group, "secondariesMiss", "secondaries scan failed");
            this.displayHit = new SnippetCounter(group, "displayHit", "primary type test succeeded");
            this.displayMiss = new SnippetCounter(group, "displayMiss", "primary type test failed");
            this.equalsSecondary = new SnippetCounter(group, "T_equals_S", "object type was equal to secondary type");
        }
    }
}

