/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.replacements.nodes.IdentityHashCodeNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_16)
public class HotSpotIdentityHashCodeNode
extends IdentityHashCodeNode {
    public static final NodeClass<HotSpotIdentityHashCodeNode> TYPE = NodeClass.create(HotSpotIdentityHashCodeNode.class);

    public HotSpotIdentityHashCodeNode(ValueNode object, int bci) {
        super(TYPE, object, bci);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return HotSpotReplacementsUtil.MARK_WORD_LOCATION;
    }

    @Override
    protected int getIdentityHashCode(JavaConstant constant) {
        return ((HotSpotObjectConstant)constant).getIdentityHashCode();
    }
}

