/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ArrayRangeWrite;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.gc.CardTableBarrierSet;
import org.graalvm.compiler.nodes.gc.G1BarrierSet;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;

public class HotSpotPlatformConfigurationProvider
implements PlatformConfigurationProvider {
    private final BarrierSet barrierSet;
    private final boolean canVirtualizeLargeByteArrayAccess;

    public HotSpotPlatformConfigurationProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        this.barrierSet = this.createBarrierSet(config, metaAccess);
        this.canVirtualizeLargeByteArrayAccess = config.deoptimizationSupportLargeAccessByteArrayVirtualization;
    }

    @Override
    public boolean canVirtualizeLargeByteArrayAccess() {
        return this.canVirtualizeLargeByteArrayAccess;
    }

    @Override
    public BarrierSet getBarrierSet() {
        return this.barrierSet;
    }

    private BarrierSet createBarrierSet(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        final boolean useDeferredInitBarriers = config.useDeferredInitBarriers;
        ResolvedJavaType objectArrayType = metaAccess.lookupJavaType(Object[].class);
        if (config.useG1GC) {
            ResolvedJavaField referentField = HotSpotReplacementsUtil.referentField(metaAccess);
            return new G1BarrierSet(objectArrayType, referentField){

                @Override
                protected boolean writeRequiresPostBarrier(FixedAccessNode node, ValueNode writtenValue) {
                    if (!super.writeRequiresPostBarrier(node, writtenValue)) {
                        return false;
                    }
                    return !useDeferredInitBarriers || !HotSpotPlatformConfigurationProvider.this.isWriteToNewObject(node);
                }

                @Override
                protected boolean arrayRangeWriteRequiresPostBarrier(ArrayRangeWrite write) {
                    if (!super.arrayRangeWriteRequiresPostBarrier(write)) {
                        return false;
                    }
                    return !useDeferredInitBarriers || !HotSpotPlatformConfigurationProvider.this.isWriteToNewObject(write.asFixedWithNextNode(), write.getAddress().getBase());
                }
            };
        }
        return new CardTableBarrierSet(objectArrayType){

            @Override
            protected boolean writeRequiresBarrier(FixedAccessNode node, ValueNode writtenValue) {
                if (!super.writeRequiresBarrier(node, writtenValue)) {
                    return false;
                }
                return !useDeferredInitBarriers || !HotSpotPlatformConfigurationProvider.this.isWriteToNewObject(node);
            }

            @Override
            protected boolean arrayRangeWriteRequiresBarrier(ArrayRangeWrite write) {
                if (!super.arrayRangeWriteRequiresBarrier(write)) {
                    return false;
                }
                return !useDeferredInitBarriers || !HotSpotPlatformConfigurationProvider.this.isWriteToNewObject(write.asFixedWithNextNode(), write.getAddress().getBase());
            }
        };
    }

    protected boolean isWriteToNewObject(FixedAccessNode node) {
        if (!node.getLocationIdentity().isInit()) {
            return false;
        }
        return this.isWriteToNewObject(node, node.getAddress().getBase());
    }

    protected boolean isWriteToNewObject(FixedWithNextNode node, ValueNode base) {
        if (base instanceof AbstractNewObjectNode) {
            for (Node pred = node.predecessor(); pred != null; pred = pred.predecessor()) {
                if (pred == base) {
                    node.getDebug().log(2, "Deferred barrier for %s with base %s", (Object)node, (Object)base);
                    return true;
                }
                if (!(pred instanceof AbstractNewObjectNode)) continue;
                node.getDebug().log(2, "Disallowed deferred barrier for %s because %s was last allocation instead of %s", (Object)node, (Object)pred, (Object)base);
                return false;
            }
        }
        node.getDebug().log(2, "Unable to find allocation for deferred barrier for %s with base %s", (Object)node, (Object)base);
        return false;
    }
}

