/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.StackSlot;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;

public class HotSpotLIRGenerationResult
extends LIRGenerationResult {
    private StackSlot deoptimizationRescueSlot;
    protected final Object stub;
    private final boolean requiresReservedStackAccessCheck;
    private int maxInterpreterFrameSize;
    private EconomicMap<LIRFrameState, StandardOp.SaveRegistersOp> calleeSaveInfo = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);

    public HotSpotLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, RegisterAllocationConfig registerAllocationConfig, CallingConvention callingConvention, Object stub, boolean requiresReservedStackAccessCheck) {
        super(compilationId, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
        this.stub = stub;
        this.requiresReservedStackAccessCheck = requiresReservedStackAccessCheck;
    }

    public EconomicMap<LIRFrameState, StandardOp.SaveRegistersOp> getCalleeSaveInfo() {
        return this.calleeSaveInfo;
    }

    public Stub getStub() {
        return (Stub)this.stub;
    }

    public StackSlot getDeoptimizationRescueSlot() {
        return this.deoptimizationRescueSlot;
    }

    public final void setDeoptimizationRescueSlot(StackSlot stackSlot) {
        this.deoptimizationRescueSlot = stackSlot;
    }

    public void setMaxInterpreterFrameSize(int maxInterpreterFrameSize) {
        this.maxInterpreterFrameSize = maxInterpreterFrameSize;
    }

    public int getMaxInterpreterFrameSize() {
        return this.maxInterpreterFrameSize;
    }

    public boolean requiresReservedStackAccessCheck() {
        return this.requiresReservedStackAccessCheck;
    }
}

