/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

final class BigEndianUnsafeArrayTypeWriter
extends UnsafeArrayTypeWriter {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

    BigEndianUnsafeArrayTypeWriter() {
    }

    @Override
    protected void putS2(long value, UnsafeArrayTypeWriter.Chunk chunk, long offset) {
        assert (TypeConversion.isS2(value));
        UNSAFE.putByte(chunk.data, offset + 0L, (byte)(value >> 8));
        UNSAFE.putByte(chunk.data, offset + 1L, (byte)(value >> 0));
    }

    @Override
    protected void putS4(long value, UnsafeArrayTypeWriter.Chunk chunk, long offset) {
        assert (TypeConversion.isS4(value));
        UNSAFE.putByte(chunk.data, offset + 0L, (byte)(value >> 24));
        UNSAFE.putByte(chunk.data, offset + 1L, (byte)(value >> 16));
        UNSAFE.putByte(chunk.data, offset + 2L, (byte)(value >> 8));
        UNSAFE.putByte(chunk.data, offset + 3L, (byte)(value >> 0));
    }

    @Override
    protected void putS8(long value, UnsafeArrayTypeWriter.Chunk chunk, long offset) {
        UNSAFE.putByte(chunk.data, offset + 0L, (byte)(value >> 56));
        UNSAFE.putByte(chunk.data, offset + 1L, (byte)(value >> 48));
        UNSAFE.putByte(chunk.data, offset + 2L, (byte)(value >> 40));
        UNSAFE.putByte(chunk.data, offset + 3L, (byte)(value >> 32));
        UNSAFE.putByte(chunk.data, offset + 4L, (byte)(value >> 24));
        UNSAFE.putByte(chunk.data, offset + 5L, (byte)(value >> 16));
        UNSAFE.putByte(chunk.data, offset + 6L, (byte)(value >> 8));
        UNSAFE.putByte(chunk.data, offset + 7L, (byte)(value >> 0));
    }
}

