/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.Loop;

public class CFGVerifier {
    public static <T extends AbstractBlockBase<T>, C extends AbstractControlFlowGraph<T>> boolean verify(C cfg) {
        for (AbstractBlockBase block : cfg.getBlocks()) {
            assert (block.getId() >= 0);
            assert (cfg.getBlocks()[block.getId()] == block);
            for (AbstractBlockBase pred : block.getPredecessors()) {
                assert (Arrays.asList(pred.getSuccessors()).contains(block));
                assert (pred.getId() < block.getId() || pred.isLoopEnd());
            }
            for (AbstractBlockBase sux : block.getSuccessors()) {
                assert (Arrays.asList(sux.getPredecessors()).contains(block));
                assert (sux.getId() > block.getId() || sux.isLoopHeader());
            }
            if (block.getDominator() != null) {
                T domChild;
                assert (((AbstractBlockBase)block.getDominator()).getId() < block.getId());
                for (domChild = ((AbstractBlockBase)block.getDominator()).getFirstDominated(); domChild != null && domChild != block; domChild = ((AbstractBlockBase)domChild).getDominatedSibling()) {
                }
                assert (domChild != null) : "dominators must contain block";
            }
            for (Object dominated = block.getFirstDominated(); dominated != null; dominated = ((AbstractBlockBase)dominated).getDominatedSibling()) {
                assert (((AbstractBlockBase)dominated).getId() > block.getId());
                assert (((AbstractBlockBase)dominated).getDominator() == block);
            }
            Object postDominatorBlock = block.getPostdominator();
            if (postDominatorBlock != null) {
                assert (block.getSuccessorCount() > 0) : "block has post-dominator block, but no successors";
                BlockMap<Boolean> visitedBlocks = new BlockMap<Boolean>(cfg);
                visitedBlocks.put(block, true);
                ArrayDeque<AbstractBlockBase> stack = new ArrayDeque<AbstractBlockBase>();
                for (AbstractBlockBase sux : block.getSuccessors()) {
                    visitedBlocks.put(sux, true);
                    stack.push(sux);
                }
                while (stack.size() > 0) {
                    AbstractBlockBase tos = (AbstractBlockBase)stack.pop();
                    assert (tos.getId() <= ((AbstractBlockBase)postDominatorBlock).getId());
                    if (tos == postDominatorBlock) continue;
                    assert (tos.getSuccessorCount() > 0) : "no path found";
                    for (AbstractBlockBase sux : tos.getSuccessors()) {
                        if (visitedBlocks.get(sux) != null) continue;
                        visitedBlocks.put(sux, true);
                        stack.push(sux);
                    }
                }
            }
            assert (cfg.getLoops() == null || !block.isLoopHeader() || block.getLoop().getHeader() == block);
        }
        if (cfg.getLoops() != null) {
            for (Loop loop : cfg.getLoops()) {
                Loop blockLoop;
                assert (((AbstractBlockBase)loop.getHeader()).isLoopHeader());
                for (AbstractBlockBase block : loop.getBlocks()) {
                    assert (block.getId() >= ((AbstractBlockBase)loop.getHeader()).getId());
                    for (blockLoop = block.getLoop(); blockLoop != loop; blockLoop = blockLoop.getParent()) {
                        assert (blockLoop != null);
                    }
                    if (block.isLoopHeader() && block.getLoop() == loop) continue;
                    for (AbstractBlockBase pred : block.getPredecessors()) {
                        if (loop.getBlocks().contains(pred)) continue;
                        assert (false) : "Loop " + loop + " does not contain " + pred;
                        return false;
                    }
                }
                for (AbstractBlockBase block : loop.getLoopExits()) {
                    assert (block.getId() >= ((AbstractBlockBase)loop.getHeader()).getId());
                    for (blockLoop = block.getLoop(); blockLoop != null; blockLoop = blockLoop.getParent()) {
                        assert (blockLoop != loop);
                    }
                }
            }
        }
        return true;
    }
}

