/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core;

import jdk.vm.ci.services.Services;

public class GraalServiceThread
extends Thread {
    private final Runnable runnable;

    public GraalServiceThread(String name, Runnable runnable) {
        super(name);
        this.runnable = runnable;
    }

    @Override
    public final void run() {
        try {
            this.beforeRun();
        }
        catch (InternalError t) {
            this.onAttachError(t);
            return;
        }
        try {
            this.runnable.run();
        }
        finally {
            this.afterRun();
        }
    }

    protected void onAttachError(InternalError error) {
        if (Boolean.parseBoolean(Services.getSavedProperties().getOrDefault("GraalServiceThread.verbose", "false"))) {
            error.printStackTrace();
        }
    }

    private void afterRun() {
    }

    private void beforeRun() {
    }
}

