/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.hotspot.JFR;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilerProfiler;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=CompilerProfiler.class)
public final class JFRCompilerProfiler
implements CompilerProfiler {
    @Override
    public long getTicks() {
        return JFR.Ticks.now();
    }

    @Override
    public void notifyCompilerPhaseEvent(int compileId, long startTime, String name, int nestingLevel) {
        JFR.CompilerPhaseEvent.write((long)startTime, (String)name, (int)compileId, (int)nestingLevel);
    }

    @Override
    public void notifyCompilerInlingEvent(int compileId, ResolvedJavaMethod caller, ResolvedJavaMethod callee, boolean succeeded, String message, int bci) {
        JFR.CompilerInliningEvent.write((int)compileId, (ResolvedJavaMethod)caller, (ResolvedJavaMethod)callee, (boolean)succeeded, (String)message, (int)bci);
    }
}

