/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.NameBound;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodConfig;
import org.glassfish.jersey.server.model.internal.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.internal.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

public class ResourceMethodInvoker
implements Endpoint,
ResourceInfo {
    private final Provider<RoutingContext> routingContextProvider;
    private final Provider<AsyncContext> asyncContextProvider;
    private final Provider<RespondingContext> respondingContextProvider;
    private final ResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;
    private final Method resourceMethod;
    private final Class<?> resourceClass;
    private final List<RankedProvider<ContainerRequestFilter>> requestFilters = Lists.newArrayList();
    private final List<RankedProvider<ContainerResponseFilter>> responseFilters = Lists.newArrayList();
    private final Iterable<ReaderInterceptor> readerInterceptors;
    private final Iterable<WriterInterceptor> writerInterceptors;

    private ResourceMethodInvoker(Provider<RoutingContext> routingContextProvider, Provider<AsyncContext> asyncContextProvider, Provider<RespondingContext> respondingContextProvider, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, ResourceMethod method, ProcessingProviders processingProviders, ServiceLocator locator, Configuration globalConfig) {
        this.routingContextProvider = routingContextProvider;
        this.asyncContextProvider = asyncContextProvider;
        this.respondingContextProvider = respondingContextProvider;
        this.method = method;
        Invocable invocable = method.getInvocable();
        this.dispatcher = dispatcherProvider.create(invocable, invocationHandlerProvider.create(invocable));
        this.resourceMethod = invocable.getHandlingMethod();
        this.resourceClass = invocable.getHandler().getHandlerClass();
        final ResourceMethodConfig config = new ResourceMethodConfig(globalConfig.getProperties());
        for (DynamicFeature dynamicFeature : processingProviders.getDynamicFeatures()) {
            dynamicFeature.configure((ResourceInfo)this, (FeatureContext)config);
        }
        ComponentBag componentBag = config.getComponentBag();
        ArrayList providers = Lists.newArrayList((Iterable)componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS));
        Set providerClasses = componentBag.getClasses(ComponentBag.EXCLUDE_META_PROVIDERS);
        if (!providerClasses.isEmpty()) {
            locator = Injections.createLocator((ServiceLocator)locator, (Binder[])new Binder[]{new AbstractBinder(){

                protected void configure() {
                    this.bind((Object)config).to(Configuration.class);
                }
            }});
            for (Class providerClass : providerClasses) {
                providers.add(locator.create(providerClass));
            }
        }
        LinkedList _readerInterceptors = Lists.newLinkedList();
        LinkedList _writerInterceptors = Lists.newLinkedList();
        LinkedList _requestFilters = Lists.newLinkedList();
        LinkedList _responseFilters = Lists.newLinkedList();
        for (Object provider : providers) {
            ContractProvider model = componentBag.getModel(provider.getClass());
            Set contracts = model.getContracts();
            if (contracts.contains(WriterInterceptor.class)) {
                _writerInterceptors.add(new RankedProvider((Object)((WriterInterceptor)provider), model.getPriority(WriterInterceptor.class)));
            }
            if (contracts.contains(ReaderInterceptor.class)) {
                _readerInterceptors.add(new RankedProvider((Object)((ReaderInterceptor)provider), model.getPriority(ReaderInterceptor.class)));
            }
            if (contracts.contains(ContainerRequestFilter.class)) {
                _requestFilters.add(new RankedProvider((Object)((ContainerRequestFilter)provider), model.getPriority(ContainerRequestFilter.class)));
            }
            if (!contracts.contains(ContainerResponseFilter.class)) continue;
            _responseFilters.add(new RankedProvider((Object)((ContainerResponseFilter)provider), model.getPriority(ContainerResponseFilter.class)));
        }
        _readerInterceptors.addAll(Lists.newLinkedList(processingProviders.getGlobalReaderInterceptors()));
        _writerInterceptors.addAll(Lists.newLinkedList(processingProviders.getGlobalWriterInterceptors()));
        if (this.resourceMethod != null) {
            this.addNameBoundFiltersAndInterceptors(processingProviders, _requestFilters, _responseFilters, _readerInterceptors, _writerInterceptors, method);
        }
        this.readerInterceptors = Collections.unmodifiableList(Lists.newArrayList((Iterable)Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{_readerInterceptors})));
        this.writerInterceptors = Collections.unmodifiableList(Lists.newArrayList((Iterable)Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{_writerInterceptors})));
        this.requestFilters.addAll(_requestFilters);
        this.responseFilters.addAll(_responseFilters);
    }

    private <T> void addNameBoundProviders(Collection<RankedProvider<T>> targetCollection, NameBound nameBound, MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> nameBoundProviders, MultivaluedMap<RankedProvider<T>, Class<? extends Annotation>> nameBoundProvidersInverse) {
        MultivaluedHashMap foundBindingsMap = new MultivaluedHashMap();
        for (Class nameBinding : nameBound.getNameBindings()) {
            Iterable providers = (Iterable)nameBoundProviders.get((Object)nameBinding);
            if (providers == null) continue;
            for (RankedProvider provider : providers) {
                foundBindingsMap.add((Object)provider, (Object)nameBinding);
            }
        }
        for (Map.Entry entry : foundBindingsMap.entrySet()) {
            RankedProvider provider = (RankedProvider)entry.getKey();
            List foundBindings = (List)entry.getValue();
            List providerBindings = (List)nameBoundProvidersInverse.get((Object)provider);
            if (foundBindings.size() != providerBindings.size()) continue;
            targetCollection.add(provider);
        }
    }

    private void addNameBoundFiltersAndInterceptors(ProcessingProviders processingProviders, Collection<RankedProvider<ContainerRequestFilter>> targetRequestFilters, Collection<RankedProvider<ContainerResponseFilter>> targetResponseFilters, Collection<RankedProvider<ReaderInterceptor>> targetReaderInterceptors, Collection<RankedProvider<WriterInterceptor>> targetWriterInterceptors, NameBound nameBound) {
        this.addNameBoundProviders(targetRequestFilters, nameBound, processingProviders.getNameBoundRequestFilters(), processingProviders.getNameBoundRequestFiltersInverse());
        this.addNameBoundProviders(targetResponseFilters, nameBound, processingProviders.getNameBoundResponseFilters(), processingProviders.getNameBoundResponseFiltersInverse());
        this.addNameBoundProviders(targetReaderInterceptors, nameBound, processingProviders.getNameBoundReaderInterceptors(), processingProviders.getNameBoundReaderInterceptorsInverse());
        this.addNameBoundProviders(targetWriterInterceptors, nameBound, processingProviders.getNameBoundWriterInterceptors(), processingProviders.getNameBoundWriterInterceptorsInverse());
    }

    public Method getResourceMethod() {
        return this.resourceMethod;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ContainerResponse apply(final ContainerRequest requestContext) {
        final Object resource = ((RoutingContext)this.routingContextProvider.get()).peekMatchedResource();
        if (this.method.isSuspendDeclared() || this.method.isManagedAsyncDeclared()) {
            ((AsyncContext)this.asyncContextProvider.get()).suspend();
        }
        if (this.method.isManagedAsyncDeclared()) {
            ((AsyncContext)this.asyncContextProvider.get()).invokeManaged(new Producer<Response>(){

                public Response call() {
                    Response response = ResourceMethodInvoker.this.invoke(requestContext, resource);
                    if (ResourceMethodInvoker.this.method.isSuspendDeclared()) {
                        return null;
                    }
                    return response;
                }
            });
            return null;
        }
        return new ContainerResponse(requestContext, this.invoke(requestContext, resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response invoke(ContainerRequest requestContext, Object resource) {
        Response jaxrsResponse;
        requestContext.triggerEvent(RequestEvent.Type.RESOURCE_METHOD_START);
        try {
            jaxrsResponse = this.dispatcher.dispatch(resource, requestContext);
        }
        finally {
            requestContext.triggerEvent(RequestEvent.Type.RESOURCE_METHOD_FINISHED);
        }
        if (jaxrsResponse == null) {
            jaxrsResponse = Response.noContent().build();
        }
        ((RespondingContext)this.respondingContextProvider.get()).push(new Function<ContainerResponse, ContainerResponse>(){

            public ContainerResponse apply(ContainerResponse response) {
                Type invocableType;
                if (response == null) {
                    return response;
                }
                Invocable invocable = ResourceMethodInvoker.this.method.getInvocable();
                Annotation[] entityAnn = response.getEntityAnnotations();
                Annotation[] methodAnn = invocable.getHandlingMethod().getDeclaredAnnotations();
                if (methodAnn.length > 0) {
                    if (entityAnn.length == 0) {
                        response.setEntityAnnotations(methodAnn);
                    } else {
                        Annotation[] mergedAnn = Arrays.copyOf(methodAnn, methodAnn.length + entityAnn.length);
                        System.arraycopy(entityAnn, 0, mergedAnn, methodAnn.length, entityAnn.length);
                        response.setEntityAnnotations(mergedAnn);
                    }
                }
                if (!(!response.hasEntity() || response.getEntityType() instanceof ParameterizedType || (invocableType = invocable.getResponseType()) == null || Void.TYPE == invocableType || Void.class == invocableType || invocableType instanceof Class && Response.class.isAssignableFrom((Class)invocableType))) {
                    response.setEntityType(invocableType);
                }
                return response;
            }
        });
        return jaxrsResponse;
    }

    public Iterable<RankedProvider<ContainerRequestFilter>> getRequestFilters() {
        return this.requestFilters;
    }

    public Iterable<RankedProvider<ContainerResponseFilter>> getResponseFilters() {
        return this.responseFilters;
    }

    public Iterable<WriterInterceptor> getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Iterable<ReaderInterceptor> getReaderInterceptors() {
        return this.readerInterceptors;
    }

    public String toString() {
        return this.method.getInvocable().getHandlingMethod().toString();
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> routingContextProvider;
        @Inject
        private Provider<AsyncContext> asyncContextProvider;
        @Inject
        private Provider<RespondingContext> respondingContextProvider;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;
        @Inject
        private ServiceLocator locator;
        @Inject
        private Configuration globalConfig;

        public ResourceMethodInvoker build(ResourceMethod method, ProcessingProviders processingProviders) {
            return new ResourceMethodInvoker(this.routingContextProvider, this.asyncContextProvider, this.respondingContextProvider, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method, processingProviders, this.locator, this.globalConfig);
        }
    }
}

