/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
class DelegatedInjectionValueFactoryProvider
implements ValueFactoryProvider {
    private final ContextInjectionResolver resolver;

    @Inject
    public DelegatedInjectionValueFactoryProvider(ServiceLocator locator) {
        ContextInjectionResolver result = null;
        for (InjectionResolver r : Providers.getProviders((ServiceLocator)locator, InjectionResolver.class)) {
            if (!ContextInjectionResolver.class.isInstance(r)) continue;
            result = (ContextInjectionResolver)ContextInjectionResolver.class.cast(r);
            break;
        }
        this.resolver = result;
    }

    @Override
    public Factory<?> getValueFactory(final Parameter parameter) {
        Parameter.Source paramSource = parameter.getSource();
        if (paramSource == Parameter.Source.CONTEXT) {
            return new Factory<Object>(){

                public Object provide() {
                    return DelegatedInjectionValueFactoryProvider.this.resolver.resolve(DelegatedInjectionValueFactoryProvider.getInjectee(parameter), null);
                }

                public void dispose(Object instance) {
                }
            };
        }
        return null;
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.LOW;
    }

    private static Injectee getInjectee(final Parameter parameter) {
        return new InjecteeImpl(){
            {
                this.setRequiredType(parameter.getType());
                this.setRequiredQualifiers(Collections.emptySet());
            }

            public Class<?> getInjecteeClass() {
                return parameter.getRawType();
            }
        };
    }
}

