/*
 * Decompiled with CFR 0.152.
 */
package fj.data.hamt;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.Show;
import fj.data.List;
import fj.data.Option;
import fj.data.Seq;
import fj.data.Stream;
import fj.data.hamt.BitSet;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$1;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$10;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$11;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$12;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$13;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$14;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$15;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$16;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$2;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$3;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$4;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$5;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$6;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$7;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$8;
import fj.data.hamt.HashArrayMappedTrie$$Lambda$9;
import fj.data.hamt.Node;

public final class HashArrayMappedTrie<K, V> {
    private final Seq<Node<K, V>> seq;
    private final BitSet bitSet;
    private final Hash<K> hash;
    private final Equal<K> equal;
    public static final int BITS_IN_INDEX = 5;
    public static final int SIZE = (int)StrictMath.pow(2.0, 5.0);
    public static final int MIN_INDEX = 0;
    public static final int MAX_INDEX = SIZE - 1;

    private HashArrayMappedTrie(BitSet bs, Seq<Node<K, V>> s, Equal<K> e, Hash<K> h) {
        this.bitSet = bs;
        this.seq = s;
        this.hash = h;
        this.equal = e;
    }

    public static <K, V> HashArrayMappedTrie<K, V> empty(Equal<K> e, Hash<K> h) {
        return new HashArrayMappedTrie<K, V>(BitSet.empty(), Seq.<Node<K, V>>empty(), e, h);
    }

    public static <V> HashArrayMappedTrie<Integer, V> emptyKeyInteger() {
        return HashArrayMappedTrie.empty(Equal.intEqual, Hash.intHash);
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    private static <K, V> HashArrayMappedTrie<K, V> hamt(BitSet bs, Seq<Node<K, V>> s, Equal<K> e, Hash<K> h) {
        return new HashArrayMappedTrie<K, V>(bs, s, e, h);
    }

    public Option<V> find(K k) {
        return this.find(k, 0, 5);
    }

    public Option<V> find(K k, int lowIndex, int highIndex) {
        BitSet bs1 = BitSet.longBitSet(this.hash.hash(k)).range(lowIndex, highIndex);
        int i = (int)bs1.longValue();
        boolean b = this.bitSet.isSet(i);
        int index = this.bitSet.bitsToRight(i);
        if (!b) {
            return Option.none();
        }
        Node<K, V> oldNode = this.seq.index(index);
        return (Option)oldNode.match(HashArrayMappedTrie$$Lambda$1.lambdaFactory$(this, k), HashArrayMappedTrie$$Lambda$2.lambdaFactory$(k, lowIndex, highIndex));
    }

    public HashArrayMappedTrie<K, V> set(K k, V v) {
        return this.set(k, v, 0, 5);
    }

    public HashArrayMappedTrie<K, V> set(List<P2<K, V>> list) {
        return list.foldLeft(HashArrayMappedTrie$$Lambda$3.lambdaFactory$(), this);
    }

    private HashArrayMappedTrie<K, V> set(K k, V v, int lowIndex, int highIndex) {
        BitSet bs1 = BitSet.longBitSet(this.hash.hash(k)).range(lowIndex, highIndex);
        int i = (int)bs1.longValue();
        boolean b = this.bitSet.isSet(i);
        int index = this.bitSet.bitsToRight(i);
        if (!b) {
            Node<K, V> sn1 = Node.p2Node(P.p(k, v));
            return HashArrayMappedTrie.hamt(this.bitSet.set(i), this.seq.insert(index, sn1), this.equal, this.hash);
        }
        Node<K, V> oldNode = this.seq.index(index);
        Node newNode = (Node)oldNode.match(HashArrayMappedTrie$$Lambda$4.lambdaFactory$(this, k, v, lowIndex, highIndex), HashArrayMappedTrie$$Lambda$5.lambdaFactory$(k, v, lowIndex, highIndex));
        return HashArrayMappedTrie.hamt(this.bitSet, this.seq.update(index, newNode), this.equal, this.hash);
    }

    public Stream<P2<K, V>> toStream() {
        return this.seq.toStream().bind(HashArrayMappedTrie$$Lambda$6.lambdaFactory$());
    }

    public List<P2<K, V>> toList(Ord<K> o) {
        return this.toStream().sort(Ord.p2Ord1(o)).toList();
    }

    public List<P2<K, V>> toList() {
        return this.toStream().toList();
    }

    public String toString() {
        return Show.hamtShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    public <B> B foldLeftOnNode(F2<B, Node<K, V>, B> f, B b) {
        return this.seq.foldLeft(f, b);
    }

    public <B> B foldLeft(F2<B, P2<K, V>, B> f, F2<B, HashArrayMappedTrie<K, V>, B> g, B b) {
        return this.foldLeftOnNode(HashArrayMappedTrie$$Lambda$7.lambdaFactory$(f, g), b);
    }

    public <B> B foldLeft(F2<B, P2<K, V>, B> f, B b) {
        return this.foldLeftOnNode(HashArrayMappedTrie$$Lambda$8.lambdaFactory$(f), b);
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public Seq<Node<K, V>> getSeq() {
        return this.seq;
    }

    public int length() {
        return this.seq.foldLeft(HashArrayMappedTrie$$Lambda$9.lambdaFactory$(), 0);
    }

    static /* synthetic */ Integer lambda$length$14(Integer acc, Node node) {
        return (Integer)node.match(HashArrayMappedTrie$$Lambda$10.lambdaFactory$(acc), HashArrayMappedTrie$$Lambda$11.lambdaFactory$(acc));
    }

    static /* synthetic */ Integer lambda$null$13(Integer acc, HashArrayMappedTrie hamt) {
        return acc + hamt.length();
    }

    static /* synthetic */ Integer lambda$null$12(Integer acc, P2 p2) {
        return acc + 1;
    }

    static /* synthetic */ Object lambda$foldLeft$11(F2 f, Object acc, Node n) {
        return n.match(HashArrayMappedTrie$$Lambda$12.lambdaFactory$(f, acc), HashArrayMappedTrie$$Lambda$13.lambdaFactory$(f, acc));
    }

    static /* synthetic */ Object lambda$null$10(F2 f, Object acc, HashArrayMappedTrie h) {
        return h.foldLeft(f, acc);
    }

    static /* synthetic */ Object lambda$null$9(F2 f, Object acc, P2 p) {
        return f.f(acc, p);
    }

    static /* synthetic */ Object lambda$foldLeft$8(F2 f, F2 g, Object acc, Node n) {
        return n.match(HashArrayMappedTrie$$Lambda$14.lambdaFactory$(f, acc), HashArrayMappedTrie$$Lambda$15.lambdaFactory$(g, acc));
    }

    static /* synthetic */ Object lambda$null$7(F2 g, Object acc, HashArrayMappedTrie h) {
        return g.f(acc, h);
    }

    static /* synthetic */ Object lambda$null$6(F2 f, Object acc, P2 p) {
        return f.f(acc, p);
    }

    static /* synthetic */ Node lambda$set$5(Object k, Object v, int lowIndex, int highIndex, HashArrayMappedTrie hamt) {
        return Node.hamtNode(hamt.set(k, v, lowIndex + 5, highIndex + 5));
    }

    static /* synthetic */ Node lambda$set$4(HashArrayMappedTrie this_, Object k, Object v, int lowIndex, int highIndex, P2 n) {
        if (this_.equal.eq(n._1(), k)) {
            return Node.p2Node(P.p(k, v));
        }
        HashArrayMappedTrie e = HashArrayMappedTrie.empty(this_.equal, this_.hash);
        HashArrayMappedTrie h1 = super.set(n._1(), n._2(), lowIndex + 5, highIndex + 5);
        HashArrayMappedTrie<Object, Object> h2 = super.set(k, v, lowIndex + 5, highIndex + 5);
        return Node.hamtNode(h2);
    }

    static /* synthetic */ F lambda$set$3(HashArrayMappedTrie h) {
        return HashArrayMappedTrie$$Lambda$16.lambdaFactory$(h);
    }

    static /* synthetic */ HashArrayMappedTrie lambda$null$2(HashArrayMappedTrie h, P2 p) {
        return h.set(p._1(), p._2());
    }

    static /* synthetic */ Option lambda$find$1(Object k, int lowIndex, int highIndex, HashArrayMappedTrie hamt) {
        return hamt.find(k, lowIndex + 5, highIndex + 5);
    }

    static /* synthetic */ Option lambda$find$0(HashArrayMappedTrie this_, Object k, P2 n) {
        return this_.equal.eq(n._1(), k) ? Option.some(n._2()) : Option.none();
    }
}

