/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.F2;
import fj.F2Functions;
import fj.Function;
import fj.Monoid;
import fj.P;
import fj.P2;
import fj.P3;
import fj.data.Option;
import fj.data.Stream;
import fj.data.fingertrees.Deep;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.FingerTree$$Lambda$1;
import fj.data.fingertrees.FingerTree$$Lambda$2;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Single;

public abstract class FingerTree<V, A> {
    private final Measured<V, A> m;

    public abstract <B> B foldRight(F<A, F<B, B>> var1, B var2);

    public final <B> B foldRight(F2<A, B, B> f, B z) {
        return this.foldRight(F2Functions.curry(f), z);
    }

    public abstract A reduceRight(F<A, F<A, A>> var1);

    public abstract <B> B foldLeft(F<B, F<A, B>> var1, B var2);

    public final <B> B foldLeft(F2<B, A, B> f, B z) {
        return this.foldLeft(F2Functions.curry(f), z);
    }

    public abstract A reduceLeft(F<A, F<A, A>> var1);

    public abstract <B> FingerTree<V, B> map(F<A, B> var1, Measured<V, B> var2);

    public final <B> FingerTree<V, A> filter(F<A, Boolean> f) {
        Empty<V, A> tree = new Empty<V, A>(this.m);
        return this.foldLeft(FingerTree$$Lambda$1.lambdaFactory$(f), tree);
    }

    public abstract V measure();

    public final boolean isEmpty() {
        return this instanceof Empty;
    }

    public final Measured<V, A> measured() {
        return this.m;
    }

    public abstract <B> B match(F<Empty<V, A>, B> var1, F<Single<V, A>, B> var2, F<Deep<V, A>, B> var3);

    FingerTree(Measured<V, A> m) {
        this.m = m;
    }

    public static <V, A> Measured<V, A> measured(Monoid<V> monoid, F<A, V> measure) {
        return Measured.measured(monoid, measure);
    }

    public static <V, A> MakeTree<V, A> mkTree(Measured<V, A> m) {
        return new MakeTree<V, A>(m);
    }

    public abstract FingerTree<V, A> cons(A var1);

    public abstract FingerTree<V, A> snoc(A var1);

    public abstract A head();

    public final Option<A> headOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public final <B> B uncons(B nil, F2<A, FingerTree<V, A>, B> cons) {
        return this.isEmpty() ? nil : cons.f(this.head(), this.tail());
    }

    public abstract A last();

    public abstract FingerTree<V, A> tail();

    public abstract FingerTree<V, A> init();

    public abstract FingerTree<V, A> append(FingerTree<V, A> var1);

    public final P2<FingerTree<V, A>, FingerTree<V, A>> split(F<V, Boolean> predicate) {
        if (!this.isEmpty() && predicate.f(this.measure()).booleanValue()) {
            P3<FingerTree<V, A>, A, FingerTree<V, A>> lxr = this.split1(predicate);
            return P.p(lxr._1(), lxr._3().cons(lxr._2()));
        }
        return P.p(this, FingerTree.mkTree(this.m).empty());
    }

    public final P3<FingerTree<V, A>, A, FingerTree<V, A>> split1(F<V, Boolean> predicate) {
        return this.split1(predicate, this.measured().zero());
    }

    abstract P3<FingerTree<V, A>, A, FingerTree<V, A>> split1(F<V, Boolean> var1, V var2);

    public abstract P2<Integer, A> lookup(F<V, Integer> var1, int var2);

    public abstract int length();

    public static <A> FingerTree<Integer, A> emptyIntAddition() {
        return FingerTree.empty(Monoid.intAdditionMonoid, Function.constant(1));
    }

    public static <V, A> FingerTree<V, A> empty(Monoid<V> m, F<A, V> f) {
        return FingerTree.mkTree(FingerTree.measured(m, f)).empty();
    }

    public static <A> FingerTree<Integer, P2<Integer, A>> emptyIntMax() {
        return FingerTree.empty(Monoid.intMaxMonoid, FingerTree$$Lambda$2.lambdaFactory$());
    }

    public abstract Stream<A> toStream();

    static /* synthetic */ Integer lambda$emptyIntMax$1(P2 p) {
        return (Integer)p._1();
    }

    static /* synthetic */ FingerTree lambda$filter$0(F f, FingerTree acc, Object a) {
        return (Boolean)f.f(a) != false ? acc.snoc(a) : acc;
    }
}

