/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F1Functions;
import fj.Function;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Array;
import fj.data.IterableW;
import fj.data.List;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import fj.data.TreeMap$$Lambda$1;
import fj.data.TreeMap$$Lambda$10;
import fj.data.TreeMap$$Lambda$11;
import fj.data.TreeMap$$Lambda$12;
import fj.data.TreeMap$$Lambda$13;
import fj.data.TreeMap$$Lambda$14;
import fj.data.TreeMap$$Lambda$15;
import fj.data.TreeMap$$Lambda$16;
import fj.data.TreeMap$$Lambda$17;
import fj.data.TreeMap$$Lambda$18;
import fj.data.TreeMap$$Lambda$19;
import fj.data.TreeMap$$Lambda$2;
import fj.data.TreeMap$$Lambda$20;
import fj.data.TreeMap$$Lambda$3;
import fj.data.TreeMap$$Lambda$4;
import fj.data.TreeMap$$Lambda$5;
import fj.data.TreeMap$$Lambda$6;
import fj.data.TreeMap$$Lambda$7;
import fj.data.TreeMap$$Lambda$8;
import fj.data.TreeMap$$Lambda$9;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public final class TreeMap<K, V>
implements Iterable<P2<K, V>> {
    private final Set<P2<K, Option<V>>> tree;

    private TreeMap(Set<P2<K, Option<V>>> tree) {
        this.tree = tree;
    }

    private static <K, V> Ord<P2<K, V>> ord(Ord<K> keyOrd) {
        return keyOrd.contramap(P2.__1());
    }

    public static <K, V> TreeMap<K, V> empty(Ord<K> keyOrd) {
        return new TreeMap<K, V>(Set.empty(TreeMap.ord(keyOrd)));
    }

    public boolean equals(Object other) {
        return Equal.equals0(TreeMap.class, this, other, TreeMap$$Lambda$1.lambdaFactory$());
    }

    public int hashCode() {
        return Hash.treeMapHash(Hash.anyHash(), Hash.anyHash()).hash(this);
    }

    public String toString() {
        return Show.treeMapShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> treeMap(Ord<K> keyOrd, P2<K, V> ... p2s) {
        return TreeMap.arrayTreeMap(keyOrd, p2s);
    }

    @Deprecated
    public static <K, V> TreeMap<K, V> treeMap(Ord<K> keyOrd, List<P2<K, V>> list) {
        return TreeMap.iterableTreeMap(keyOrd, list);
    }

    public static <K, V> TreeMap<K, V> iterableTreeMap(Ord<K> keyOrd, Iterable<P2<K, V>> it) {
        TreeMap<K, V> tm = TreeMap.empty(keyOrd);
        for (P2<K, V> p2 : it) {
            tm = tm.set(p2._1(), p2._2());
        }
        return tm;
    }

    public static <K, V> TreeMap<K, V> iteratorTreeMap(Ord<K> keyOrd, Iterator<P2<K, V>> it) {
        return TreeMap.iterableTreeMap(keyOrd, TreeMap$$Lambda$2.lambdaFactory$(it));
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> arrayTreeMap(Ord<K> keyOrd, P2<K, V> ... ps) {
        return TreeMap.iterableTreeMap(keyOrd, Array.array(ps));
    }

    public Option<V> get(K k) {
        return this.tree.lookup(P.p(k, Option.none())).bind(TreeMap$$Lambda$3.lambdaFactory$());
    }

    public TreeMap<K, V> set(K k, V v) {
        return new TreeMap<K, V>(this.tree.insert(P.p(k, Option.some(v))));
    }

    public TreeMap<K, V> delete(K k) {
        return new TreeMap<K, V>(this.tree.delete(P.p(k, Option.none())));
    }

    public int size() {
        return this.tree.size();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public List<V> values() {
        return List.iterableList(IterableW.join(this.tree.toList().map(Function.compose(IterableW.wrap(), P2.__2()))));
    }

    public List<K> keys() {
        return this.tree.toList().map(P2.__1());
    }

    public boolean contains(K k) {
        return this.tree.member(P.p(k, Option.none()));
    }

    @Override
    public Iterator<P2<K, V>> iterator() {
        return IterableW.join(this.tree.toStream().map(P2.map2_(IterableW.wrap())).map(P2.tuple(Function.compose(IterableW.map(), P.p2())))).iterator();
    }

    public Map<K, V> toMutableMap() {
        F fakePair = TreeMap$$Lambda$4.lambdaFactory$();
        Comparator comparator = this.tree.ord().contramap(fakePair).toComparator();
        java.util.TreeMap m = new java.util.TreeMap(comparator);
        for (P2<K, V> e : this) {
            m.put(e._1(), e._2());
        }
        return m;
    }

    public Stream<P2<K, V>> toStream() {
        return this.tree.toStream().map(TreeMap$$Lambda$5.lambdaFactory$());
    }

    public Stream<P2<K, V>> toStreamReverse() {
        return this.tree.toStreamReverse().map(TreeMap$$Lambda$6.lambdaFactory$());
    }

    public List<P2<K, V>> toList() {
        return this.tree.toList().map(TreeMap$$Lambda$7.lambdaFactory$());
    }

    public List<P2<K, V>> toListReverse() {
        return this.tree.toListReverse().map(TreeMap$$Lambda$8.lambdaFactory$());
    }

    public static <K, V> TreeMap<K, V> fromMutableMap(Ord<K> ord, Map<K, V> m) {
        TreeMap<K, V> t = TreeMap.empty(ord);
        for (Map.Entry<K, V> e : m.entrySet()) {
            t = t.set(e.getKey(), e.getValue());
        }
        return t;
    }

    public F<K, Option<V>> get() {
        return TreeMap$$Lambda$9.lambdaFactory$(this);
    }

    public P2<Boolean, TreeMap<K, V>> update(K k, F<V, V> f) {
        P2 up = this.tree.update(P.p(k, Option.none()), Function.compose(P2.tuple(P.p2()), P2.map2_(Option.map().f(f))));
        return P.p(up._1(), new TreeMap<K, V>(up._2()));
    }

    public TreeMap<K, V> update(K k, F<V, V> f, V v) {
        P2<Boolean, TreeMap<K, V>> up = this.update(k, f);
        return up._1() != false ? up._2() : this.set(k, v);
    }

    public P3<Set<V>, Option<V>, Set<V>> split(Ord<V> ord, K k) {
        F getSome = F1Functions.mapSet(F1Functions.o(Option.fromSome(), P2.__2()), ord);
        return this.tree.split(P.p(k, Option.none())).map1(getSome).map3(getSome).map2(F1Functions.o(Option.join(), F1Functions.mapOption(P2.__2())));
    }

    private static <K, V> TreeMap<K, V> treeMap(Ord<K> ord, Set<P2<K, Option<V>>> s) {
        TreeMap<K, V> empty = TreeMap.empty(ord);
        TreeMap<K, V> tree = s.toList().foldLeft(TreeMap$$Lambda$10.lambdaFactory$(), empty);
        return tree;
    }

    public P3<TreeMap<K, V>, Option<V>, TreeMap<K, V>> splitLookup(K k) {
        P3<Set<P2<K, Option<V>>>, Option<P2<K, Option<V>>>, Set<P2<K, Option<V>>>> p3 = this.tree.split(P.p(k, this.get(k)));
        Ord o = this.tree.ord().contramap(TreeMap$$Lambda$11.lambdaFactory$());
        return P.p(TreeMap.treeMap(o, p3._1()), this.get(k), TreeMap.treeMap(o, p3._3()));
    }

    public <W> TreeMap<K, W> map(F<V, W> f) {
        F g = Function.compose(TreeMap$$Lambda$12.lambdaFactory$(), P2.map2_(F1Functions.mapOption(f)));
        F coord = Function.flip(P.p2()).f(Option.none());
        Ord o = this.tree.ord().contramap(coord);
        return new TreeMap<K, V>(this.tree.map(TreeMap.ord(o), g));
    }

    public Option<P2<K, V>> min() {
        return this.tree.min().map(TreeMap$$Lambda$13.lambdaFactory$());
    }

    public Option<K> minKey() {
        return this.tree.min().map(TreeMap$$Lambda$14.lambdaFactory$());
    }

    public Option<P2<K, V>> max() {
        return this.tree.max().map(TreeMap$$Lambda$15.lambdaFactory$());
    }

    public Option<K> maxKey() {
        return this.tree.max().map(TreeMap$$Lambda$16.lambdaFactory$());
    }

    public TreeMap<K, V> union(TreeMap<K, V> t2) {
        TreeMap<K, V> result = t2;
        for (P2<K, V> p : this) {
            result = result.set(p._1(), p._2());
        }
        return result;
    }

    public TreeMap<K, V> union(Iterable<P2<K, V>> t2) {
        TreeMap<K, V> result = this;
        for (P2<K, V> p : t2) {
            if (this.contains(p._1())) continue;
            result = result.set(p._1(), p._2());
        }
        return result;
    }

    static /* synthetic */ P2 lambda$max$15(P2 p) {
        return P.p(p._1(), ((Option)p._2()).some());
    }

    static /* synthetic */ P2 lambda$min$14(P2 p) {
        return P.p(p._1(), ((Option)p._2()).some());
    }

    static /* synthetic */ P2 lambda$map$13(P2 p2) {
        return P.p(p2._1(), p2._2());
    }

    static /* synthetic */ P2 lambda$splitLookup$12(Object k2) {
        return P.p(k2, Option.none());
    }

    static /* synthetic */ TreeMap lambda$treeMap$11(TreeMap tm, P2 p2) {
        Option opt = (Option)p2._2();
        if (opt.isSome()) {
            return tm.set(p2._1(), opt.some());
        }
        return tm;
    }

    static /* synthetic */ P2 lambda$toListReverse$10(P2 p) {
        return p.map2(TreeMap$$Lambda$17.lambdaFactory$());
    }

    static /* synthetic */ Object lambda$null$9(Option o) {
        return o.some();
    }

    static /* synthetic */ P2 lambda$toList$8(P2 p) {
        return p.map2(TreeMap$$Lambda$18.lambdaFactory$());
    }

    static /* synthetic */ Object lambda$null$7(Option o) {
        return o.some();
    }

    static /* synthetic */ P2 lambda$toStreamReverse$6(P2 p) {
        return p.map2(TreeMap$$Lambda$19.lambdaFactory$());
    }

    static /* synthetic */ Object lambda$null$5(Option o) {
        return o.some();
    }

    static /* synthetic */ P2 lambda$toStream$4(P2 p) {
        return p.map2(TreeMap$$Lambda$20.lambdaFactory$());
    }

    static /* synthetic */ Object lambda$null$3(Option o) {
        return o.some();
    }

    static /* synthetic */ P2 lambda$toMutableMap$2(Object k) {
        return P.p(k, Option.none());
    }

    static /* synthetic */ Iterator lambda$iteratorTreeMap$1(Iterator it) {
        return it;
    }

    static /* synthetic */ Equal lambda$equals$0() {
        return Equal.treeMapEqual(Equal.anyEqual(), Equal.anyEqual());
    }
}

