/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.P;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Array;
import fj.data.List;
import fj.data.Option;
import fj.data.Seq$$Lambda$1;
import fj.data.Seq$$Lambda$2;
import fj.data.Seq$$Lambda$3;
import fj.data.Seq$$Lambda$4;
import fj.data.Seq$$Lambda$5;
import fj.data.Seq$$Lambda$6;
import fj.data.Seq$$Lambda$7;
import fj.data.Stream;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Seq<A>
implements Iterable<A> {
    private static final Measured<Integer, Object> ELEM_MEASURED = FingerTree.measured(Monoid.intAdditionMonoid, Function.constant(1));
    private static final MakeTree<Integer, Object> MK_TREE = FingerTree.mkTree(ELEM_MEASURED);
    private static final Seq<Object> EMPTY = new Seq<Object>(MK_TREE.empty());
    private final FingerTree<Integer, A> ftree;

    private static <A> MakeTree<Integer, A> mkTree() {
        return MK_TREE;
    }

    private Seq(FingerTree<Integer, A> ftree) {
        this.ftree = ftree;
    }

    private static <A> Measured<Integer, A> elemMeasured() {
        return ELEM_MEASURED;
    }

    public static <A> Seq<A> empty() {
        return EMPTY;
    }

    public boolean equals(Object other) {
        return Equal.equals0(Seq.class, this, other, Seq$$Lambda$1.lambdaFactory$());
    }

    public static <A> Seq<A> single(A a) {
        return new Seq<A>(Seq.mkTree().single(a));
    }

    @SafeVarargs
    public static <A> Seq<A> seq(A ... as) {
        return Seq.arraySeq(as);
    }

    @Deprecated
    public static <A> Seq<A> seq(List<A> list) {
        return Seq.iterableSeq(list);
    }

    @Deprecated
    public static <A> Seq<A> listSeq(List<A> list) {
        return Seq.iterableSeq(list);
    }

    public static <A> Seq<A> iterableSeq(Iterable<A> i) {
        Seq<A> s = Seq.empty();
        for (A a : i) {
            s = s.snoc(a);
        }
        return s;
    }

    public static <A> Seq<A> iteratorSeq(Iterator<A> i) {
        return Seq.iterableSeq(Seq$$Lambda$2.lambdaFactory$(i));
    }

    @SafeVarargs
    public static <A> Seq<A> arraySeq(A ... as) {
        return Seq.iterableSeq(Array.array(as));
    }

    public static <A> Seq<A> fromJavaList(java.util.List<A> list) {
        return Seq.iterableSeq(list);
    }

    public Seq<A> cons(A a) {
        return new Seq<A>(this.ftree.cons(a));
    }

    public Seq<A> snoc(A a) {
        return new Seq<A>(this.ftree.snoc(a));
    }

    public A head() {
        return this.ftree.head();
    }

    public Option<A> headOption() {
        return this.ftree.headOption();
    }

    public A last() {
        return this.ftree.last();
    }

    public Seq<A> tail() {
        return this.length() == 1 ? Seq.empty() : new Seq<A>(this.ftree.tail());
    }

    public Seq<A> init() {
        return this.length() == 1 ? Seq.empty() : new Seq<A>(this.ftree.init());
    }

    public Stream<A> toStream() {
        return this.ftree.foldLeft(Seq$$Lambda$3.lambdaFactory$(), Stream.nil()).reverse();
    }

    public List<A> toList() {
        List.Buffer<A> buf = List.Buffer.empty();
        for (A a : this) {
            buf.snoc(a);
        }
        return buf.toList();
    }

    public java.util.List<A> toJavaList() {
        return new AbstractList<A>(){

            @Override
            public A get(int i) {
                return Seq.this.index(i);
            }

            @Override
            public Iterator<A> iterator() {
                return Seq.this.iterator();
            }

            @Override
            public int size() {
                return Seq.this.length();
            }
        };
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private FingerTree<Integer, A> ftree;
            {
                this.ftree = Seq.this.ftree;
            }

            @Override
            public boolean hasNext() {
                return !this.ftree.isEmpty();
            }

            @Override
            public A next() {
                if (this.ftree.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object a = this.ftree.head();
                this.ftree = this.ftree.tail();
                return a;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return Show.seqShow(Show.anyShow()).showS(this);
    }

    public Seq<A> append(Seq<A> as) {
        return new Seq<A>(this.ftree.append(as.ftree));
    }

    public boolean isEmpty() {
        return this.ftree.isEmpty();
    }

    public Seq<A> insert(int index, A a) {
        P2<Seq<A>, Seq<A>> p = this.split(index);
        return p._1().append(Seq.single(a)).append(p._2());
    }

    public boolean isNotEmpty() {
        return !this.ftree.isEmpty();
    }

    public int length() {
        return this.ftree.measure();
    }

    public P2<Seq<A>, Seq<A>> split(int i) {
        P2<FingerTree<Integer, A>, FingerTree<Integer, A>> lr = this.ftree.split(Seq$$Lambda$4.lambdaFactory$(i));
        return P.p(new Seq<A>(lr._1()), new Seq<A>(lr._2()));
    }

    public A index(int i) {
        this.checkBounds(i);
        return this.ftree.lookup(Function.identity(), i)._2();
    }

    public Seq<A> update(int i, A a) {
        this.checkBounds(i);
        P3<FingerTree<Integer, A>, A, FingerTree<Integer, A>> lxr = this.ftree.split1(Seq$$Lambda$5.lambdaFactory$(i));
        return new Seq<A>(lxr._1().append(lxr._3().cons(a)));
    }

    public Seq<A> delete(int i) {
        this.checkBounds(i);
        P3<FingerTree<Integer, A>, A, FingerTree<Integer, A>> lxr = this.ftree.split1(Seq$$Lambda$6.lambdaFactory$(i));
        return new Seq<A>(lxr._1().append(lxr._3()));
    }

    public Seq<A> take(int n) {
        return this.split(n)._1();
    }

    public Seq<A> drop(int n) {
        return this.split(n)._2();
    }

    private void checkBounds(int i) {
        if (i < 0 || i >= this.length()) {
            throw Bottom.error("Index " + i + " is out of bounds.");
        }
    }

    public <B> B foldLeft(F2<B, A, B> f, B z) {
        return this.ftree.foldLeft(f, z);
    }

    public <B> B foldRight(F2<A, B, B> f, B z) {
        return this.ftree.foldRight(f, z);
    }

    public Seq<A> filter(F<A, Boolean> f) {
        return this.foldLeft(Seq$$Lambda$7.lambdaFactory$(f), Seq.<A>empty());
    }

    public int hashCode() {
        return Hash.seqHash(Hash.anyHash()).hash(this);
    }

    public <B> Seq<B> map(F<A, B> f) {
        return new Seq<B>(this.ftree.map(f, Seq.<A>elemMeasured()));
    }

    static /* synthetic */ Seq lambda$filter$6(F f, Seq acc, Object a) {
        return (Boolean)f.f(a) != false ? acc.snoc(a) : acc;
    }

    static /* synthetic */ Boolean lambda$delete$5(int i, Integer index) {
        return index > i;
    }

    static /* synthetic */ Boolean lambda$update$4(int i, Integer index) {
        return index > i;
    }

    static /* synthetic */ Boolean lambda$split$3(int i, Integer index) {
        return index > i;
    }

    static /* synthetic */ Stream lambda$toStream$2(Stream b, Object a) {
        return b.cons(a);
    }

    static /* synthetic */ Iterator lambda$iteratorSeq$1(Iterator i) {
        return i;
    }

    static /* synthetic */ Equal lambda$equals$0() {
        return Equal.seqEqual(Equal.anyEqual());
    }
}

