/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Show;
import fj.data.List;
import fj.data.Option;
import fj.data.PriorityQueue$$Lambda$1;
import fj.data.PriorityQueue$$Lambda$10;
import fj.data.PriorityQueue$$Lambda$11;
import fj.data.PriorityQueue$$Lambda$12;
import fj.data.PriorityQueue$$Lambda$13;
import fj.data.PriorityQueue$$Lambda$14;
import fj.data.PriorityQueue$$Lambda$2;
import fj.data.PriorityQueue$$Lambda$3;
import fj.data.PriorityQueue$$Lambda$4;
import fj.data.PriorityQueue$$Lambda$5;
import fj.data.PriorityQueue$$Lambda$6;
import fj.data.PriorityQueue$$Lambda$7;
import fj.data.PriorityQueue$$Lambda$8;
import fj.data.PriorityQueue$$Lambda$9;
import fj.data.Stream;
import fj.data.fingertrees.FingerTree;

public final class PriorityQueue<K, A> {
    private final FingerTree<K, P2<K, A>> ftree;
    private final Equal<K> equal;

    private PriorityQueue(Equal<K> e, FingerTree<K, P2<K, A>> ft) {
        this.equal = e;
        this.ftree = ft;
    }

    public static <K, A> PriorityQueue<K, A> priorityQueue(Equal<K> e, FingerTree<K, P2<K, A>> ft) {
        return new PriorityQueue<K, A>(e, ft);
    }

    public static <K, A> PriorityQueue<K, A> empty(Monoid<K> m, Equal<K> e) {
        return PriorityQueue.priorityQueue(e, FingerTree.empty(m, P2.__1()));
    }

    public static <A> PriorityQueue<Integer, A> emptyInt() {
        return PriorityQueue.empty(Monoid.intMaxMonoid, Equal.intEqual);
    }

    public <B> PriorityQueue<K, B> map(F<A, B> f) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.map(P2.map2_(f), FingerTree.measured(this.ftree.measured().monoid(), P2.__1())));
    }

    public PriorityQueue<K, A> filterValues(F<A, Boolean> f) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.filter(PriorityQueue$$Lambda$1.lambdaFactory$(f)));
    }

    public PriorityQueue<K, A> filterKeys(F<K, Boolean> f) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.filter(PriorityQueue$$Lambda$2.lambdaFactory$(f)));
    }

    public boolean isEmpty() {
        return this.ftree.isEmpty();
    }

    public Option<P2<K, A>> top() {
        return this.unqueue(Option.none(), PriorityQueue$$Lambda$3.lambdaFactory$());
    }

    public List<P2<K, A>> topN() {
        return this.toStream().uncons(List.nil(), PriorityQueue$$Lambda$4.lambdaFactory$(this));
    }

    public PriorityQueue<K, A> enqueue(K k, A a) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.snoc(P.p(k, a)));
    }

    public PriorityQueue<K, A> enqueue(List<P2<K, A>> list) {
        return list.foldLeft(PriorityQueue$$Lambda$5.lambdaFactory$(), this);
    }

    public boolean contains(K k) {
        return !this.ftree.split(this.equal.eq(k))._2().isEmpty();
    }

    public PriorityQueue<K, A> enqueue(Iterable<P2<K, A>> it) {
        PriorityQueue<K, A> result = this;
        for (P2<K, A> p : it) {
            result = result.enqueue(p);
        }
        return result;
    }

    public PriorityQueue<K, A> enqueue(P2<K, A> p) {
        return this.enqueue(p._1(), p._2());
    }

    public PriorityQueue<K, A> dequeue() {
        return this.unqueue(this, PriorityQueue$$Lambda$6.lambdaFactory$());
    }

    public P2<Option<P2<K, A>>, PriorityQueue<K, A>> topDequeue() {
        return this.unqueue(P.p(Option.none(), this), PriorityQueue$$Lambda$7.lambdaFactory$());
    }

    public <B> B unqueue(B empty, F2<P2<K, A>, PriorityQueue<K, A>, B> topDequeue) {
        K top = this.ftree.measure();
        P2<FingerTree<K, P2<K, A>>, FingerTree<K, P2<K, A>>> p = this.ftree.split(this.equal.eq(top));
        return p._2().uncons(empty, PriorityQueue$$Lambda$8.lambdaFactory$(this, topDequeue, p));
    }

    public PriorityQueue<K, A> dequeue(int n) {
        int i = n;
        PriorityQueue<K, A> result = this;
        while (i > 0) {
            --i;
            result = result.dequeue();
        }
        return result;
    }

    public boolean isLessThan(Ord<K> ok, K k) {
        return this.top().option(true, PriorityQueue$$Lambda$9.lambdaFactory$(ok, k));
    }

    public boolean isGreaterThan(Ord<K> ok, K k) {
        return this.top().option(false, PriorityQueue$$Lambda$10.lambdaFactory$(ok, k));
    }

    public boolean isEqual(Ord<K> ok, K k) {
        return this.top().option(false, PriorityQueue$$Lambda$11.lambdaFactory$(ok, k));
    }

    public Stream<P2<K, A>> toStream() {
        return this.unqueue(Stream.nil(), PriorityQueue$$Lambda$12.lambdaFactory$());
    }

    public List<P2<K, A>> toList() {
        return this.toStream().toList();
    }

    public String toString() {
        return Show.priorityQueueShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    static /* synthetic */ Stream lambda$toStream$13(P2 top, PriorityQueue tail) {
        return Stream.cons(top, PriorityQueue$$Lambda$13.lambdaFactory$(tail));
    }

    static /* synthetic */ Stream lambda$null$12(PriorityQueue tail) {
        return tail.toStream();
    }

    static /* synthetic */ Boolean lambda$isEqual$11(Ord ok, Object k, P2 p) {
        return ok.eq(p._1(), k);
    }

    static /* synthetic */ Boolean lambda$isGreaterThan$10(Ord ok, Object k, P2 p) {
        return ok.isGreaterThan(p._1(), k);
    }

    static /* synthetic */ Boolean lambda$isLessThan$9(Ord ok, Object k, P2 p) {
        return ok.isLessThan(p._1(), k);
    }

    static /* synthetic */ Object lambda$unqueue$8(PriorityQueue this_, F2 topDequeue, P2 p, P2 head, FingerTree tail) {
        return topDequeue.f(head, PriorityQueue.priorityQueue(this_.equal, ((FingerTree)p._1()).append(tail)));
    }

    static /* synthetic */ P2 lambda$topDequeue$7(P2 top, PriorityQueue tail) {
        return P.p(Option.some(top), tail);
    }

    static /* synthetic */ PriorityQueue lambda$dequeue$6(P2 top, PriorityQueue tail) {
        return tail;
    }

    static /* synthetic */ PriorityQueue lambda$enqueue$5(PriorityQueue pq, P2 p) {
        return pq.enqueue(p._1(), p._2());
    }

    static /* synthetic */ F lambda$topN$4(PriorityQueue this_, P2 top) {
        return PriorityQueue$$Lambda$14.lambdaFactory$(this_, top);
    }

    static /* synthetic */ List lambda$null$3(PriorityQueue this_, P2 top, P1 tail) {
        return List.cons(top, ((Stream)tail._1()).takeWhile(Function.compose(this_.equal.eq(top._1()), P2.__1())).toList());
    }

    static /* synthetic */ Option lambda$top$2(P2 top, PriorityQueue tail) {
        return Option.some(top);
    }

    static /* synthetic */ Boolean lambda$filterKeys$1(F f, P2 p2) {
        return (Boolean)f.f(p2._1());
    }

    static /* synthetic */ Boolean lambda$filterValues$0(F f, P2 p2) {
        return (Boolean)f.f(p2._2());
    }
}

